/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.Statistics;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.github.dockerjava.jaxrs.JerseyDockerCmdExecFactory;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.browser.BrowserType;
import org.kurento.test.docker.FirstObjectResultCallback;
import org.kurento.test.utils.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Docker
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Docker.class);
    private static final String DOCKER_SERVER_URL_PROPERTY = "docker.server.url";
    private static final String DOCKER_SERVER_URL_DEFAULT = "unix:///var/run/docker.sock";
    public static final String DOCKER_CONTAINER_NAME_PROPERTY = "docker.container.name";
    private static final int WAIT_CONTAINER_POLL_TIME = 200;
    private static final int WAIT_CONTAINER_POLL_TIMEOUT = 10;
    private static Docker singleton = null;
    private static Boolean isRunningInContainer;
    private DockerClient client;
    private JerseyDockerCmdExecFactory execFactory;
    private String containerName;
    private String dockerServerUrl;
    private Map<String, String> recordingNameMap = new ConcurrentHashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Docker getSingleton(String dockerServerUrl) {
        if (singleton != null) return singleton;
        Class<Docker> clazz = Docker.class;
        synchronized (Docker.class) {
            if (singleton != null) return singleton;
            singleton = new Docker(dockerServerUrl);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public static Docker getSingleton() {
        return Docker.getSingleton(PropertiesManager.getProperty((String)DOCKER_SERVER_URL_PROPERTY, (String)Docker.getDefaultDockerServerUrl()));
    }

    private static String getDefaultDockerServerUrl() {
        return DOCKER_SERVER_URL_DEFAULT;
    }

    public Docker(String dockerServerUrl) {
        this.dockerServerUrl = dockerServerUrl;
    }

    public boolean isRunningInContainer() {
        return Docker.isRunningInContainerInternal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized boolean isRunningInContainerInternal() {
        if (isRunningInContainer != null) return isRunningInContainer;
        try (BufferedReader br = Files.newBufferedReader(Paths.get("/proc/1/cgroup", new String[0]), StandardCharsets.UTF_8);){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.contains("/docker")) continue;
                boolean bl = true;
                return bl;
            }
            isRunningInContainer = false;
            return isRunningInContainer;
        }
        catch (IOException e) {
            isRunningInContainer = false;
        }
        return isRunningInContainer;
    }

    public boolean isRunningContainer(String containerName) {
        boolean isRunning = this.inspectContainer(containerName).getState().getRunning();
        log.trace("Container {} is running: {}", (Object)containerName, (Object)isRunning);
        return isRunning;
    }

    public boolean existsImage(String imageName) {
        boolean exists = true;
        try {
            this.getClient().inspectImageCmd(imageName).exec();
            log.trace("Image {} exists", (Object)imageName);
        }
        catch (NotFoundException e) {
            log.trace("Image {} does not exist", (Object)imageName);
            exists = false;
        }
        return exists;
    }

    public void createContainer(String imageId, String containerName, boolean mountFolders, String ... env) {
        this.pullImageIfNecessary(imageId, false);
        log.debug("Creating container {}", (Object)containerName);
        CreateContainerCmd createContainerCmd = this.getClient().createContainerCmd(imageId).withName(containerName).withEnv(env).withVolumes(new Volume[]{new Volume("/var/run/docker.sock")});
        if (mountFolders) {
            this.mountDefaultFolders(createContainerCmd);
        }
        createContainerCmd.exec();
        log.debug("Container {} started...", (Object)containerName);
    }

    public void mountFiles(CreateContainerCmd createContainerCmd) {
        String videoFilesDiskPath = "/var/lib/jenkins/test-files";
        Volume configVol = new Volume(KurentoTest.getTestFilesDiskPath());
        createContainerCmd.withVolumes(new Volume[]{configVol}).withBinds(new Bind[]{new Bind(videoFilesDiskPath, configVol)});
    }

    public void mountDefaultFolders(CreateContainerCmd createContainerCmd) {
        this.mountDefaultFolders(createContainerCmd, null);
    }

    public void mountDefaultFolders(CreateContainerCmd createContainerCmd, String configFilePath) {
        boolean runningInContainer = this.isRunningInContainer();
        log.debug("Mounting default folders. Running inside container: {}", (Object)runningInContainer);
        if (runningInContainer) {
            createContainerCmd.withVolumesFrom(new VolumesFrom[]{new VolumesFrom(this.getContainerId())});
            if (configFilePath != null) {
                String workspace = PropertiesManager.getProperty((String)"test.workspace", (String)"/tmp");
                String workspaceHost = PropertiesManager.getProperty((String)"test.workspace.host", (String)"/tmp");
                String hostConfigFilePath = Paths.get(workspaceHost, new String[0]).resolve(Paths.get(workspace, new String[0]).relativize(Paths.get(configFilePath, new String[0]))).toString();
                log.debug("Config file volume {}", (Object)hostConfigFilePath);
                Volume configVol = new Volume("/opt/selenium/config.json");
                createContainerCmd.withVolumes(new Volume[]{configVol}).withBinds(new Bind[]{new Bind(hostConfigFilePath, configVol)});
            }
        } else {
            String testFilesPath = KurentoTest.getTestFilesDiskPath();
            Volume testFilesVolume = new Volume(testFilesPath);
            String workspacePath = Paths.get(KurentoTest.getTestDir(), new String[0]).toAbsolutePath().toString();
            Volume workspaceVolume = new Volume(workspacePath);
            Volume configVol = new Volume("/opt/selenium/config.json");
            Volume dockerSock = new Volume("/var/run/docker.sock");
            if (configFilePath != null) {
                createContainerCmd.withVolumes(new Volume[]{testFilesVolume, workspaceVolume, configVol, dockerSock}).withBinds(new Bind[]{new Bind(testFilesPath, testFilesVolume, AccessMode.ro), new Bind(workspacePath, workspaceVolume, AccessMode.rw), new Bind(configFilePath, configVol)});
            } else {
                createContainerCmd.withVolumes(new Volume[]{testFilesVolume, workspaceVolume, dockerSock}).withBinds(new Bind[]{new Bind(testFilesPath, testFilesVolume, AccessMode.ro), new Bind(workspacePath, workspaceVolume, AccessMode.rw)});
            }
        }
    }

    public void pullImageIfNecessary(String imageId, boolean force) {
        if (imageId.isEmpty()) {
            return;
        }
        if (force || !this.existsImage(imageId)) {
            log.debug("Pulling Docker image {} ... please be patient until the process finishes", (Object)imageId);
            try {
                ((PullImageResultCallback)this.getClient().pullImageCmd(imageId).exec((ResultCallback)new PullImageResultCallback())).awaitCompletion();
            }
            catch (Exception e) {
                log.warn("Exception pulling image {}", (Object)imageId, (Object)e);
            }
            log.debug("Image {} downloaded", (Object)imageId);
        } else {
            log.debug("Image {} already exists", (Object)imageId);
        }
    }

    public InspectContainerResponse inspectContainer(String containerName) {
        return this.getClient().inspectContainerCmd(containerName).exec();
    }

    public void startContainer(String containerName) {
        if (!this.isRunningContainer(containerName)) {
            log.debug("Starting container {}", (Object)containerName);
            this.getClient().startContainerCmd(containerName).exec();
            log.debug("Started container {}", (Object)containerName);
        } else {
            log.debug("Container {} is already started", (Object)containerName);
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.execFactory.close();
                this.getClient().close();
            }
            catch (IOException e) {
                log.error("Exception closing Docker client", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerClient getClient() {
        if (this.client == null) {
            Docker docker = this;
            synchronized (docker) {
                if (this.client == null) {
                    this.execFactory = new JerseyDockerCmdExecFactory();
                    JerseyDockerCmdExecFactory dockerCmdExecFactory = this.execFactory.withMaxPerRouteConnections(Integer.valueOf(100));
                    this.client = DockerClientBuilder.getInstance((String)this.dockerServerUrl).withDockerCmdExecFactory((DockerCmdExecFactory)dockerCmdExecFactory).build();
                }
            }
        }
        return this.client;
    }

    public void stopContainers(boolean withRecording, String ... containerNames) {
        for (String containerName : containerNames) {
            this.stopContainer(containerName, withRecording);
        }
    }

    public void stopContainer(String containerName, boolean withRecording) {
        if (this.isRunningContainer(containerName)) {
            log.debug("Stopping container {}", (Object)containerName);
            if (withRecording) {
                String stopRecordingOutput = this.execCommand(containerName, true, "stop-video-recording.sh");
                log.debug("Stopping recording in container {}:", (Object)containerName, (Object)stopRecordingOutput);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    log.warn("Exception waiting for recording file", (Throwable)e);
                }
                if (this.recordingNameMap.containsKey(containerName)) {
                    String recordingName = this.recordingNameMap.get(containerName);
                    this.copyFileFromContainer(containerName, "/home/ubuntu/recordings/" + recordingName + ".mp4", KurentoTest.getDefaultOutputFolder().getAbsolutePath());
                    this.recordingNameMap.remove(containerName);
                }
            }
            this.getClient().stopContainerCmd(containerName).exec();
        } else {
            log.debug("Container {} is not running", (Object)containerName);
        }
    }

    public String getBrowserIdFromContainerName(String containerName) {
        int j;
        int i;
        String keyword = "JOB_SETUP";
        int indexOfKeyWord = containerName.indexOf(keyword);
        if (indexOfKeyWord != -1 && (i = containerName.indexOf("-", keyword.length() + indexOfKeyWord + 1)) != -1 && (j = containerName.indexOf("-", i + 1)) != -1) {
            containerName = containerName.substring(i + 1, j);
        }
        return containerName;
    }

    public void listFolderInContainer(String containerName, String folderName) {
        String lsRecordingsFolder = this.execCommand(containerName, true, "ls", "-la", folderName);
        log.debug("List of folder {} in container {}:\n{}", new Object[]{folderName, containerName, lsRecordingsFolder});
    }

    public void removeContainers(String ... containerNames) {
        for (String containerName : containerNames) {
            this.removeContainer(containerName);
        }
    }

    public void removeContainer(String containerName) {
        log.debug("Removing container {}", (Object)containerName);
        boolean removed = false;
        int count = 0;
        do {
            try {
                this.getClient().removeContainerCmd(containerName).withRemoveVolumes(Boolean.valueOf(true)).exec();
                log.trace("*** Only for debugging: After Docker.removeContainer({}). Times: {}", (Object)containerName, (Object)(++count));
                removed = true;
            }
            catch (Throwable e) {
                if (count == 10) {
                    log.trace("*** Only for debugging: Exception {} -> Docker.removeContainer({}).", (Object)containerName, (Object)e.getMessage());
                }
                try {
                    log.trace("Waiting for removing {}. Times: {}", (Object)containerName, (Object)count);
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (!removed && count <= 10);
    }

    public void stopAndRemoveContainer(String containerName, boolean withRecording) {
        this.stopContainer(containerName, withRecording);
        this.removeContainer(containerName);
    }

    public void startNode(String id, BrowserType browserType, String nodeName, String imageId, boolean record) {
        this.pullImageIfNecessary(imageId, true);
        log.debug("Creating container for browser '{}'", (Object)id);
        CreateContainerCmd createContainerCmd = this.getClient().createContainerCmd(imageId).withPrivileged(Boolean.valueOf(true)).withCapAdd(new Capability[]{Capability.SYS_ADMIN}).withName(nodeName);
        this.mountDefaultFolders(createContainerCmd);
        this.mountFiles(createContainerCmd);
        if (this.isRunningInContainer()) {
            createContainerCmd.withNetworkMode("bridge");
        }
        createContainerCmd.exec();
        log.debug("Container {} started...", (Object)nodeName);
        this.startContainer(nodeName);
        this.startRecordingIfNeeded(id, nodeName, record);
        this.logMounts(nodeName);
        this.logNetworks(nodeName);
        this.listFolderInContainer(nodeName, KurentoTest.getTestFilesDiskPath());
    }

    private void logMounts(String containerId) {
        InspectContainerResponse exec = this.getClient().inspectContainerCmd(containerId).exec();
        List mounts = exec.getMounts();
        log.debug("There are {} mount(s) in the container {}:", (Object)mounts.size(), (Object)containerId);
        for (int i = 0; i < mounts.size(); ++i) {
            InspectContainerResponse.Mount mount = (InspectContainerResponse.Mount)mounts.get(i);
            log.debug("{}) {} -> {} ({})", new Object[]{i + 1, mount.getSource(), mount.getDestination(), mount.getMode()});
        }
    }

    private void logNetworks(String containerId) {
        Map networks = this.getClient().inspectContainerCmd(containerId).exec().getNetworkSettings().getNetworks();
        int networksSize = networks.size();
        log.debug("There are {} network(s) in the container {}", (Object)networksSize, (Object)containerId);
        if (networksSize == 0) {
            return;
        }
        int i = 0;
        for (Map.Entry network : networks.entrySet()) {
            log.debug("{}) {} -> {}", new Object[]{++i, network.getKey(), network.getValue()});
        }
    }

    private void startRecordingIfNeeded(String id, String containerName, boolean record) {
        if (record) {
            String browserId = this.getBrowserIdFromContainerName(containerName);
            String recordingName = KurentoTest.getSimpleTestName() + "-" + browserId + "-recording";
            this.recordingNameMap.put(containerName, recordingName);
            log.debug("Starting recording in container {} (browser {}) (target file {})", new Object[]{containerName, browserId, recordingName});
            String startRecordingOutput = this.execCommand(containerName, false, "start-video-recording.sh", "-n", recordingName);
            log.debug("Recording in container {} started (command result {})", (Object)containerName, (Object)startRecordingOutput);
        }
    }

    public void startNode(String id, BrowserType browserType, String nodeName, String imageId, boolean record, String containerIp) {
        this.pullImageIfNecessary(imageId, true);
        log.debug("Creating container for browser '{}'", (Object)id);
        CreateContainerCmd createContainerCmd = this.getClient().createContainerCmd(imageId).withPrivileged(Boolean.valueOf(true)).withCapAdd(new Capability[]{Capability.SYS_ADMIN}).withName(nodeName);
        this.mountDefaultFolders(createContainerCmd);
        this.mountFiles(createContainerCmd);
        createContainerCmd.withNetworkMode("none");
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("KurentoDnat", "true");
        labels.put("Transport", PropertiesManager.getProperty((String)"test.selenium.transport"));
        labels.put("IpAddress", containerIp);
        createContainerCmd.withLabels(labels);
        createContainerCmd.exec();
        log.debug("Container {} started...", (Object)nodeName);
        this.startContainer(nodeName);
        this.startRecordingIfNeeded(id, nodeName, record);
        this.logMounts(nodeName);
        this.logNetworks(nodeName);
    }

    public void startAndWaitNode(String id, BrowserType browserType, String nodeName, String imageId, boolean record) {
        this.startNode(id, browserType, nodeName, imageId, record);
        this.waitForContainer(nodeName);
    }

    public void startAndWaitNode(String id, BrowserType browserType, String nodeName, String imageId, boolean record, String containerIp) {
        this.startNode(id, browserType, nodeName, imageId, record, containerIp);
        this.waitForContainer(nodeName);
    }

    public void waitForContainer(String containerName) {
        boolean isRunning = false;
        long timeoutMs = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        do {
            if (System.currentTimeMillis() > timeoutMs) {
                throw new KurentoException("Timeout of 10 seconds waiting for container " + containerName);
            }
            isRunning = this.isRunningContainer(containerName);
            if (isRunning) continue;
            try {
                log.debug("Container {} is not still running ... waiting {} ms", (Object)containerName, (Object)200);
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                log.error("Exception waiting for hub");
            }
        } while (!isRunning);
    }

    public String getContainerId() {
        try {
            BufferedReader br = Files.newBufferedReader(Paths.get("/proc/self/cgroup", new String[0]), StandardCharsets.UTF_8);
            String line = null;
            while ((line = br.readLine()) != null) {
                log.debug(line);
                if (!line.contains("docker")) continue;
                return line.substring(line.lastIndexOf(47) + 1, line.length());
            }
            throw new DockerClientException("Exception obtaining containerId. The file /proc/self/cgroup doesn't contain a line with 'docker'");
        }
        catch (IOException e) {
            throw new DockerClientException("Exception obtaining containerId. Exception reading file /proc/self/cgroup", (Throwable)e);
        }
    }

    public String getContainerName() {
        if (!this.isRunningInContainer()) {
            throw new DockerClientException("Can't obtain container name if not running in container");
        }
        if (this.containerName == null) {
            this.containerName = System.getProperty(DOCKER_CONTAINER_NAME_PROPERTY);
            if (this.containerName == null) {
                String containerId = this.getContainerId();
                this.containerName = this.inspectContainer(containerId).getName();
                this.containerName = this.containerName.substring(1);
            }
        }
        return this.containerName;
    }

    public String getContainerIpAddress() {
        if (this.isRunningInContainer()) {
            String ipAddr = this.getContainerNetworks().values().iterator().next().getIpAddress();
            log.trace("Docker container IP address {}", (Object)ipAddr);
            return ipAddr;
        }
        throw new DockerClientException("Can't obtain container ip address if not running in container");
    }

    public Map<String, ContainerNetwork> getContainerNetworks() {
        if (this.isRunningInContainer()) {
            Map networks = this.inspectContainer(this.getContainerName()).getNetworkSettings().getNetworks();
            log.trace("Docker container networks {}", (Object)networks);
            return networks;
        }
        throw new DockerClientException("Can't obtain container ip address if not running in container");
    }

    public String getContainerFirstNetworkName() {
        return this.getContainerNetworks().keySet().iterator().next();
    }

    public String getHostIpForContainers() {
        try {
            Enumeration<NetworkInterface> b = NetworkInterface.getNetworkInterfaces();
            while (b.hasMoreElements()) {
                NetworkInterface iface = b.nextElement();
                if (!iface.getName().contains("docker")) continue;
                for (InterfaceAddress f : iface.getInterfaceAddresses()) {
                    if (!f.getAddress().isSiteLocalAddress()) continue;
                    String addr = f.getAddress().toString();
                    log.debug("Host IP for container is {}", (Object)addr);
                    return addr;
                }
            }
        }
        catch (SocketException e) {
            log.warn("Exception getting docker address", (Throwable)e);
        }
        return null;
    }

    public String generateIpAddressForContainer() {
        String baseIpAddress = "172.17";
        String ipAddress = "";
        Random random = new Random();
        String output = "";
        do {
            Integer x = random.nextInt(240) + 1;
            Integer y = random.nextInt(240) + 1;
            ipAddress = baseIpAddress + "." + x + "." + y;
        } while (!(output = Shell.runAndWaitString("ping -c 1 " + ipAddress)).contains("Destination Host Unreachable"));
        log.debug("Ip address generated: {}", (Object)ipAddress);
        return ipAddress;
    }

    public void downloadLog(String containerName, Path file) throws IOException {
        LogContainerRetrieverCallback loggingCallback = new LogContainerRetrieverCallback(file);
        this.getClient().logContainerCmd(containerName).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).exec((ResultCallback)loggingCallback);
        try {
            loggingCallback.awaitCompletion();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while downloading logs for container {}", (Object)containerName);
        }
    }

    public Statistics getStatistics(String containerId) {
        FirstObjectResultCallback resultCallback = new FirstObjectResultCallback();
        try {
            return (Statistics)((FirstObjectResultCallback)this.getClient().statsCmd(containerId).exec(resultCallback)).waitForObject();
        }
        catch (InterruptedException e) {
            throw new KurentoException("Interrupted while waiting for statistics");
        }
    }

    public String execCommand(String containerId, boolean awaitCompletion, String ... command) {
        ExecCreateCmdResponse exec = (ExecCreateCmdResponse)this.client.execCreateCmd(containerId).withCmd(command).withTty(Boolean.valueOf(false)).withAttachStdin(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).exec();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String output = null;
        try {
            ExecStartResultCallback resultCallback = (ExecStartResultCallback)this.client.execStartCmd(exec.getId()).withDetach(Boolean.valueOf(false)).withTty(Boolean.valueOf(true)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)outputStream, (OutputStream)System.err));
            if (awaitCompletion) {
                resultCallback.awaitCompletion();
            }
            output = new String(outputStream.toByteArray());
        }
        catch (InterruptedException e) {
            log.warn("Exception executing command {} on container {}", new Object[]{Arrays.toString(command), containerId, e});
        }
        return output;
    }

    public void copyFileFromContainer(String containerName, String containerFile, String hostFolder) {
        log.trace("Copying {} from container {} to host folder {}", new Object[]{containerFile, containerName, hostFolder});
        try (TarArchiveInputStream tarStream = new TarArchiveInputStream(this.client.copyArchiveFromContainerCmd(containerName, containerFile).exec());){
            this.unTar(tarStream, new File(hostFolder));
        }
        catch (Exception e) {
            log.warn("Exception getting tar file from container {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unTar(TarArchiveInputStream tis, File destFolder) throws IOException {
        TarArchiveEntry entry = null;
        while ((entry = tis.getNextTarEntry()) != null) {
            OutputStream fos = null;
            try {
                if (entry.isDirectory()) continue;
                File curfile = new File(destFolder, entry.getName());
                File parent = curfile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                fos = new FileOutputStream(curfile);
                IOUtils.copy((InputStream)tis, (OutputStream)fos);
            }
            catch (Exception e) {
                log.warn("Exception extracting {} to {}", new Object[]{tis, destFolder, e});
            }
            finally {
                try {
                    if (fos == null) continue;
                    fos.flush();
                    ((FileOutputStream)fos).getFD().sync();
                    ((FileOutputStream)fos).close();
                }
                catch (IOException e) {
                    log.warn("Exception closing {}", (Object)fos, (Object)e);
                }
            }
        }
    }

    public static class LogContainerRetrieverCallback
    extends LogContainerResultCallback {
        private PrintWriter pw;

        public LogContainerRetrieverCallback(Path file) throws IOException {
            this.pw = new PrintWriter(Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));
        }

        public void onNext(Frame frame) {
            this.pw.append(new String(frame.getPayload()));
            super.onNext(frame);
        }

        public void onComplete() {
            this.pw.close();
            super.onComplete();
        }
    }
}

