/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.commons.ClassPath;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.commons.net.RemoteService;
import org.kurento.test.browser.WebPage;
import org.kurento.test.monitor.KmsDockerMonitor;
import org.kurento.test.monitor.KmsLocalMonitor;
import org.kurento.test.monitor.KmsMonitor;
import org.kurento.test.monitor.KmsSystemInfo;
import org.kurento.test.monitor.MonitorSample;
import org.kurento.test.monitor.MonitorSampleRegistrer;
import org.kurento.test.monitor.NetInfo;
import org.kurento.test.monitor.WebRtcClient;
import org.kurento.test.services.KmsService;
import org.kurento.test.utils.SshConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMonitorManager {
    public static Logger log = LoggerFactory.getLogger(SystemMonitorManager.class);
    public static final String OUTPUT_CSV = "/kms-monitor.csv";
    private KmsMonitor monitor;
    private SshConnection remoteKms;
    private int monitorPort;
    private long samplingTime = PropertiesManager.getProperty((String)"test.monitor.rate", (int)1000);
    private Thread thread;
    private ExecutorService executor;
    private int numClients = 0;
    private double currentLatency = 0.0;
    private int latencyHints = 0;
    private int latencyErrors = 0;
    private MonitorSampleRegistrer registrer = new MonitorSampleRegistrer();
    private List<WebRtcClient> clients = new CopyOnWriteArrayList<WebRtcClient>();

    public SystemMonitorManager(String kmsHost, String kmsLogin, String kmsPem) {
        try {
            this.monitorPort = PropertiesManager.getProperty((String)"kms.monitor.port", (int)12345);
            this.remoteKms = new SshConnection(kmsHost, kmsLogin, null, kmsPem);
            this.remoteKms.start();
            this.remoteKms.createTmpFolder();
            this.copyMonitorToRemoteKms();
            this.startRemoteProcessMonitor();
            this.monitor = new KmsLocalMonitor();
        }
        catch (Exception e) {
            throw new KurentoException((Throwable)e);
        }
    }

    public SystemMonitorManager() {
        try {
            String wsUri = PropertiesManager.getProperty((String)"kms.ws.uri", (String)"ws://localhost:8888/kurento");
            String kmsScope = PropertiesManager.getProperty((String)"test.kms.scope", (String)"local");
            boolean isKmsRemote = !wsUri.contains("localhost") && !wsUri.contains("127.0.0.1");
            boolean isKmsDocker = kmsScope.equalsIgnoreCase("docker");
            if (isKmsDocker) {
                String containerId = KmsService.getMonitoredDockerContainerName();
                log.debug("KMS container ID: {}", (Object)containerId);
                this.monitor = new KmsDockerMonitor(containerId);
            } else if (isKmsRemote) {
                String kmsLogin = PropertiesManager.getProperty((String)"kms.login");
                String kmsPasswd = PropertiesManager.getProperty((String)"kms.passwd");
                String kmsPem = PropertiesManager.getProperty((String)"kms.pem");
                this.startRemoteMonitor(wsUri, kmsLogin, kmsPasswd, kmsPem);
            } else {
                this.monitor = new KmsLocalMonitor();
            }
        }
        catch (Exception e) {
            throw new KurentoException((Throwable)e);
        }
    }

    private void startRemoteMonitor(String wsUri, String kmsLogin, String kmsPasswd, String kmsPem) throws IOException, URISyntaxException {
        this.monitorPort = PropertiesManager.getProperty((String)"kms.monitor.port", (int)12345);
        String remoteKmsStr = wsUri.substring(wsUri.indexOf("//") + 2, wsUri.lastIndexOf(":"));
        log.debug("Monitoring remote KMS at {}", (Object)remoteKmsStr);
        this.copyMonitor(kmsLogin, kmsPasswd, kmsPem, remoteKmsStr);
        this.startRemoteProcessMonitor();
    }

    private void copyMonitor(String kmsLogin, String kmsPasswd, String kmsPem, String remoteKmsStr) throws IOException, URISyntaxException {
        this.remoteKms = new SshConnection(remoteKmsStr, kmsLogin, kmsPasswd, kmsPem);
        this.remoteKms.start();
        this.remoteKms.createTmpFolder();
        this.copyMonitorToRemoteKms();
    }

    private void copyMonitorToRemoteKms() throws IOException, URISyntaxException {
        this.copyClassesToRemote(new Class[]{KmsMonitor.class, KmsLocalMonitor.class, NetInfo.class, NetInfo.NetInfoEntry.class, KmsSystemInfo.class});
    }

    private void copyClassesToRemote(Class<?>[] classesName) throws IOException {
        String targetFolder = this.remoteKms.getTmpFolder();
        for (Class<?> className : classesName) {
            String classFile = "/" + className.getName().replace(".", "/") + ".class";
            Path sourceClass = ClassPath.get((String)classFile);
            Path classFileInDisk = Files.createTempFile("", ".class", new FileAttribute[0]);
            Files.copy(sourceClass, classFileInDisk, StandardCopyOption.REPLACE_EXISTING);
            this.remoteKms.mkdirs(Paths.get(targetFolder + classFile, new String[0]).getParent().toString());
            this.remoteKms.scp(classFileInDisk.toString(), targetFolder + classFile);
            Files.delete(classFileInDisk);
        }
    }

    private void startRemoteProcessMonitor() throws IOException {
        this.remoteKms.execCommand("sh", "-c", "java -cp " + this.remoteKms.getTmpFolder() + " " + KmsLocalMonitor.class.getName() + " " + this.monitorPort + " > " + this.remoteKms.getTmpFolder() + "/monitor.log 2>&1");
        try {
            RemoteService.waitForReady((String)this.remoteKms.getHost(), (int)this.monitorPort, (int)60, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new KurentoException("Monitor in remote KMS is not available");
        }
    }

    public void startMonitoring() {
        final long startTime = new Date().getTime();
        this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.thread = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        SystemMonitorManager.this.executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                SystemMonitorManager.this.registerSample(startTime);
                            }
                        });
                        Thread.sleep(SystemMonitorManager.this.samplingTime);
                    }
                }
                catch (InterruptedException | KurentoException re) {
                    log.warn("Monitoring thread interrupted. Finishing execution");
                }
                catch (Exception e) {
                    log.error("Exception in system monitor manager", (Throwable)e);
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void registerSample(long start) {
        long time = new Date().getTime() - start;
        MonitorSample sample = new MonitorSample();
        KmsSystemInfo kmsInfo = this.remoteKms != null ? (KmsSystemInfo)this.sendMessage("measureKms") : this.monitor.measureKms();
        sample.setSystemInfo(kmsInfo);
        sample.setLatencyHints(this.latencyHints);
        sample.setLatencyErrors(this.latencyErrors);
        sample.setCurrentLatency(this.currentLatency);
        for (WebRtcClient client : this.clients) {
            sample.addWebRtcStats(client.getWebRtcStats());
        }
        sample.setNumClients(this.numClients);
        this.registrer.addSample(time, sample);
    }

    public void stop() {
        this.executor.shutdown();
        this.thread.interrupt();
        try {
            this.thread.join(3000L);
            if (this.thread.isAlive()) {
                log.warn("Monitoring thread not stopped 3s before interrupted. Force stop");
                this.thread.stop();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void writeResults(String csvFile) throws IOException {
        this.registrer.writeResults(csvFile);
    }

    private Object sendMessage(String message) {
        Object returnedMessage = null;
        try {
            log.debug("Sending message {} to {}", (Object)message, (Object)this.remoteKms.getHost());
            Socket client = new Socket(this.remoteKms.getHost(), this.monitorPort);
            PrintWriter output = new PrintWriter(client.getOutputStream(), true);
            ObjectInputStream input = new ObjectInputStream(client.getInputStream());
            output.println(message);
            returnedMessage = input.readObject();
            log.debug("Receive message {}", returnedMessage);
            output.close();
            input.close();
            client.close();
        }
        catch (Exception e) {
            throw new KurentoException((Throwable)e);
        }
        return returnedMessage;
    }

    public void destroy() {
        if (this.remoteKms != null) {
            this.sendMessage("destroy");
            this.remoteKms.stop();
        }
    }

    public void setSamplingTime(long samplingTime) {
        this.samplingTime = samplingTime;
    }

    public long getSamplingTime() {
        return this.samplingTime;
    }

    public synchronized void incrementNumClients() {
        ++this.numClients;
    }

    public synchronized void decrementNumClients() {
        --this.numClients;
    }

    public synchronized void incrementLatencyErrors() {
        ++this.latencyErrors;
    }

    public synchronized void addCurrentLatency(double currentLatency) {
        this.currentLatency += currentLatency;
        ++this.latencyHints;
    }

    public void addWebRtcClientAndActivateStats(String id, WebRtcEndpoint webRtcEndpoint, WebPage page, String peerConnectionId) {
        this.addWebRtcClientAndActivateInboundStats(id, webRtcEndpoint, page, peerConnectionId);
        this.addWebRtcClientAndActivateOutboundStats(id, webRtcEndpoint, page, peerConnectionId);
    }

    public void addWebRtcClientAndActivateOutboundStats(String id, WebRtcEndpoint webRtcEndpoint, WebPage page, String peerConnectionId) {
        page.activatePeerConnectionOutboundStats(peerConnectionId);
        this.addWebRtcClient(id, webRtcEndpoint, page);
    }

    public void addWebRtcClientAndActivateInboundStats(String id, WebRtcEndpoint webRtcEndpoint, WebPage page, String peerConnectionId) {
        page.activatePeerConnectionInboundStats(peerConnectionId);
        this.addWebRtcClient(id, webRtcEndpoint, page);
    }

    public void addWebRtcClient(String id, WebRtcEndpoint webRtcEndpoint, WebPage page) {
        this.clients.add(new WebRtcClient(id, webRtcEndpoint, page));
    }

    public void setShowLantency(boolean showLantency) {
        this.registrer.setShowLantency(showLantency);
    }
}

