/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import org.apache.catalina.connector.Connector;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.services.TestService;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;

public class WebServerService
extends TestService {
    private Class<?> webServerClass;
    protected ConfigurableApplicationContext context;

    public WebServerService() {
        this.webServerClass = WebServer.class;
    }

    public WebServerService(Class<?> webServerClass) {
        this.webServerClass = webServerClass;
    }

    @Override
    public void start() {
        super.start();
        System.setProperty("java.security.egd", "file:/dev/./urandom");
        this.startContext();
    }

    private void startContext() {
        this.context = new SpringApplication(new Class[]{this.webServerClass}).run(new String[]{"--server.port=" + WebServerService.getAppHttpsPort()});
        this.context.registerShutdownHook();
    }

    @Override
    public void stop() {
        super.stop();
        this.stopContext();
    }

    private void stopContext() {
        if (this.context != null && this.context.isRunning()) {
            this.context.stop();
            this.context.close();
        }
    }

    @Override
    public TestService.TestServiceScope getScope() {
        return TestService.TestServiceScope.TEST;
    }

    public ConfigurableApplicationContext getContext() {
        return this.context;
    }

    public static int getAppHttpsPort() {
        return PropertiesManager.getProperty((String)"server.port.https", (int)8443);
    }

    public static int getAppHttpPort() {
        return PropertiesManager.getProperty((String)"server.port.http", (int)8090);
    }

    public void setWebServerClass(Class<?> webServerClass) {
        this.webServerClass = webServerClass;
        this.stopContext();
        this.startContext();
    }

    @EnableAutoConfiguration
    public static class WebServer {
        @Bean
        @ConditionalOnMissingBean
        public ServletWebServerFactory servletContainer() {
            TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory();
            Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
            connector.setScheme("http");
            connector.setPort(WebServerService.getAppHttpPort());
            tomcat.addAdditionalTomcatConnectors(new Connector[]{connector});
            return tomcat;
        }
    }
}

