/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.utils;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueEventWaiter<E> {
    private static final long DEFAULT_WAIT_MILLIS = 30000L;
    private static final Logger log = LoggerFactory.getLogger(ValueEventWaiter.class);
    private CountDownLatch latch = new CountDownLatch(1);
    private String name;
    private E value;

    public ValueEventWaiter() {
        this("event");
    }

    public ValueEventWaiter(String name) {
        this.name = name;
    }

    public void eventReceived(E value) {
        this.value = value;
        this.latch.countDown();
    }

    public String getName() {
        return this.name;
    }

    public E waitFor() {
        return this.waitFor(30000L);
    }

    public E waitFor(E expectedValue) {
        return this.waitFor(30000L, expectedValue, true);
    }

    public E waitFor(long waitMillis, E expectedValue) {
        return this.waitFor(waitMillis, expectedValue, true);
    }

    public E waitFor(long waitMillis) {
        return this.waitFor(waitMillis, null, false);
    }

    private E waitFor(long waitMillis, E expectedValue, boolean honorExpectedValue) {
        log.debug("Start waiting {} ms for event '{}'", (Object)waitMillis, (Object)this.name);
        long start = System.currentTimeMillis();
        try {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.latch.await(waitMillis, TimeUnit.MILLISECONDS)).as("Event '" + this.name + "' is received before " + waitMillis + " ms", new Object[0])).isTrue();
            if (honorExpectedValue) {
                Assertions.assertThat(this.value).isEqualTo(expectedValue);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Waiting for event '" + this.name + "' has been interrupted");
        }
        long time = System.currentTimeMillis() - start;
        log.debug("Event '{}' is received in {} ms", (Object)this.name, (Object)time);
        return this.value;
    }

    public boolean hasBeenReceived() {
        return this.latch.getCount() == 0L;
    }
}

