/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.utils;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventWaiter {
    private static final long DEFAULT_WAIT_MILLIS = 30000L;
    private static final Logger log = LoggerFactory.getLogger(EventWaiter.class);
    private CountDownLatch latch = new CountDownLatch(1);
    private String name;

    public EventWaiter(String name) {
        this.name = name;
    }

    public void eventReceived() {
        this.latch.countDown();
    }

    public String getName() {
        return this.name;
    }

    public void waitFor() {
        this.waitFor(30000L);
    }

    public void waitFor(long waitMillis) {
        log.debug("Start waiting {} ms for event '{}'", (Object)waitMillis, (Object)this.name);
        long start = System.currentTimeMillis();
        try {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.latch.await(waitMillis, TimeUnit.MILLISECONDS)).as("Event '" + this.name + "' is received before " + waitMillis + " ms", new Object[0])).isTrue();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Waiting for event '" + this.name + "' has been interrupted");
        }
        long time = System.currentTimeMillis() - start;
        log.debug("Event '{}' is received in {} ms", (Object)this.name, (Object)time);
    }

    public boolean isEventRecived() {
        return this.latch.getCount() == 0L;
    }
}

