/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AbortableCountDownLatch
extends CountDownLatch {
    private boolean aborted;
    private long remainingLatchesCount;
    private String message;
    private Throwable throwable;

    public AbortableCountDownLatch(int count) {
        super(count);
    }

    public void abort(String message, Throwable throwable) {
        this.message = message;
        this.throwable = throwable;
        if (this.getCount() == 0L) {
            return;
        }
        this.aborted = true;
        this.remainingLatchesCount = this.getCount();
        while (this.getCount() > 0L) {
            this.countDown();
        }
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        boolean rtrn = super.await(timeout, unit);
        if (this.aborted) {
            throw new AbortedException(this.message, this.throwable);
        }
        return rtrn;
    }

    @Override
    public void await() throws InterruptedException {
        super.await();
        if (this.aborted) {
            throw new AbortedException(this.message, this.throwable);
        }
    }

    public long getRemainingLatchesCount() {
        return this.remainingLatchesCount;
    }

    public static class AbortedException
    extends InterruptedException {
        private static final long serialVersionUID = 5426681873843162292L;
        private Throwable cause;

        public AbortedException() {
        }

        public AbortedException(String detailMessage) {
            super(detailMessage);
        }

        public AbortedException(String detailMessage, Throwable cause) {
            super(detailMessage);
            this.cause = cause;
        }

        @Override
        public synchronized Throwable getCause() {
            return this.cause;
        }
    }
}

