/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.latency;

import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.browser.WebPage;
import org.kurento.test.latency.ChangeColorEvent;
import org.kurento.test.latency.ChangeColorEventListener;
import org.kurento.test.latency.ChangeColorObservable;
import org.kurento.test.latency.ChartWriter;
import org.kurento.test.latency.ColorTrigger;
import org.kurento.test.latency.LatencyException;
import org.kurento.test.latency.LatencyRegistry;
import org.kurento.test.latency.VideoTag;
import org.kurento.test.latency.VideoTagType;
import org.kurento.test.monitor.SystemMonitorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyController
implements ChangeColorEventListener<ChangeColorEvent> {
    private static final int MAX_DISTANCE = 60;
    public Logger log = LoggerFactory.getLogger(LatencyController.class);
    private Map<Long, LatencyRegistry> latencyMap;
    private String name;
    private long latencyThreshold = 3000L;
    private TimeUnit latencyThresholdTimeUnit;
    private long timeout = 30L;
    private TimeUnit timeoutTimeUnit;
    private ChangeColorObservable localChangeColor;
    private ChangeColorObservable remoteChangeColor;
    private long lastLocalColorChangeTime = -1L;
    private long lastRemoteColorChangeTime = -1L;
    private long lastLocalColorChangeTimeAbsolute = -1L;
    private long lastRemoteColorChangeTimeAbsolute = -1L;
    private Color lastLocalColor;
    private Color lastRemoteColor;
    private Thread localColorTrigger;
    private Thread remoteColorTrigger;
    private Semaphore localEventLatch = new Semaphore(0);
    private Semaphore remoteEventLatch = new Semaphore(0);
    private boolean failIfLatencyProblem = false;
    private long latencyRate = 100L;
    private int consecutiveFailMax = 3;
    private SystemMonitorManager monitor;

    public LatencyController(String name) {
        this();
        this.name = name;
    }

    public LatencyController(String name, SystemMonitorManager monitor) {
        this(name);
        this.monitor = monitor;
    }

    public LatencyController() {
        this.latencyThresholdTimeUnit = TimeUnit.MILLISECONDS;
        this.timeoutTimeUnit = TimeUnit.SECONDS;
        this.latencyMap = new TreeMap<Long, LatencyRegistry>();
    }

    @Override
    public synchronized void onEvent(ChangeColorEvent event) {
        if (event.getVideoTag().getVideoTagType() == VideoTagType.LOCAL) {
            this.lastLocalColorChangeTimeAbsolute = new Date().getTime();
            this.lastLocalColorChangeTime = event.getTime();
            this.lastLocalColor = event.getColor();
            this.localEventLatch.release();
        } else if (event.getVideoTag().getVideoTagType() == VideoTagType.REMOTE) {
            this.lastRemoteColorChangeTimeAbsolute = new Date().getTime();
            this.lastRemoteColorChangeTime = event.getTime();
            this.lastRemoteColor = event.getColor();
            this.remoteEventLatch.release();
        }
    }

    public void checkLatencyInBackground(final long testTime, final TimeUnit testTimeUnit, final WebPage client) throws InterruptedException, IOException {
        new Thread(){

            @Override
            public void run() {
                try {
                    LatencyController.this.checkLatency(testTime, testTimeUnit, client);
                }
                catch (InterruptedException e1) {
                    LatencyController.this.log.warn("checkLatencyInBackground InterruptedException: {}", (Object)e1.getMessage());
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }.start();
    }

    public void checkLatencyInBackground(final long testTime, final TimeUnit testTimeUnit, final WebPage localClient, final WebPage remoteClient) {
        new Thread(){

            @Override
            public void run() {
                LatencyController.this.checkLatency(testTime, testTimeUnit, localClient, remoteClient);
            }
        }.start();
    }

    public void checkLatencyInBackground(final WebPage localClient, final WebPage remoteClient) {
        new Thread(){

            @Override
            public void run() {
                LatencyController.this.checkLatency(Long.MAX_VALUE, TimeUnit.SECONDS, localClient, remoteClient);
            }
        }.start();
    }

    public void checkLatency(long testTime, TimeUnit testTimeUnit, WebPage client) throws InterruptedException, IOException {
        long playTime = TimeUnit.MILLISECONDS.convert(testTime, testTimeUnit);
        long endTimeMillis = System.currentTimeMillis() + playTime;
        int consecutiveFailCounter = 0;
        boolean first = true;
        while (System.currentTimeMillis() <= endTimeMillis) {
            LatencyRegistry latencyRegistry;
            long latency;
            block8: {
                Thread.sleep(this.latencyRate);
                latency = 0L;
                latencyRegistry = new LatencyRegistry();
                try {
                    latency = client.getLatency();
                    if (latency == Long.MIN_VALUE || latency == 0L) continue;
                    if (first) {
                        first = false;
                        continue;
                    }
                    this.log.debug(">>> Latency adquired: {} ms", (Object)latency);
                }
                catch (LatencyException le) {
                    latencyRegistry.setLatencyException(le);
                    if (!this.failIfLatencyProblem) break block8;
                    throw le;
                }
            }
            long latencyTime = client.getCurrentTime(new VideoTag(VideoTagType.REMOTE));
            latencyRegistry.setLatency(latency);
            if (latency > this.getLatencyThreshold(TimeUnit.MILLISECONDS)) {
                String parsedtime = new SimpleDateFormat("mm-ss.SSS").format(latencyTime);
                client.takeScreeshot(KurentoTest.getDefaultOutputFile("-" + parsedtime + "-error-screenshot.png"));
                LatencyException latencyException = new LatencyException(latency, TimeUnit.MILLISECONDS);
                latencyRegistry.setLatencyException(latencyException);
                if (this.failIfLatencyProblem) {
                    throw latencyException;
                }
                if (++consecutiveFailCounter >= this.consecutiveFailMax) {
                    throw new RuntimeException(this.consecutiveFailMax + " consecutive latency errors detected. Latest: " + latencyException.getLocalizedMessage());
                }
            } else {
                consecutiveFailCounter = 0;
            }
            this.latencyMap.put(latencyTime, latencyRegistry);
        }
    }

    public void checkLatency(final long testTime, final TimeUnit testTimeUnit, WebPage localClient, WebPage remoteClient) {
        String msgName;
        this.addChangeColorEventListener(new VideoTag(VideoTagType.LOCAL), localClient, this.getName() + " " + (Object)((Object)VideoTagType.LOCAL));
        this.addChangeColorEventListener(new VideoTag(VideoTagType.REMOTE), remoteClient, this.getName() + " " + (Object)((Object)VideoTagType.REMOTE));
        String string = msgName = this.name != null ? "[" + this.name + "] " : "";
        if (this.localChangeColor == null || this.remoteChangeColor == null) {
            throw new RuntimeException(msgName + "Bad setup in latency controller  (local and remote tag of browser(s) needed");
        }
        try {
            Thread thread;
            final Thread waitingThread = Thread.currentThread();
            if (testTimeUnit != null) {
                thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            testTimeUnit.sleep(testTime);
                            waitingThread.interrupt();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
            } else {
                thread = waitingThread;
            }
            do {
                this.waitForLocalColor(msgName, thread);
            } while (!this.similarColor(this.lastLocalColor, Color.GREEN));
            do {
                this.waitForRemoteColor(msgName, thread);
            } while (!this.similarColor(this.lastRemoteColor, Color.GREEN));
            while (true) {
                this.waitForLocalColor(msgName, thread);
                this.waitForRemoteColor(msgName, thread);
                long latencyMilis = Math.abs(this.lastRemoteColorChangeTimeAbsolute - this.lastLocalColorChangeTimeAbsolute);
                SimpleDateFormat formater = new SimpleDateFormat("mm:ss.SSS");
                String parsedLocaltime = formater.format(this.lastLocalColorChangeTimeAbsolute);
                String parsedRemotetime = formater.format(this.lastRemoteColorChangeTimeAbsolute);
                this.log.debug("latencyMilis={} -- lastLocalColor={} -- lastRemoteColor={} -- lastLocalColorChangeTime={} -- lastRemoteColorChangeTime={} -- lastLocalColorChangeTimeAbsolute={} -- lastRemoteColorChangeTimeAbsolute={}", new Object[]{latencyMilis, this.lastLocalColor, this.lastRemoteColor, formater.format(this.lastLocalColorChangeTime), formater.format(this.lastRemoteColorChangeTime), parsedLocaltime, parsedRemotetime});
                if (!this.similarColor(this.lastLocalColor, this.lastRemoteColor)) continue;
                this.log.debug("--> Latency adquired ({} ms)", (Object)latencyMilis);
                if (this.monitor != null) {
                    this.monitor.addCurrentLatency(latencyMilis);
                }
                LatencyRegistry LatencyRegistry2 = new LatencyRegistry(this.lastRemoteColor, latencyMilis);
                if (latencyMilis > this.getLatencyThreshold(TimeUnit.MILLISECONDS)) {
                    LatencyException latencyException = new LatencyException(latencyMilis, testTimeUnit, parsedLocaltime, parsedRemotetime, testTime, latencyMilis);
                    LatencyRegistry2.setLatencyException(latencyException);
                    if (this.failIfLatencyProblem) {
                        thread.interrupt();
                        throw latencyException;
                    }
                    this.log.warn(latencyException.getMessage());
                    if (this.monitor != null) {
                        this.monitor.incrementLatencyErrors();
                    }
                }
                this.latencyMap.put(this.lastRemoteColorChangeTime, LatencyRegistry2);
            }
        }
        catch (InterruptedException e) {
            this.log.debug("Finished LatencyController thread due to Interrupted Exception");
            this.localColorTrigger.interrupt();
            this.remoteColorTrigger.interrupt();
            return;
        }
    }

    private void waitForRemoteColor(String msgName, Thread thread) throws InterruptedException {
        if (!this.remoteEventLatch.tryAcquire(this.timeout, this.timeoutTimeUnit)) {
            thread.interrupt();
            throw new RuntimeException(msgName + "Change color not detected in REMOTE steam after " + this.timeout + " " + (Object)((Object)this.timeoutTimeUnit));
        }
    }

    private void waitForLocalColor(String msgName, Thread thread) throws InterruptedException {
        if (!this.localEventLatch.tryAcquire(this.timeout, this.timeoutTimeUnit)) {
            thread.interrupt();
            throw new RuntimeException(msgName + "Change color not detected in LOCAL steam after " + this.timeout + " " + (Object)((Object)this.timeoutTimeUnit));
        }
    }

    private boolean similarColor(Color expectedColor, Color realColor) {
        int expectedBlue;
        int expectedGreen;
        int realRed = realColor.getRed();
        int realGreen = realColor.getGreen();
        int realBlue = realColor.getBlue();
        int expectedRed = expectedColor.getRed();
        double distance = Math.sqrt((realRed - expectedRed) * (realRed - expectedRed) + (realGreen - (expectedGreen = expectedColor.getGreen())) * (realGreen - expectedGreen) + (realBlue - (expectedBlue = expectedColor.getBlue())) * (realBlue - expectedBlue));
        return distance <= 60.0;
    }

    public void addChangeColorEventListener(VideoTag type, WebPage testClient, String name) {
        long timeoutSeconds = TimeUnit.SECONDS.convert(this.timeout, this.timeoutTimeUnit);
        if (type.getVideoTagType() == VideoTagType.LOCAL) {
            this.localChangeColor = new ChangeColorObservable();
            this.localChangeColor.addListener(this);
            this.localColorTrigger = new Thread(new ColorTrigger(type, testClient, this.localChangeColor, timeoutSeconds));
            if (name != null) {
                this.localColorTrigger.setName(name);
            }
            this.localColorTrigger.start();
        } else {
            this.remoteChangeColor = new ChangeColorObservable();
            this.remoteChangeColor.addListener(this);
            this.remoteColorTrigger = new Thread(new ColorTrigger(type, testClient, this.remoteChangeColor, timeoutSeconds));
            if (name != null) {
                this.remoteColorTrigger.setName(name);
            }
            this.remoteColorTrigger.start();
        }
    }

    public void drawChart(String filename, int width, int height) throws IOException {
        ChartWriter chartWriter = new ChartWriter(this.latencyMap, this.getName());
        chartWriter.drawChart(filename, width, height);
    }

    public void writeCsv(String csvTitle) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(csvTitle));
        for (long time : this.latencyMap.keySet()) {
            pw.println(time + "," + this.latencyMap.get(time).getLatency());
        }
        pw.close();
    }

    public void logLatencyErrorrs() throws IOException {
        this.log.debug("---------------------------------------------");
        this.log.debug("LATENCY ERRORS " + this.getName());
        this.log.debug("---------------------------------------------");
        int numErrors = 0;
        for (LatencyRegistry registry : this.latencyMap.values()) {
            if (!registry.isLatencyError()) continue;
            ++numErrors;
            this.log.debug(registry.getLatencyException().getMessage());
        }
        this.log.debug("{} errors of latency detected (threshold: {} {})", new Object[]{numErrors, this.latencyThreshold, this.latencyThresholdTimeUnit});
        this.log.debug("---------------------------------------------");
    }

    public long getLatencyThreshold(TimeUnit timeUnit) {
        return timeUnit.convert(this.latencyThreshold, this.latencyThresholdTimeUnit);
    }

    public long getLatencyThreshold() {
        return this.latencyThreshold;
    }

    public void setLatencyThreshold(long latencyThreshold, TimeUnit latencyThresholdTimeUnit) {
        this.latencyThreshold = latencyThreshold;
        this.latencyThresholdTimeUnit = latencyThresholdTimeUnit;
    }

    public TimeUnit getLatencyTimeUnit() {
        return this.latencyThresholdTimeUnit;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout, TimeUnit timeoutTimeUnit) {
        this.timeout = timeout;
        this.timeoutTimeUnit = timeoutTimeUnit;
    }

    public TimeUnit getTimeoutTimeUnit() {
        return this.timeoutTimeUnit;
    }

    public void failIfLatencyProblem() {
        this.failIfLatencyProblem = true;
    }

    public String getName() {
        return this.name != null ? this.name : "";
    }

    public void setLatencyRate(long latencyRate) {
        this.latencyRate = latencyRate;
    }

    public void setConsecutiveFailMax(int consecutiveFailMax) {
        this.consecutiveFailMax = consecutiveFailMax;
    }

    public Map<Long, LatencyRegistry> getLatencyMap() {
        return this.latencyMap;
    }
}

