/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.config;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.junit.Assert;
import org.kurento.commons.ClassPath;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.browser.Browser;
import org.kurento.test.browser.BrowserType;
import org.kurento.test.browser.WebPageType;
import org.kurento.test.config.BrowserConfig;
import org.kurento.test.config.BrowserScope;
import org.openqa.selenium.Platform;

public class TestScenario {
    public static final String INSTANCES_SEPARATOR = "-";
    private Map<String, Browser> browserMap = new TreeMap<String, Browser>();
    private List<URL> urlList = new ArrayList<URL>();

    public void addBrowser(String id, Browser browser) {
        if (browser.getNumInstances() > 0) {
            for (int i = 0; i < browser.getNumInstances(); ++i) {
                if (browser.getBrowserPerInstance() > 1) {
                    for (int j = 0; j < browser.getBrowserPerInstance(); ++j) {
                        String browserId = id + i + INSTANCES_SEPARATOR + j;
                        this.addBrowserInstance(browserId, new Browser(browser.getBuilder()));
                    }
                    continue;
                }
                this.addBrowserInstance(id + i, new Browser(browser.getBuilder()));
            }
        } else {
            this.addBrowserInstance(id, browser);
        }
    }

    private void addBrowserInstance(String id, Browser browser) {
        this.assertKeyNotExist(id);
        browser.setId(id);
        this.browserMap.put(id, browser);
    }

    private void assertKeyNotExist(String key) {
        Assert.assertFalse((String)("'" + key + "' key already registered in browser config map"), (boolean)this.browserMap.keySet().contains(key));
    }

    public BrowserScope getScope(String key) {
        return this.browserMap.get(key).getScope();
    }

    public BrowserType getBrowserType(String key) {
        return this.browserMap.get(key).getBrowserType();
    }

    public Platform getPlatform(String key) {
        return this.browserMap.get(key).getPlatform();
    }

    public String getBrowserVersion(String key) {
        return this.browserMap.get(key).getBrowserVersion();
    }

    public String toString() {
        String out = "";
        HashMap<String, Integer> browsers = new HashMap<String, Integer>();
        for (String key : this.browserMap.keySet()) {
            String browser = this.getBrowserType(key).toString();
            String version = this.getBrowserVersion(key);
            Platform platform = this.getPlatform(key);
            if (version != null) {
                browser = browser + version;
            }
            if (platform != null) {
                browser = browser + platform;
            }
            if (browsers.containsKey(browser)) {
                int newCount = (Integer)browsers.get(browser) + 1;
                browsers.put(browser, newCount);
                continue;
            }
            browsers.put(browser, 1);
        }
        for (String browser : browsers.keySet()) {
            int count = (Integer)browsers.get(browser);
            if (!out.isEmpty()) {
                out = out + " ";
            }
            if (count > 1) {
                out = out + count + "X";
            }
            out = out + browser;
        }
        return out;
    }

    private static String getConfigFile() {
        return PropertiesManager.getProperty((String)"test.config.file");
    }

    public static Collection<Object[]> from(String defaultBrowserConfigFile) {
        try {
            String executionsData = PropertiesManager.getProperty((String)PropertiesManager.getProperty((String)"test.config.executions", (String)"executions"));
            BrowserConfig browserConfig = null;
            Gson gson = new Gson();
            if (executionsData != null) {
                browserConfig = (BrowserConfig)gson.fromJson("{\"executions\":" + executionsData + "}", BrowserConfig.class);
            } else {
                try (BufferedReader br = Files.newBufferedReader(ClassPath.get((String)("/" + defaultBrowserConfigFile)), StandardCharsets.UTF_8);){
                    browserConfig = (BrowserConfig)gson.fromJson((Reader)br, BrowserConfig.class);
                }
            }
            return browserConfig.getTestScenario();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<Object[]> empty() {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        TestScenario test = new TestScenario();
        return Arrays.asList(new Object[][]{{test}});
    }

    public static Collection<Object[]> localChromeAndFirefox() {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        TestScenario test1 = new TestScenario();
        test1.addBrowser("browser", new Browser.Builder().webPageType(WebPageType.WEBRTC).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).build());
        TestScenario test2 = new TestScenario();
        test2.addBrowser("browser", new Browser.Builder().webPageType(WebPageType.WEBRTC).browserType(BrowserType.FIREFOX).scope(BrowserScope.LOCAL).build());
        return Arrays.asList({test1}, {test2});
    }

    public static Collection<Object[]> localChromePlusFirefox() {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        TestScenario test = new TestScenario();
        test.addBrowser("browser0", new Browser.Builder().webPageType(WebPageType.WEBRTC).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).build());
        test.addBrowser("browser1", new Browser.Builder().webPageType(WebPageType.WEBRTC).browserType(BrowserType.FIREFOX).scope(BrowserScope.LOCAL).build());
        return Arrays.asList(new Object[][]{{test}});
    }

    public static Collection<Object[]> localChromes(int size, WebPageType webPageType) {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        TestScenario test = new TestScenario();
        for (int i = 0; i < size; ++i) {
            test.addBrowser("browser" + i, new Browser.Builder().webPageType(webPageType).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).build());
        }
        return Arrays.asList(new Object[][]{{test}});
    }

    public static Collection<Object[]> localChromes(int size) {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        return TestScenario.localChromes(size, WebPageType.WEBRTC);
    }

    public static Collection<Object[]> localChromesWithRgbVideo(int size) {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        TestScenario test = new TestScenario();
        for (int i = 0; i < size; ++i) {
            test.addBrowser("browser" + i, new Browser.Builder().webPageType(WebPageType.WEBRTC).browserType(BrowserType.CHROME).video(KurentoTest.getTestFilesDiskPath() + "/video/15sec/rgbHD.y4m").scope(BrowserScope.LOCAL).build());
        }
        return Arrays.asList(new Object[][]{{test}});
    }

    public static Collection<Object[]> localChromesAndFirefoxs(int size) {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        TestScenario test1 = new TestScenario();
        for (int i = 0; i < size; ++i) {
            test1.addBrowser("browser" + i, new Browser.Builder().webPageType(WebPageType.WEBRTC).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).build());
        }
        TestScenario test2 = new TestScenario();
        for (int i = 0; i < size; ++i) {
            test2.addBrowser("browser" + i, new Browser.Builder().webPageType(WebPageType.WEBRTC).browserType(BrowserType.FIREFOX).scope(BrowserScope.LOCAL).build());
        }
        return Arrays.asList({test1}, {test2});
    }

    public static Collection<Object[]> localChrome(WebPageType webPageType) {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        TestScenario test = new TestScenario();
        test.addBrowser("browser", new Browser.Builder().browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).webPageType(webPageType).build());
        return Arrays.asList(new Object[][]{{test}});
    }

    public static Collection<Object[]> localChrome() {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        return TestScenario.localChrome(WebPageType.WEBRTC);
    }

    public static Collection<Object[]> localFirefox() {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        TestScenario test = new TestScenario();
        test.addBrowser("browser", new Browser.Builder().webPageType(WebPageType.WEBRTC).browserType(BrowserType.FIREFOX).scope(BrowserScope.LOCAL).build());
        return Arrays.asList(new Object[][]{{test}});
    }

    public static Collection<Object[]> localFirefoxs(int size, WebPageType webPageType) {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        TestScenario test = new TestScenario();
        for (int i = 0; i < size; ++i) {
            test.addBrowser("browser" + i, new Browser.Builder().webPageType(webPageType).browserType(BrowserType.FIREFOX).scope(BrowserScope.LOCAL).build());
        }
        return Arrays.asList(new Object[][]{{test}});
    }

    public static Collection<Object[]> localFirefoxs(int size) {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        return TestScenario.localFirefoxs(size, WebPageType.WEBRTC);
    }

    public static Collection<Object[]> localPresenterAndViewer() {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        TestScenario test = new TestScenario();
        test.addBrowser("presenter", new Browser.Builder().webPageType(WebPageType.WEBRTC).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).build());
        test.addBrowser("viewer", new Browser.Builder().webPageType(WebPageType.WEBRTC).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).build());
        return Arrays.asList(new Object[][]{{test}});
    }

    public static Collection<Object[]> localPresenterAndViewerRgb() {
        String configFile = TestScenario.getConfigFile();
        if (configFile != null) {
            return TestScenario.from(configFile);
        }
        String videoPath = KurentoTest.getTestFilesDiskPath() + "/video/15sec/rgbHD.y4m";
        TestScenario test = new TestScenario();
        test.addBrowser("presenter", new Browser.Builder().webPageType(WebPageType.WEBRTC).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).video(videoPath).build());
        test.addBrowser("viewer", new Browser.Builder().webPageType(WebPageType.WEBRTC).browserType(BrowserType.CHROME).scope(BrowserScope.LOCAL).video(videoPath).build());
        return Arrays.asList(new Object[][]{{test}});
    }

    public Map<String, Browser> getBrowserMap() {
        return this.browserMap;
    }

    public Map<String, Browser> getBrowserMap(String ... types) {
        HashMap<String, Browser> out = new HashMap<String, Browser>();
        for (String key : this.browserMap.keySet()) {
            for (String type : types) {
                if (!key.startsWith(type)) continue;
                out.put(key, this.browserMap.get(key));
            }
        }
        return out;
    }

    public List<URL> getUrlList() {
        return this.urlList;
    }
}

