/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import com.github.dockerjava.api.model.CpuStatsConfig;
import com.github.dockerjava.api.model.MemoryStatsConfig;
import com.github.dockerjava.api.model.Statistics;
import java.util.List;
import java.util.Map;
import org.kurento.test.docker.Docker;
import org.kurento.test.monitor.KmsMonitor;
import org.kurento.test.monitor.NetInfo;

public class KmsDockerMonitor
extends KmsMonitor {
    private int kmsPid;
    private Docker docker;
    private String containerId;
    private long previousCpu = -1L;
    private long previousSystem = -1L;

    public KmsDockerMonitor(String containerId) {
        this.containerId = containerId;
        this.docker = Docker.getSingleton();
        this.kmsPid = this.getKmsPid();
    }

    @Override
    protected NetInfo getNetInfo() {
        NetInfo netInfo = new NetInfo();
        Statistics stats = this.docker.getStatistics(this.containerId);
        Map networksStats = stats.getNetworks();
        for (String key : networksStats.keySet()) {
            Map iface = (Map)networksStats.get(key);
            int rxBytes = (Integer)iface.get("rx_bytes");
            int txBytes = (Integer)iface.get("tx_bytes");
            netInfo.putNetInfo(key, rxBytes, txBytes);
        }
        return netInfo;
    }

    @Override
    protected double getCpuUsage() {
        double cpuUsage = 0.0;
        Statistics stats = this.docker.getStatistics(this.containerId);
        CpuStatsConfig cpuStats = stats.getCpuStats();
        if (cpuStats != null) {
            Map cpuUsageMap = (Map)cpuStats.getCpuUsage();
            long systemUsage = Long.parseLong(cpuStats.getSystemCpuUsage().toString());
            long totalUsage = Long.parseLong(cpuUsageMap.get("total_usage").toString());
            List perCpuUsage = (List)cpuUsageMap.get("percpu_usage");
            if (this.previousCpu != -1L && this.previousSystem != -1L) {
                float cpuDelta = totalUsage - this.previousCpu;
                float systemDelta = systemUsage - this.previousSystem;
                if (cpuDelta > 0.0f && systemDelta > 0.0f) {
                    cpuUsage = cpuDelta / systemDelta * (float)perCpuUsage.size() * 100.0f;
                }
            }
            this.previousCpu = totalUsage;
            this.previousSystem = systemUsage;
        }
        return cpuUsage;
    }

    @Override
    protected double[] getMem() {
        double[] out = new double[]{0.0, 0.0};
        Statistics stats = this.docker.getStatistics(this.containerId);
        MemoryStatsConfig memoryStats = stats.getMemoryStats();
        long usage = memoryStats.getUsage();
        long limit = memoryStats.getLimit();
        double memPercent = usage / limit * 100L;
        out[0] = usage;
        out[1] = memPercent;
        return out;
    }

    @Override
    protected int getKmsPid() {
        String[] lines;
        int kmdPid = -1;
        String execOutput = this.docker.execCommand(this.containerId, true, "ps", "axf");
        for (String line : lines = execOutput.split("\n")) {
            if (!line.contains("/usr/bin/kurento-media-server")) continue;
            kmdPid = Integer.parseInt(line.trim().substring(0, line.trim().indexOf(" ")));
            break;
        }
        return kmdPid;
    }

    @Override
    protected int getNumThreads() {
        int numThreads = -1;
        String kmsStat = this.docker.execCommand(this.containerId, true, "cat", "/proc/" + this.kmsPid + "/stat");
        String[] kmsStats = kmsStat.split(" ");
        if (kmsStats.length >= 20) {
            numThreads = Integer.parseInt(kmsStats[19]);
        }
        return numThreads;
    }
}

