/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import java.awt.Color;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.browser.Browser;
import org.kurento.test.browser.WebPage;
import org.kurento.test.config.TestScenario;
import org.kurento.test.internal.AbortableCountDownLatch;

@RunWith(value=Parameterized.class)
public abstract class BrowserTest<W extends WebPage>
extends KurentoTest {
    public static final Color CHROME_VIDEOTEST_COLOR = new Color(0, 135, 0);
    private Map<String, W> pages = new ConcurrentHashMap<String, W>();
    private TestScenario testScenario;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return TestScenario.from("default.conf.json");
    }

    public BrowserTest() {
    }

    public BrowserTest(TestScenario testScenario) {
        this.testScenario = testScenario;
    }

    @Before
    public void setupKurentoTest() throws InterruptedException {
        if (this.testScenario != null && this.testScenario.getBrowserMap() != null && this.testScenario.getBrowserMap().size() > 0) {
            ExecutorService executor = Executors.newFixedThreadPool(this.testScenario.getBrowserMap().size());
            final AbortableCountDownLatch latch = new AbortableCountDownLatch(this.testScenario.getBrowserMap().size());
            for (final String browserKey : this.testScenario.getBrowserMap().keySet()) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Browser browser = BrowserTest.this.testScenario.getBrowserMap().get(browserKey);
                            int timeout = PropertiesManager.getProperty((String)"test.url.timeout", (int)30);
                            URL url = browser.getUrl();
                            if (!BrowserTest.this.testScenario.getUrlList().contains(url)) {
                                BrowserTest.this.waitForHostIsReachable(url, timeout);
                                BrowserTest.this.testScenario.getUrlList().add(url);
                            }
                            BrowserTest.this.initBrowser(browserKey, browser);
                            latch.countDown();
                        }
                        catch (Throwable t) {
                            latch.abort("Exception setting up test. A browser could not be initialised", t);
                            t.printStackTrace();
                        }
                    }
                });
            }
            latch.await();
        }
        log.info("--------------- Started WebPageTest ----------------");
    }

    private void initBrowser(String browserKey, Browser browser) {
        browser.setId(browserKey);
        browser.setName(BrowserTest.getTestMethodName());
        browser.init();
        browser.injectKurentoTestJs();
    }

    @After
    public void teardownKurentoTest() {
        log.info("--------------- Finished WebPageTest ----------------");
        if (this.testScenario != null) {
            for (Browser browser : this.testScenario.getBrowserMap().values()) {
                try {
                    browser.close();
                }
                catch (Exception e) {
                    log.warn("Exception closing browser {}", (Object)browser.getId(), (Object)e);
                }
            }
        }
    }

    public TestScenario getTestScenario() {
        return this.testScenario;
    }

    public void addBrowser(String browserKey, Browser browser) {
        this.testScenario.getBrowserMap().put(browserKey, browser);
        this.initBrowser(browserKey, browser);
    }

    public W getPage(String browserKey) {
        return this.assertAndGetPage(browserKey);
    }

    public W getPage() {
        try {
            return this.assertAndGetPage("browser");
        }
        catch (RuntimeException e) {
            if (this.testScenario.getBrowserMap().isEmpty()) {
                throw new RuntimeException("Empty test scenario: no available browser to run tests!");
            }
            String browserKey = this.testScenario.getBrowserMap().entrySet().iterator().next().getKey();
            log.debug("browser is not registered in test scenarario, instead using first browser in the test scenario, i.e. " + browserKey);
            return this.getOrCreatePage(browserKey);
        }
    }

    public W getPage(int index) {
        return this.assertAndGetPage("browser" + index);
    }

    public W getPresenter() {
        return this.assertAndGetPage("presenter");
    }

    public W getPresenter(int index) {
        return this.assertAndGetPage("presenter" + index);
    }

    public W getViewer() {
        return this.assertAndGetPage("viewer");
    }

    public W getViewer(int index) {
        return this.assertAndGetPage("viewer" + index);
    }

    private W assertAndGetPage(String browserKey) {
        if (!this.testScenario.getBrowserMap().keySet().contains(browserKey)) {
            throw new RuntimeException(browserKey + " is not registered as browser in the test scenario");
        }
        return this.getOrCreatePage(browserKey);
    }

    private synchronized W getOrCreatePage(String browserKey) {
        Object webPage;
        if (this.pages.containsKey(browserKey)) {
            webPage = (WebPage)this.pages.get(browserKey);
        } else {
            webPage = this.createWebPage();
            ((WebPage)webPage).setBrowser(this.testScenario.getBrowserMap().get(browserKey));
            this.pages.put(browserKey, webPage);
        }
        return webPage;
    }

    protected W createWebPage() {
        Class<?> testClientClass = BrowserTest.getParamType(this.getClass());
        try {
            return (W)((WebPage)testClientClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Exception creating an instance of class " + testClientClass.getName(), e);
        }
    }

    public static Class<?> getParamType(Class<?> testClass) {
        Type genericSuperclass = testClass.getGenericSuperclass();
        if (genericSuperclass != null) {
            if (genericSuperclass instanceof Class) {
                return BrowserTest.getParamType((Class)genericSuperclass);
            }
            ParameterizedType paramClass = (ParameterizedType)genericSuperclass;
            return (Class)paramClass.getActualTypeArguments()[0];
        }
        throw new RuntimeException("Unable to obtain the type paramter of KurentoTest");
    }

    public void waitForHostIsReachable(URL url, int timeout) {
        long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, TimeUnit.SECONDS);
        long endTimeMillis = System.currentTimeMillis() + timeoutMillis;
        log.debug("Waiting for {} to be reachable (timeout {} seconds)", (Object)url, (Object)timeout);
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            int responseCode = 0;
            while (true) {
                try {
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setConnectTimeout((int)timeoutMillis);
                    connection.setReadTimeout((int)timeoutMillis);
                    connection.setRequestMethod("HEAD");
                    responseCode = connection.getResponseCode();
                }
                catch (SocketException | SSLHandshakeException e) {
                    log.warn("Error {} waiting URL {}, trying again in 1 second", (Object)e.getMessage(), (Object)url);
                    Thread.sleep(1000L);
                    if (System.currentTimeMillis() <= endTimeMillis) continue;
                }
                break;
            }
            if (responseCode != 200) {
                Assert.fail((String)("URL " + url + " not reachable. Response code=" + responseCode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("URL " + url + " not reachable in " + timeout + " seconds (" + e.getClass().getName() + ", " + e.getMessage() + ")"));
        }
        log.debug("URL {} already reachable", (Object)url);
    }

    public void waitSeconds(int waitTime) {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(waitTime));
        }
        catch (InterruptedException e) {
            log.warn("InterruptedException waiting {} seconds", (Object)waitTime, (Object)e);
        }
    }
}

