/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.junit.After;
import org.kurento.client.EventListener;
import org.kurento.client.KurentoClient;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaPipeline;
import org.kurento.client.OnIceCandidateEvent;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.commons.exception.KurentoException;
import org.kurento.test.base.BrowserTest;
import org.kurento.test.base.RepositoryFunctionalTest;
import org.kurento.test.browser.WebPage;
import org.kurento.test.config.TestScenario;
import org.kurento.test.monitor.SystemMonitorManager;
import org.kurento.test.services.FailedTest;
import org.kurento.test.services.KurentoClientManager;
import org.kurento.test.services.KurentoServicesTestHelper;
import org.kurento.test.services.WebRtcConnector;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;

public class KurentoClientBrowserTest<W extends WebPage>
extends BrowserTest<W> {
    protected static ConfigurableApplicationContext context;
    protected static KurentoClientManager kurentoClientManager;
    protected KurentoClient kurentoClient;
    protected KurentoClient fakeKurentoClient;
    private Class<?> webServerClass = WebServer.class;

    public KurentoClientBrowserTest(Class<?> webServerClass) {
        this.webServerClass = webServerClass;
    }

    public KurentoClientBrowserTest(TestScenario testScenario) {
        super(testScenario);
    }

    protected void setWebServerClass(Class<RepositoryFunctionalTest.RepositoryWebServer> webServerClass) {
        this.webServerClass = webServerClass;
    }

    @FailedTest
    public static void retrieveGstreamerDots() {
        if (kurentoClientManager != null) {
            try {
                KurentoClient kurentoClient = kurentoClientManager.getKurentoClient();
                List pipelines = kurentoClient.getServerManager().getPipelines();
                log.debug("Retrieving GStreamerDots for all pipelines in KMS ({})", (Object)pipelines.size());
                for (MediaPipeline pipeline : pipelines) {
                    String pipelineName = pipeline.getName();
                    log.debug("Saving GstreamerDot for pipeline {}", (Object)pipelineName);
                    String gstreamerDotFile = KurentoClientBrowserTest.getDefaultOutputFile("-" + pipelineName);
                    try {
                        FileUtils.writeStringToFile((File)new File(gstreamerDotFile), (String)pipeline.getGstreamerDot());
                    }
                    catch (IOException ioe) {
                        log.error("Exception writing GstreamerDot file", (Throwable)ioe);
                    }
                }
            }
            catch (WebSocketException e) {
                log.warn("WebSocket exception while reading existing pipelines. Maybe KMS is closed: {}:{}", (Object)((Object)((Object)e)).getClass().getName(), (Object)e.getMessage());
            }
        }
    }

    @Override
    public void setupKurentoTest() throws InterruptedException {
        this.startHttpServer();
        try {
            kurentoClientManager = new KurentoClientManager();
            this.kurentoClient = kurentoClientManager.getKurentoClient();
            this.fakeKurentoClient = kurentoClientManager.getFakeKurentoClient();
            log.info("--------------- Started KurentoClientWebPageTest ---------------");
            super.setupKurentoTest();
        }
        catch (IOException e) {
            throw new KurentoException("Exception creating kurentoClientManager", (Throwable)e);
        }
    }

    private void startHttpServer() {
        context = KurentoServicesTestHelper.startHttpServer(this.webServerClass);
    }

    @After
    public void teardownKurentoClient() throws Exception {
        log.info("--------------- Finished KurentoClientWebPageTest ---------------");
        if (kurentoClientManager != null) {
            kurentoClientManager.teardown();
        }
    }

    protected int getServerPort() {
        return KurentoServicesTestHelper.getAppHttpPort();
    }

    public static String getPathTestFiles() {
        return KurentoServicesTestHelper.getTestFilesPath();
    }

    public void addFakeClients(int numFakeClients, int bandwidht, MediaPipeline mainPipeline, WebRtcEndpoint senderWebRtcEndpoint) {
        this.addFakeClients(numFakeClients, bandwidht, mainPipeline, senderWebRtcEndpoint, 0L, null, null);
    }

    public void addFakeClients(int numFakeClients, MediaPipeline mainPipeline, WebRtcEndpoint senderWebRtcEndpoint, long timeBetweenClientMs, SystemMonitorManager monitor, WebRtcConnector connector) {
        this.addFakeClients(numFakeClients, -1, mainPipeline, senderWebRtcEndpoint, timeBetweenClientMs, monitor, connector);
    }

    public void addFakeClients(int numFakeClients, int bandwidht, MediaPipeline mainPipeline, WebRtcEndpoint inputWebRtc, long timeBetweenClientMs, SystemMonitorManager monitor, WebRtcConnector connector) {
        if (this.fakeKurentoClient == null) {
            throw new KurentoException("Fake kurentoClient is not defined. You must set the 'fake.kms.ws.uri' property with KMS uri to fake clients");
        }
        log.info("* * * Adding {} fake clients * * *", (Object)numFakeClients);
        MediaPipeline fakePipeline = this.fakeKurentoClient.createMediaPipeline();
        for (int i = 0; i < numFakeClients; ++i) {
            log.info("* * * Adding fake client {} * * *", (Object)i);
            final WebRtcEndpoint fakeOutputWebRtc = (WebRtcEndpoint)new WebRtcEndpoint.Builder(mainPipeline).build();
            final WebRtcEndpoint fakeBrowser = (WebRtcEndpoint)new WebRtcEndpoint.Builder(fakePipeline).build();
            if (bandwidht != -1) {
                fakeOutputWebRtc.setMaxVideoSendBandwidth(bandwidht);
                fakeOutputWebRtc.setMinVideoSendBandwidth(bandwidht);
                fakeBrowser.setMaxVideoRecvBandwidth(bandwidht);
            }
            fakeOutputWebRtc.addOnIceCandidateListener((EventListener)new EventListener<OnIceCandidateEvent>(){

                public void onEvent(OnIceCandidateEvent event) {
                    fakeBrowser.addIceCandidate(event.getCandidate());
                }
            });
            fakeBrowser.addOnIceCandidateListener((EventListener)new EventListener<OnIceCandidateEvent>(){

                public void onEvent(OnIceCandidateEvent event) {
                    fakeOutputWebRtc.addIceCandidate(event.getCandidate());
                }
            });
            String sdpOffer = fakeBrowser.generateOffer();
            String sdpAnswer = fakeOutputWebRtc.processOffer(sdpOffer);
            fakeBrowser.processAnswer(sdpAnswer);
            fakeOutputWebRtc.gatherCandidates();
            fakeBrowser.gatherCandidates();
            if (connector == null) {
                inputWebRtc.connect((MediaElement)fakeOutputWebRtc);
            } else {
                connector.connect(inputWebRtc, fakeOutputWebRtc);
            }
            if (monitor != null) {
                monitor.incrementNumClients();
            }
            if (timeBetweenClientMs <= 0L) continue;
            try {
                Thread.sleep(timeBetweenClientMs);
                continue;
            }
            catch (InterruptedException e) {
                log.warn("Interrupted exception adding fake clients", (Throwable)e);
            }
        }
    }

    @EnableAutoConfiguration
    public static class WebServer {
    }
}

