/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Rule;
import org.kurento.commons.ConfigFileManager;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.config.Retry;
import org.kurento.test.config.TestReport;
import org.kurento.test.services.FailedTest;
import org.kurento.test.services.FinishedTest;
import org.kurento.test.services.KurentoTestWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KurentoTest {
    @Rule
    public Retry retry = new Retry(numRetries);
    @Rule
    public KurentoTestWatcher watcher = new KurentoTestWatcher();
    protected static int numRetries = PropertiesManager.getProperty((String)"test.num.retries", (int)1);
    protected static String testDir = PropertiesManager.getProperty((String)"test.project.path", (String)"target/surefire-reports/");
    protected static boolean printLogs = PropertiesManager.getProperty((String)"test.print.log", (boolean)true);
    public static Logger log = LoggerFactory.getLogger(KurentoTest.class);
    protected static String testIdentifier;
    protected static String testMethodName;
    protected static String testClassName;
    protected static List<File> logFiles;
    protected static boolean deleteLogsIfSuccess;
    public static final String SEPARATOR = "+----------------------------------------------------------";

    public KurentoTest() {
        testClassName = this.getClass().getName();
        testIdentifier = this.getClass().getSimpleName() + " [" + new Date() + "]";
        this.retry.useReport(testIdentifier);
        deleteLogsIfSuccess = true;
    }

    @FailedTest
    public static void printKmsLogs() {
        if (printLogs && logFiles != null) {
            for (File logFile : logFiles) {
                if (logFile == null || !logFile.exists()) continue;
                System.err.println(SEPARATOR);
                System.err.println("Log file: " + logFile.getAbsolutePath());
                try {
                    for (String line : FileUtils.readLines((File)logFile)) {
                        System.err.println(line);
                    }
                }
                catch (Throwable e) {
                    log.warn("Error reading log file {}: {} {}", new Object[]{logFile, e.getClass(), e.getMessage()});
                }
                System.err.println(SEPARATOR);
            }
        }
    }

    @FinishedTest
    public static void deleteLogs() {
        File folder;
        File[] files;
        if (KurentoTestWatcher.isSuccees() && deleteLogsIfSuccess && (files = (folder = KurentoTest.getDefaultOutputFolder()).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(KurentoTest.getSimpleTestName());
            }
        })) != null) {
            for (File file : files) {
                try {
                    if (file.isDirectory()) {
                        FileUtils.deleteDirectory((File)file);
                    } else {
                        file.delete();
                    }
                    if (!file.exists()) continue;
                    log.error("Can't remove {}", (Object)file.getAbsolutePath());
                }
                catch (Throwable e) {
                    log.warn("Exception deleting file {}: {} {}", new Object[]{file, e.getClass(), e.getMessage()});
                }
            }
        }
    }

    public TestReport getTestReport() {
        return this.retry.getTestReport();
    }

    public static File getDefaultOutputFolder() {
        File testResultsFolder = new File(testDir + File.separator + testClassName);
        if (!testResultsFolder.exists()) {
            testResultsFolder.mkdirs();
        }
        return testResultsFolder;
    }

    public static String getDefaultOutputFile(String suffix) {
        return KurentoTest.getDefaultOutputFolder().getAbsolutePath() + File.separator + KurentoTest.getSimpleTestName() + suffix;
    }

    protected String getDefaultFileForRecording() {
        return KurentoTest.getDefaultOutputFile(".webm");
    }

    public static String getSimpleTestName() {
        String out = testMethodName;
        if (testMethodName != null && out.indexOf(":") != -1) {
            out = out.substring(0, out.indexOf(":")) + "]";
        }
        return out;
    }

    public static String getTestMethodName() {
        return testMethodName;
    }

    public static void setTestMethodName(String testMethodName) {
        KurentoTest.testMethodName = testMethodName;
    }

    public static String getTestClassName() {
        return testClassName;
    }

    public static void setTestClassName(String testClassName) {
        KurentoTest.testClassName = testClassName;
    }

    public static String getTestDir() {
        return testDir;
    }

    public static void setTestDir(String testDir) {
        KurentoTest.testDir = testDir;
    }

    public static String getTestIdentifier() {
        return testIdentifier;
    }

    public static void setTestIdentifier(String testIdentifier) {
        KurentoTest.testIdentifier = testIdentifier;
    }

    public static boolean isDeleteLogsIfSuccess() {
        return deleteLogsIfSuccess;
    }

    public static void setDeleteLogsIfSuccess(boolean deleteLogsIfSuccess) {
        KurentoTest.deleteLogsIfSuccess = deleteLogsIfSuccess;
    }

    public static void addLogFile(File logFile) {
        log.info("Adding log file: {}", (Object)logFile);
        if (logFiles == null) {
            logFiles = new ArrayList<File>();
        }
        logFiles.add(logFile);
    }

    public static List<File> getServerLogFiles() {
        int countFiles = logFiles != null ? logFiles.size() : 0;
        log.info("Logs files {}", (Object)countFiles);
        return logFiles;
    }

    static {
        ConfigFileManager.loadConfigFile((String)"test.conf.json");
    }
}

