/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import com.google.common.io.Files;
import javax.servlet.Servlet;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.kurento.commons.testing.SystemFunctionalTests;
import org.kurento.repository.Repository;
import org.kurento.repository.RepositoryApiConfiguration;
import org.kurento.repository.RepositoryItem;
import org.kurento.repository.internal.http.RepositoryHttpServlet;
import org.kurento.test.base.KurentoClientBrowserTest;
import org.kurento.test.browser.WebRtcTestPage;
import org.kurento.test.config.TestScenario;
import org.kurento.test.services.KurentoServicesTestHelper;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

@Category(value={SystemFunctionalTests.class})
public class RepositoryFunctionalTest
extends KurentoClientBrowserTest<WebRtcTestPage> {
    public Repository repository;

    public RepositoryFunctionalTest(TestScenario testScenario) {
        super(testScenario);
        this.setWebServerClass(RepositoryWebServer.class);
    }

    @Before
    public void setupHttpServer() throws Exception {
        this.repository = (Repository)context.getBean("repository");
    }

    @ComponentScan(basePackageClasses={RepositoryItem.class})
    public static class RepositoryWebServer
    extends KurentoClientBrowserTest.WebServer {
        @Bean
        public RepositoryHttpServlet repositoryHttpServlet() {
            return new RepositoryHttpServlet();
        }

        @Bean
        public ServletRegistrationBean repositoryServletRegistrationBean(RepositoryHttpServlet repositoryHttpServlet) {
            ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)repositoryHttpServlet, new String[]{"/repository_servlet/*"});
            servletRegistrationBean.setLoadOnStartup(1);
            return servletRegistrationBean;
        }

        @Bean
        public RepositoryApiConfiguration repositoryApiConfiguration() {
            RepositoryApiConfiguration config = new RepositoryApiConfiguration();
            config.setWebappPublicURL("http://localhost:" + KurentoServicesTestHelper.getAppHttpPort() + "/");
            config.setFileSystemFolder(Files.createTempDir().toString());
            config.setRepositoryType(RepositoryApiConfiguration.RepoType.FILESYSTEM);
            return config;
        }
    }
}

