/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.browser;

import com.google.common.base.Function;
import io.github.bonigarcia.wdm.ChromeDriverManager;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.test.base.KurentoClientBrowserTest;
import org.kurento.test.browser.BrowserType;
import org.kurento.test.browser.DockerBrowserManager;
import org.kurento.test.browser.WebPageType;
import org.kurento.test.config.BrowserScope;
import org.kurento.test.config.Protocol;
import org.kurento.test.docker.Docker;
import org.kurento.test.grid.GridHandler;
import org.kurento.test.grid.GridNode;
import org.kurento.test.services.AudioChannel;
import org.kurento.test.services.KurentoServicesTestHelper;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Browser
implements Closeable {
    public static Logger log = LoggerFactory.getLogger(Browser.class);
    private WebDriver driver;
    private String jobId;
    private Builder builder;
    private BrowserType browserType;
    private BrowserScope scope;
    private String browserVersion;
    private Platform platform;
    private String video;
    private String audio;
    private int recordAudio;
    private int audioSampleRate;
    private AudioChannel audioChannel;
    private int timeout;
    private boolean usePhysicalCam;
    private boolean enableScreenCapture;
    private String name;
    private String id;
    private double colorDistance;
    private int thresholdTime;
    private int numInstances;
    private int browserPerInstance;
    private Protocol protocol;
    private String node;
    private String host;
    private int serverPort;
    private WebPageType webPageType;
    private String webPagePath;
    private String login;
    private String passwd;
    private String pem;
    private boolean avoidProxy;
    private String parentTunnel;
    private List<Map<String, String>> extensions;
    private String url;
    private static volatile DockerBrowserManager dockerManager;
    private static Docker docker;

    public Browser(Builder builder) {
        this.builder = builder;
        this.scope = builder.scope;
        this.video = builder.video;
        this.audio = builder.audio;
        this.serverPort = PropertiesManager.getProperty((String)"test.port", (int)PropertiesManager.getProperty((String)"test.public.port", (int)builder.serverPort));
        this.webPageType = builder.webPageType;
        this.browserType = builder.browserType;
        this.usePhysicalCam = builder.usePhysicalCam;
        this.enableScreenCapture = builder.enableScreenCapture;
        this.recordAudio = builder.recordAudio;
        this.audioSampleRate = builder.audioSampleRate;
        this.audioChannel = builder.audioChannel;
        this.browserVersion = builder.browserVersion;
        this.platform = builder.platform;
        this.timeout = builder.timeout;
        this.colorDistance = builder.colorDistance;
        this.thresholdTime = builder.thresholdTime;
        this.node = builder.node;
        this.protocol = builder.protocol;
        this.numInstances = builder.numInstances;
        this.browserPerInstance = builder.browserPerInstance;
        this.login = builder.login;
        this.passwd = builder.passwd;
        this.pem = builder.pem;
        this.host = builder.host;
        this.avoidProxy = builder.avoidProxy;
        this.parentTunnel = builder.parentTunnel;
        this.extensions = builder.extensions;
        this.url = builder.url;
        this.webPagePath = builder.webPagePath;
    }

    public void init() {
        log.info("Starting browser {}", (Object)this.getId());
        Class<? extends WebDriver> driverClass = this.browserType.getDriverClass();
        try {
            DesiredCapabilities capabilities = new DesiredCapabilities();
            if (driverClass.equals(FirefoxDriver.class)) {
                this.createFirefoxBrowser(capabilities);
            } else if (driverClass.equals(ChromeDriver.class)) {
                this.createChromeBrowser(capabilities);
            } else if (driverClass.equals(InternetExplorerDriver.class)) {
                if (this.scope == BrowserScope.SAUCELABS) {
                    capabilities.setBrowserName(DesiredCapabilities.internetExplorer().getBrowserName());
                    capabilities.setCapability("ignoreProtectedModeSettings", true);
                    this.createSaucelabsDriver(capabilities);
                }
            } else if (driverClass.equals(SafariDriver.class) && this.scope == BrowserScope.SAUCELABS) {
                capabilities.setBrowserName(DesiredCapabilities.safari().getBrowserName());
                this.createSaucelabsDriver(capabilities);
            }
            this.changeTimeout(this.timeout);
            log.debug("Browser {} started", (Object)this.getId());
            this.calculateUrl();
            log.debug("Browser {} loading url {}", (Object)this.getId(), (Object)this.url);
            this.driver.get(this.url);
            log.info("Browser {} initialized", (Object)this.getId());
        }
        catch (MalformedURLException e) {
            log.error("MalformedURLException in Browser.init", (Throwable)e);
        }
    }

    private void calculateUrl() {
        if (this.url == null) {
            if (this.protocol == Protocol.FILE) {
                String webPage = this.webPagePath != null ? this.webPagePath : this.webPageType.toString();
                File webPageFile = new File(this.getClass().getClassLoader().getResource("static" + webPage).getFile());
                this.url = this.protocol.toString() + webPageFile.getAbsolutePath();
            } else {
                String hostName = this.scope == BrowserScope.DOCKER ? (docker.isRunningInContainer() ? docker.getContainerIpAddress() : docker.getHostIpForContainers()) : (this.host != null ? this.host : this.node);
                this.url = this.protocol.toString() + hostName + ":" + this.serverPort + this.webPageType.toString();
            }
        }
    }

    private void createChromeBrowser(DesiredCapabilities capabilities) throws MalformedURLException {
        ChromeDriverManager.getInstance().setup();
        ChromeOptions options = new ChromeOptions();
        if (this.extensions != null && !this.extensions.isEmpty()) {
            for (Map<String, String> extension : this.extensions) {
                InputStream is = this.getExtensionAsInputStream(extension.values().iterator().next());
                if (is == null) continue;
                try {
                    File crx = File.createTempFile(extension.keySet().iterator().next(), ".crx");
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)crx);
                    options.addExtensions(new File[]{crx});
                }
                catch (Throwable t) {
                    log.error("Error loading Chrome extension {} ({} : {})", new Object[]{extension, t.getClass(), t.getMessage()});
                }
            }
        }
        if (this.enableScreenCapture) {
            options.addArguments(new String[]{"--enable-usermedia-screen-capturing"});
            String windowTitle = "Entire screen";
            if (this.platform != null && (this.platform == Platform.WINDOWS || this.platform == Platform.XP || this.platform == Platform.VISTA || this.platform == Platform.WIN8 || this.platform == Platform.WIN8_1)) {
                windowTitle = "Screen 1";
            }
            options.addArguments(new String[]{"--auto-select-desktop-capture-source=" + PropertiesManager.getProperty((String)"test.screenshare.title", (String)windowTitle)});
        } else {
            options.addArguments(new String[]{"--use-fake-ui-for-media-stream"});
        }
        options.addArguments(new String[]{"--test-type"});
        if (this.protocol == Protocol.FILE) {
            options.addArguments(new String[]{"--allow-file-access-from-files"});
        }
        if (!this.usePhysicalCam) {
            options.addArguments(new String[]{"--use-fake-device-for-media-stream"});
            if (this.video != null && (this.isLocal() || this.isDocker())) {
                if (!Files.exists(Paths.get(this.video, new String[0]), new LinkOption[0])) {
                    throw new RuntimeException("Trying to create a browser using video file " + this.video + ", but this file doesn't exist.");
                }
                log.debug("Using video {} in browser {}", (Object)this.video, (Object)this.id);
                options.addArguments(new String[]{"--use-file-for-fake-video-capture=" + this.video});
            }
        }
        capabilities.setCapability("chromeOptions", (Object)options);
        capabilities.setBrowserName(DesiredCapabilities.chrome().getBrowserName());
        this.createDriver(capabilities, options);
    }

    private void createFirefoxBrowser(DesiredCapabilities capabilities) throws MalformedURLException {
        FirefoxProfile profile = new FirefoxProfile();
        profile.setPreference("media.navigator.permission.disabled", true);
        capabilities.setCapability("firefox_profile", (Object)profile);
        capabilities.setBrowserName(DesiredCapabilities.firefox().getBrowserName());
        if (this.extensions != null && !this.extensions.isEmpty()) {
            for (Map<String, String> extension : this.extensions) {
                InputStream is = this.getExtensionAsInputStream(extension.values().iterator().next());
                if (is == null) continue;
                try {
                    File xpi = File.createTempFile(extension.keySet().iterator().next(), ".xpi");
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)xpi);
                    profile.addExtension(xpi);
                }
                catch (Throwable t) {
                    log.error("Error loading Firefox extension {} ({} : {})", new Object[]{extension, t.getClass(), t.getMessage()});
                }
            }
        }
        this.createDriver(capabilities, profile);
    }

    private void createDriver(DesiredCapabilities capabilities, Object options) throws MalformedURLException {
        log.debug("Creating driver in scope {} for browser {}", (Object)this.scope, (Object)this.id);
        if (this.scope == BrowserScope.SAUCELABS) {
            this.createSaucelabsDriver(capabilities);
        } else if (this.scope == BrowserScope.REMOTE) {
            this.createRemoteDriver(capabilities);
        } else {
            this.driver = this.scope == BrowserScope.DOCKER ? this.getDockerManager().createDockerDriver(this.id, capabilities) : Browser.newWebDriver(options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DockerBrowserManager getDockerManager() {
        if (dockerManager != null) return dockerManager;
        Class<Browser> clazz = Browser.class;
        synchronized (Browser.class) {
            if (dockerManager != null) return dockerManager;
            dockerManager = new DockerBrowserManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dockerManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebDriver newWebDriver(Object options) {
        ChromeDriver driver = null;
        int numDriverTries = 0;
        int maxDriverError = PropertiesManager.getProperty((String)"selenium.max.driver.error", (int)10);
        String errMessage = "Exception creating webdriver for chrome";
        do {
            try {
                if (options instanceof ChromeOptions) {
                    driver = new ChromeDriver((ChromeOptions)options);
                    continue;
                }
                if (!(options instanceof FirefoxProfile)) continue;
                driver = new FirefoxDriver((FirefoxProfile)options);
            }
            catch (Throwable t) {
                driver = null;
                log.warn("Exception creating webdriver for chrome #" + numDriverTries, t);
            }
            finally {
                if (++numDriverTries > maxDriverError) {
                    throw new KurentoException("Exception creating webdriver for chrome (" + maxDriverError + " times)");
                }
            }
        } while (driver == null);
        return driver;
    }

    public void reload() {
        if (this.url != null) {
            this.driver.get(this.url);
        }
    }

    public InputStream getExtensionAsInputStream(String extension) {
        InputStream is = null;
        try {
            log.debug("Trying to locate extension in the classpath ({}) ...", (Object)extension);
            is = ClassLoader.getSystemResourceAsStream(extension);
            if (is.available() < 0) {
                log.warn("Extension {} is not located in the classpath", (Object)extension);
                is = null;
            } else {
                log.debug("Success. Loading extension {} from classpath", (Object)extension);
            }
        }
        catch (Throwable t) {
            log.warn("Exception reading extension {} in the classpath ({} : {})", new Object[]{extension, t.getClass(), t.getMessage()});
            is = null;
        }
        if (is == null) {
            try {
                log.debug("Trying to locate extension as URL ({}) ...", (Object)extension);
                URL url = new URL(extension);
                is = url.openStream();
                log.debug("Success. Loading extension {} from URL", (Object)extension);
            }
            catch (Throwable t) {
                log.warn("Exception reading extension {} as URL ({} : {})", new Object[]{extension, t.getClass(), t.getMessage()});
            }
        }
        if (is == null) {
            throw new RuntimeException(extension + " is not a valid extension (it is not located in project" + " classpath neither is a valid URL)");
        }
        return is;
    }

    public void changeTimeout(int timeoutSeconds) {
        this.driver.manage().timeouts().implicitlyWait((long)timeoutSeconds, TimeUnit.SECONDS);
        this.driver.manage().timeouts().setScriptTimeout((long)timeoutSeconds, TimeUnit.SECONDS);
    }

    public void createSaucelabsDriver(DesiredCapabilities capabilities) throws MalformedURLException {
        this.assertPublicIpNotNull();
        String sauceLabsUser = PropertiesManager.getProperty((String)"saucelab.user");
        String sauceLabsKey = PropertiesManager.getProperty((String)"saucelab.key");
        int idleTimeout = PropertiesManager.getProperty((String)"saucelab.idle.timeout", (int)120);
        int commandTimeout = PropertiesManager.getProperty((String)"saucelab.command.timeout", (int)300);
        int maxDuration = PropertiesManager.getProperty((String)"saucelab.max.duration", (int)1800);
        String seleniumVersion = PropertiesManager.getProperty((String)"selenium.version");
        if (sauceLabsUser == null || sauceLabsKey == null) {
            throw new RuntimeException("Invalid Saucelabs credentials: saucelab.user=" + sauceLabsUser + " " + "saucelab.key" + "=" + sauceLabsKey);
        }
        capabilities.setCapability("version", this.browserVersion);
        capabilities.setCapability("platform", this.platform);
        if (seleniumVersion != null) {
            capabilities.setCapability("seleniumVersion", seleniumVersion);
        }
        if (this.parentTunnel != null) {
            capabilities.setCapability("parent-tunnel", this.parentTunnel);
        }
        if (this.avoidProxy) {
            capabilities.setCapability("avoid-proxy", this.avoidProxy);
        }
        capabilities.setCapability("idleTimeout", (Object)idleTimeout);
        capabilities.setCapability("commandTimeout", (Object)commandTimeout);
        capabilities.setCapability("maxDuration", (Object)maxDuration);
        if (this.name != null) {
            capabilities.setCapability("name", this.name);
        }
        this.driver = new RemoteWebDriver(new URL("http://" + sauceLabsUser + ":" + sauceLabsKey + "@ondemand.saucelabs.com:80/wd/hub"), (Capabilities)capabilities);
        this.jobId = ((RemoteWebDriver)this.driver).getSessionId().toString();
        log.debug("%%%%%%%%%%%%% Saucelabs URL job for {} ({} {} in {}) %%%%%%%%%%%%%", new Object[]{this.id, this.browserType, this.browserVersion, this.platform});
        log.info("https://saucelabs.com/tests/{}", (Object)this.jobId);
    }

    public void createRemoteDriver(final DesiredCapabilities capabilities) throws MalformedURLException {
        this.assertPublicIpNotNull();
        String remoteHubUrl = PropertiesManager.getProperty((String)"selenium.remote.hub.url");
        GridNode gridNode = null;
        if (remoteHubUrl == null) {
            log.debug("Creating remote webdriver for {}", (Object)this.id);
            if (!GridHandler.getInstance().containsSimilarBrowserKey(this.id)) {
                if (this.login != null) {
                    System.setProperty("test.node.login", this.login);
                }
                if (this.passwd != null) {
                    System.setProperty("test.node.passwd", this.passwd);
                }
                if (this.pem != null) {
                    System.setProperty("test.node.pem", this.pem);
                }
                GridHandler.getInstance().filterValidNodes();
                if (!this.node.equals(this.host) && this.login != null && !this.login.isEmpty() && (this.passwd != null && !this.passwd.isEmpty() || this.pem != null && !this.pem.isEmpty())) {
                    gridNode = new GridNode(this.node, this.browserType, this.browserPerInstance, this.login, this.passwd, this.pem);
                    GridHandler.getInstance().addNode(this.id, gridNode);
                } else {
                    gridNode = GridHandler.getInstance().getRandomNodeFromList(this.id, this.browserType, this.browserPerInstance);
                }
                GridHandler.getInstance().startHub();
                GridHandler.getInstance().startNode(gridNode);
                if (this.video != null && this.browserType == BrowserType.CHROME) {
                    GridHandler.getInstance().copyRemoteVideo(gridNode, this.video);
                }
            } else {
                boolean started = false;
                do {
                    if ((gridNode = GridHandler.getInstance().getNode(this.id)) != null) {
                        started = gridNode.isStarted();
                    }
                    if (started) continue;
                    log.debug("Node {} is not started ... waiting 1 second", (Object)this.id);
                    this.waitSeconds(1L);
                } while (!started);
            }
            if (this.video != null && this.browserType == BrowserType.CHROME) {
                ChromeOptions options = (ChromeOptions)capabilities.getCapability("chromeOptions");
                options.addArguments(new String[]{"--use-file-for-fake-video-capture=" + GridHandler.getInstance().getFirstNode(this.id).getRemoteVideo(this.video)});
                capabilities.setCapability("chromeOptions", (Object)options);
            }
            int hubPort = GridHandler.getInstance().getHubPort();
            String hubHost = GridHandler.getInstance().getHubHost();
            log.debug("Creating remote webdriver of {} ({})", (Object)this.id, (Object)gridNode.getHost());
            remoteHubUrl = "http://" + hubHost + ":" + hubPort + "/wd/hub";
        }
        final String remoteHub = remoteHubUrl;
        Thread t = new Thread(){

            @Override
            public void run() {
                boolean exception = false;
                do {
                    try {
                        Browser.this.driver = (WebDriver)new RemoteWebDriver(new URL(remoteHub), (Capabilities)capabilities);
                        exception = false;
                    }
                    catch (MalformedURLException | WebDriverException e) {
                        log.error("Exception {} creating RemoteWebDriver ... retrying in 1 second", e.getClass());
                        Browser.this.waitSeconds(1L);
                        exception = true;
                    }
                } while (exception);
            }
        };
        t.start();
        int timeout = PropertiesManager.getProperty((String)"selenium.remotedriver.timeout", (int)120);
        String nodeMsg = gridNode != null ? " (" + gridNode.getHost() + ")" : "";
        for (int i = 0; i < timeout; ++i) {
            if (!t.isAlive()) {
                log.debug("Remote webdriver of {}{} created", (Object)this.id, (Object)nodeMsg);
                return;
            }
            log.debug("Waiting for RemoteWebDriver {}{}", (Object)this.id, (Object)nodeMsg);
            this.waitSeconds(1L);
        }
        String exceptionMessage = "Remote webdriver of " + this.id + nodeMsg + " not created in " + timeout + "seconds";
        log.error(">>>>>>>>>> " + exceptionMessage);
        throw new RuntimeException(exceptionMessage);
    }

    private void waitSeconds(long timeInSeconds) {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(timeInSeconds));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void assertPublicIpNotNull() {
        if (this.host == null) {
            throw new RuntimeException("Public IP must be available to run remote test. You can do it by adding the paramter -Dtest.host=<public_ip> or with key 'host' in the JSON configuration file.");
        }
    }

    public void injectKurentoTestJs() {
        if (this.getBrowserType() != BrowserType.IEXPLORER) {
            String kurentoTestJs = "var kurentoScript=window.document.createElement('script');";
            String kurentoTestJsPath = "./lib/kurento-test.js";
            if (this.getProtocol() == Protocol.FILE) {
                File pageFile = new File(this.getClass().getClassLoader().getResource("static/lib/kurento-test.js").getFile());
                kurentoTestJsPath = this.getProtocol().toString() + pageFile.getAbsolutePath();
            }
            kurentoTestJs = kurentoTestJs + "kurentoScript.src='" + kurentoTestJsPath + "';";
            kurentoTestJs = kurentoTestJs + "window.document.head.appendChild(kurentoScript);";
            kurentoTestJs = kurentoTestJs + "return true;";
            this.executeScript(kurentoTestJs);
        }
    }

    public int getRecordAudio() {
        return this.recordAudio;
    }

    public int getAudioSampleRate() {
        return this.audioSampleRate;
    }

    public AudioChannel getAudioChannel() {
        return this.audioChannel;
    }

    public String getAudio() {
        return this.audio;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getTimeoutMs() {
        return TimeUnit.SECONDS.toMillis(this.timeout);
    }

    public WebDriver getWebDriver() {
        return this.driver;
    }

    public JavascriptExecutor getJs() {
        return (JavascriptExecutor)this.driver;
    }

    public Object executeScriptAndWaitOutput(final String command) {
        WebDriverWait wait = new WebDriverWait(this.driver, (long)this.timeout);
        wait.withMessage("Timeout executing script: " + command);
        final Object[] out = new Object[1];
        wait.until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                try {
                    out[0] = Browser.this.executeScript(command);
                }
                catch (WebDriverException we) {
                    log.warn("Exception executing script", (Throwable)we);
                    out[0] = null;
                }
                return out[0] != null;
            }
        });
        return out[0];
    }

    public Object executeScript(String command) {
        return ((JavascriptExecutor)this.driver).executeScript(command, new Object[0]);
    }

    public double getColorDistance() {
        return this.colorDistance;
    }

    public int getThresholdTime() {
        return this.thresholdTime;
    }

    public void setThresholdTime(int thresholdTime) {
        this.thresholdTime = thresholdTime;
    }

    public boolean isLocal() {
        return BrowserScope.LOCAL.equals((Object)this.scope);
    }

    public boolean isRemote() {
        return BrowserScope.REMOTE.equals((Object)this.scope);
    }

    public boolean isSauceLabs() {
        return BrowserScope.SAUCELABS.equals((Object)this.scope);
    }

    public boolean isDocker() {
        return BrowserScope.DOCKER.equals((Object)this.scope);
    }

    public BrowserType getBrowserType() {
        return this.browserType;
    }

    public BrowserScope getScope() {
        return this.scope;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getVideo() {
        return this.video;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public WebPageType getWebPageType() {
        return this.webPageType;
    }

    public boolean isUsePhysicalCam() {
        return this.usePhysicalCam;
    }

    public boolean isEnableScreenCapture() {
        return this.enableScreenCapture;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getNode() {
        return this.node;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getNumInstances() {
        return this.numInstances;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public String getPem() {
        return this.pem;
    }

    public int getBrowserPerInstance() {
        return this.browserPerInstance;
    }

    public String getHost() {
        return this.host;
    }

    public void setTimeout(int timeoutSeconds) {
        this.timeout = timeoutSeconds;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public URL getUrl() {
        String ip = this.getHost();
        int port = this.getServerPort();
        String protocol = this.getProtocol().toString();
        String path = this.getWebPageType().toString();
        URL url = null;
        try {
            url = new URL(protocol + ip + ":" + port + path);
        }
        catch (MalformedURLException e) {
            log.error("Malformed URL", (Throwable)e);
            throw new RuntimeException(e);
        }
        return url;
    }

    @Override
    public void close() {
        if (this.driver != null) {
            try {
                log.debug("Closing webdriver of {} ", (Object)this.id);
                this.driver.quit();
                this.driver = null;
            }
            catch (Throwable t) {
                log.warn("** Exception closing webdriver {} : {}", t.getClass(), (Object)t.getMessage());
            }
        }
        if (GridHandler.getInstance().useRemoteNodes()) {
            log.debug("Closing Grid of {} ", (Object)this.id);
            GridHandler.getInstance().stopGrid();
        }
        if (this.scope == BrowserScope.DOCKER) {
            Path logFile = Paths.get(KurentoClientBrowserTest.getDefaultOutputFile(""), new String[0]);
            try {
                if (!Files.exists(logFile, new LinkOption[0])) {
                    Files.createDirectories(logFile, new FileAttribute[0]);
                }
                this.getDockerManager().setDownloadLogsPath(logFile);
            }
            catch (IOException e) {
                log.warn("Exception creating path {} for logs", (Object)logFile);
            }
            this.getDockerManager().closeDriver(this.id);
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    static {
        docker = Docker.getSingleton();
    }

    public static class Builder {
        private int timeout = 60;
        private int thresholdTime = 10;
        private double colorDistance = 60.0;
        private String node;
        private String host = this.node = PropertiesManager.getProperty((String)"test.host", (String)PropertiesManager.getProperty((String)"test.public.ip", (String)"127.0.0.1"));
        private int serverPort = PropertiesManager.getProperty((String)"test.port", (int)PropertiesManager.getProperty((String)"test.public.port", (int)KurentoServicesTestHelper.getAppHttpPort()));
        private BrowserScope scope = BrowserScope.LOCAL;
        private BrowserType browserType = BrowserType.CHROME;
        private Protocol protocol = Protocol.valueOf(PropertiesManager.getProperty((String)"test.protocol", (String)"http").toUpperCase());
        private WebPageType webPageType = WebPageType.value2WebPageType(PropertiesManager.getProperty((String)"test.path", (String)"/"));
        private boolean usePhysicalCam = false;
        private boolean enableScreenCapture = false;
        private int recordAudio = 0;
        private int audioSampleRate;
        private AudioChannel audioChannel;
        private int numInstances = 0;
        private int browserPerInstance = 1;
        private String video;
        private String audio;
        private String browserVersion;
        private Platform platform;
        private String login;
        private String passwd;
        private String pem;
        private boolean avoidProxy;
        private String parentTunnel;
        private List<Map<String, String>> extensions;
        private String url;
        private String webPagePath;

        public Builder browserPerInstance(int browserPerInstance) {
            this.browserPerInstance = browserPerInstance;
            return this;
        }

        public Builder login(String login) {
            this.login = login;
            return this;
        }

        public Builder passwd(String passwd) {
            this.passwd = passwd;
            return this;
        }

        public Builder pem(String pem) {
            this.pem = pem;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder numInstances(int numInstances) {
            this.numInstances = numInstances;
            return this;
        }

        public Builder serverPort(int serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public Builder node(String node) {
            this.node = node;
            return this;
        }

        public Builder scope(BrowserScope scope) {
            String scopeProp = PropertiesManager.getProperty((String)"test.selenium.scope");
            if (scopeProp != null) {
                scope = BrowserScope.valueOf(scopeProp.toUpperCase());
            }
            this.scope = scope;
            String appAutostart = PropertiesManager.getProperty((String)"test.app.autostart", (String)"testsuite");
            if (BrowserScope.DOCKER.equals((Object)scope) && !appAutostart.equals("false")) {
                this.node = docker.isRunningInContainer() ? docker.getContainerIpAddress() : docker.getHostIpForContainers();
            }
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder thresholdTime(int thresholdTime) {
            this.thresholdTime = thresholdTime;
            return this;
        }

        public Builder colorDistance(double colorDistance) {
            this.colorDistance = colorDistance;
            return this;
        }

        public Builder video(String video) {
            this.video = video;
            return this;
        }

        public Builder webPageType(WebPageType webPageType) {
            this.webPageType = webPageType;
            return this;
        }

        public Builder browserType(BrowserType browser) {
            this.browserType = browser;
            return this;
        }

        public Builder usePhysicalCam() {
            this.usePhysicalCam = true;
            return this;
        }

        public Builder avoidProxy() {
            this.avoidProxy = true;
            return this;
        }

        public Builder parentTunnel(String parentTunnel) {
            this.parentTunnel = parentTunnel;
            return this;
        }

        public Builder enableScreenCapture() {
            this.enableScreenCapture = true;
            return this;
        }

        public Builder audio(String audio, int recordAudio, int audioSampleRate, AudioChannel audioChannel) {
            this.audio = audio;
            this.recordAudio = recordAudio;
            this.audioSampleRate = audioSampleRate;
            this.audioChannel = audioChannel;
            return this;
        }

        public Builder browserVersion(String browserVersion) {
            this.browserVersion = browserVersion;
            return this;
        }

        public Builder platform(Platform platform) {
            this.platform = platform;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder extensions(List<Map<String, String>> extensions) {
            this.extensions = extensions;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder webPagePath(String webPagePath) {
            this.webPagePath = webPagePath;
            return this;
        }

        public Browser build() {
            return new Browser(this);
        }
    }
}

