/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.browser;

import com.google.common.base.Function;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.junit.After;
import org.kurento.client.EventListener;
import org.kurento.client.IceCandidate;
import org.kurento.client.MediaStateChangedEvent;
import org.kurento.client.OnIceCandidateEvent;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.commons.exception.KurentoException;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.browser.Browser;
import org.kurento.test.browser.BrowserEventListener;
import org.kurento.test.browser.ConsoleLogLevel;
import org.kurento.test.browser.WebPage;
import org.kurento.test.browser.WebRtcChannel;
import org.kurento.test.browser.WebRtcMode;
import org.kurento.test.grid.GridHandler;
import org.kurento.test.latency.VideoTagType;
import org.kurento.test.services.Recorder;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebRtcTestPage
extends WebPage {
    protected static final String LOCAL_VIDEO = "local";
    protected static final String REMOTE_VIDEO = "video";
    private List<Thread> callbackThreads = new ArrayList<Thread>();
    private Map<String, CountDownLatch> countDownLatchEvents = new HashMap<String, CountDownLatch>();

    @After
    public void teardownKurentoServices() throws Exception {
        for (Thread t : this.callbackThreads) {
            t.stop();
        }
    }

    @Override
    public void setBrowser(Browser browserClient) {
        super.setBrowser(browserClient);
        this.checkColor(LOCAL_VIDEO, REMOTE_VIDEO);
        VideoTagType.setLocalId(LOCAL_VIDEO);
        VideoTagType.setRemoteId(REMOTE_VIDEO);
    }

    @Override
    public void setColorCoordinates(int x, int y) {
        this.browser.getWebDriver().findElement(By.id((String)"x")).clear();
        this.browser.getWebDriver().findElement(By.id((String)"y")).clear();
        this.browser.getWebDriver().findElement(By.id((String)"x")).sendKeys(new CharSequence[]{String.valueOf(x)});
        this.browser.getWebDriver().findElement(By.id((String)"y")).sendKeys(new CharSequence[]{String.valueOf(y)});
        super.setColorCoordinates(x, y);
    }

    public boolean similarColor(Color expectedColor) {
        return this.similarColor(REMOTE_VIDEO, expectedColor);
    }

    public boolean similarColorAt(Color expectedColor, int x, int y) {
        return this.similarColorAt(REMOTE_VIDEO, expectedColor, x, y);
    }

    public void close() {
        this.browser.close();
    }

    public void subscribeEvents(String eventType) {
        this.subscribeEventsToVideoTag(REMOTE_VIDEO, eventType);
    }

    public void subscribeLocalEvents(String eventType) {
        this.subscribeEventsToVideoTag(LOCAL_VIDEO, eventType);
    }

    public void subscribeEventsToVideoTag(final String videoTag, final String eventType) {
        CountDownLatch latch = new CountDownLatch(1);
        final String browserName = this.browser.getId();
        log.info("Subscribe event '{}' in video tag '{}' in browser '{}'", new Object[]{eventType, videoTag, browserName});
        this.countDownLatchEvents.put(browserName + eventType, latch);
        this.addEventListener(videoTag, eventType, new BrowserEventListener(){

            @Override
            public void onEvent(String event) {
                WebRtcTestPage.this.consoleLog(ConsoleLogLevel.INFO, "Event in " + videoTag + " tag: " + event);
                ((CountDownLatch)WebRtcTestPage.this.countDownLatchEvents.get(browserName + eventType)).countDown();
            }
        });
    }

    public boolean waitForEvent(String eventType) throws InterruptedException {
        String browserName = this.browser.getId();
        log.info("Waiting for event '{}' in browser '{}'", (Object)eventType, (Object)browserName);
        if (!this.countDownLatchEvents.containsKey(browserName + eventType)) {
            log.error("We cannot wait for an event without previous subscription");
            return false;
        }
        boolean result = this.countDownLatchEvents.get(browserName + eventType).await(this.browser.getTimeout(), TimeUnit.SECONDS);
        if (eventType.equalsIgnoreCase("playing") && this.browser.getRecordAudio() > 0) {
            if (this.browser.isRemote()) {
                Recorder.recordRemote(GridHandler.getInstance().getNode(this.browser.getId()), this.browser.getRecordAudio(), this.browser.getAudioSampleRate(), this.browser.getAudioChannel());
            } else {
                Recorder.record(this.browser.getRecordAudio(), this.browser.getAudioSampleRate(), this.browser.getAudioChannel());
            }
        }
        this.countDownLatchEvents.remove(browserName + eventType);
        return result;
    }

    public void addEventListener(final String videoTag, final String eventType, final BrowserEventListener eventListener) {
        Thread t = new Thread(){

            @Override
            public void run() {
                WebRtcTestPage.this.browser.executeScript(videoTag + ".addEventListener('" + eventType + "', videoEvent, false);");
                try {
                    new WebDriverWait(WebRtcTestPage.this.browser.getWebDriver(), (long)WebRtcTestPage.this.browser.getTimeout()).until((Function)new ExpectedCondition<Boolean>(){

                        public Boolean apply(WebDriver d) {
                            return d.findElement(By.id((String)"status")).getAttribute("value").equalsIgnoreCase(eventType);
                        }
                    });
                    eventListener.onEvent(eventType);
                }
                catch (Throwable t) {
                    WebPage.log.error("~~~ Exception in addEventListener {}", (Object)t.getMessage());
                    t.printStackTrace();
                    this.interrupt();
                    this.stop();
                }
            }
        };
        this.callbackThreads.add(t);
        t.setDaemon(true);
        t.start();
    }

    public void start(String videoUrl) {
        this.browser.executeScript("play('" + videoUrl + "', false);");
    }

    public void stopPlay() {
        this.browser.executeScript("terminate();");
    }

    public void consoleLog(ConsoleLogLevel level, String message) {
        log.info(message);
        this.browser.executeScript("console." + level.toString() + "('" + message + "');");
    }

    public double getCurrentTime() {
        log.debug("getCurrentTime() called");
        double currentTime = Double.parseDouble(this.browser.getWebDriver().findElement(By.id((String)"currentTime")).getAttribute("value"));
        log.debug("getCurrentTime() result: {}", (Object)currentTime);
        return currentTime;
    }

    public String readConsole() {
        return this.browser.getWebDriver().findElement(By.id((String)"console")).getText();
    }

    public boolean compare(double i, double j) {
        return Math.abs(j - i) <= (double)this.browser.getThresholdTime();
    }

    protected void addIceCandidate(JsonObject candidate) {
        this.browser.executeScript("addIceCandidate('" + candidate + "');");
    }

    public void initWebRtc(final WebRtcEndpoint webRtcEndpoint, WebRtcChannel channel, WebRtcMode mode) throws InterruptedException {
        webRtcEndpoint.addOnIceCandidateListener((EventListener)new EventListener<OnIceCandidateEvent>(){

            public void onEvent(OnIceCandidateEvent event) {
                JsonObject candidate = JsonUtils.toJsonObject((Object)event.getCandidate());
                WebPage.log.debug("OnIceCandidateEvent on {}: {}", (Object)webRtcEndpoint.getId(), (Object)candidate);
                WebRtcTestPage.this.addIceCandidate(candidate);
            }
        });
        webRtcEndpoint.addMediaStateChangedListener((EventListener)new EventListener<MediaStateChangedEvent>(){

            public void onEvent(MediaStateChangedEvent event) {
                WebPage.log.debug("MediaStateChangedEvent from {} to {} on {} at {}", new Object[]{event.getOldState(), event.getNewState(), webRtcEndpoint.getId(), event.getTimestamp()});
            }
        });
        WebRtcConfigurer webRtcConfigurer = new WebRtcConfigurer(){

            @Override
            public void addIceCandidate(IceCandidate candidate) {
                webRtcEndpoint.addIceCandidate(candidate);
            }

            @Override
            public String processOffer(String sdpOffer) {
                String sdpAnswer = webRtcEndpoint.processOffer(sdpOffer);
                webRtcEndpoint.gatherCandidates();
                return sdpAnswer;
            }
        };
        this.initWebRtc(webRtcConfigurer, channel, mode);
    }

    protected void initWebRtc(final WebRtcConfigurer webRtcConfigurer, WebRtcChannel channel, WebRtcMode mode) throws InterruptedException {
        String channelJsFunction;
        Thread t1 = new Thread(){

            @Override
            public void run() {
                JsonParser parser = new JsonParser();
                int numCandidate = 0;
                try {
                    while (true) {
                        ArrayList iceCandidates = (ArrayList)WebRtcTestPage.this.browser.executeScript("return iceCandidates;");
                        for (int i = numCandidate; i < iceCandidates.size(); ++i) {
                            JsonObject jsonCandidate = (JsonObject)parser.parse(iceCandidates.get(i).toString());
                            IceCandidate candidate = new IceCandidate(jsonCandidate.get("candidate").getAsString(), jsonCandidate.get("sdpMid").getAsString(), jsonCandidate.get("sdpMLineIndex").getAsInt());
                            WebPage.log.debug("Adding candidate {}: {}", (Object)i, (Object)jsonCandidate);
                            webRtcConfigurer.addIceCandidate(candidate);
                            ++numCandidate;
                        }
                        Thread.sleep(300L);
                    }
                }
                catch (Throwable e) {
                    WebPage.log.debug("Exiting gather candidates thread");
                    return;
                }
            }
        };
        t1.start();
        this.addTestName(KurentoTest.getTestClassName() + "." + KurentoTest.getTestMethodName());
        this.appendStringToTitle(mode.toString());
        this.appendStringToTitle(channel.toString());
        String audio = this.browser.getAudio();
        if (audio != null) {
            this.browser.executeScript("setCustomAudio('" + audio + "');");
        }
        if ((channelJsFunction = channel.getJsFunction()) != null) {
            this.browser.executeScript(channelJsFunction);
        }
        this.browser.executeScript(mode.getJsFunction());
        final CountDownLatch latch = new CountDownLatch(1);
        Thread t2 = new Thread(){

            @Override
            public void run() {
                String sdpOffer = (String)WebRtcTestPage.this.browser.executeScriptAndWaitOutput("return sdpOffer;");
                WebPage.log.debug("SDP offer: {}", (Object)sdpOffer);
                String sdpAnswer = webRtcConfigurer.processOffer(sdpOffer);
                WebPage.log.debug("SDP answer: {}", (Object)sdpAnswer);
                sdpAnswer = new String(Base64.encodeBase64((byte[])sdpAnswer.getBytes()));
                WebRtcTestPage.this.browser.executeScript("processSdpAnswer('" + sdpAnswer + "');");
                latch.countDown();
            }
        };
        t2.start();
        if (!latch.await(this.browser.getTimeout(), TimeUnit.SECONDS)) {
            t1.interrupt();
            t1.stop();
            t2.interrupt();
            t2.stop();
            throw new KurentoException("ICE negotiation not finished in " + this.browser.getTimeout() + " seconds");
        }
    }

    public void reload() {
        this.browser.reload();
        this.browser.injectKurentoTestJs();
        this.browser.executeScriptAndWaitOutput("return kurentoTest;");
        this.setBrowser(this.browser);
    }

    public void stopWebRtc() {
        this.browser.executeScript("stop();");
        this.browser.executeScript("var kurentoTest = new KurentoTest();");
        this.countDownLatchEvents.clear();
    }

    public void addTestName(String testName) {
        try {
            this.browser.executeScript("addTestName('" + testName + "');");
        }
        catch (WebDriverException we) {
            log.warn(we.getMessage());
        }
    }

    public void appendStringToTitle(String webRtcMode) {
        try {
            this.browser.executeScript("appendStringToTitle('" + webRtcMode + "');");
        }
        catch (WebDriverException we) {
            log.warn(we.getMessage());
        }
    }

    public static interface WebRtcConfigurer {
        public void addIceCandidate(IceCandidate var1);

        public String processOffer(String var1);
    }
}

