/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import com.github.dockerjava.api.model.Statistics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kurento.test.docker.Docker;
import org.kurento.test.monitor.KmsSystemInfo;
import org.kurento.test.monitor.NetInfo;

public class KmsDockerMonitor {
    public static final String MONITOR_PORT_PROP = "kms.monitor.port";
    public static final int MONITOR_PORT_DEFAULT = 12345;
    public static final int KMS_WAIT_TIMEOUT = 10;
    private static final String ERR = "error: ";
    private double prevTotal = 0.0;
    private double prevIdle = 0.0;
    private int kmsPid;
    private NetInfo initNetInfo;
    private Docker docker = Docker.getSingleton();
    private String containerId;
    private Statistics stats;
    private long prevSystemCPU = -1L;
    private long prevContainerCPU = -1L;

    public KmsDockerMonitor(String containerId) {
        this.containerId = containerId;
    }

    public KmsSystemInfo measureKms() {
        KmsSystemInfo info = new KmsSystemInfo();
        this.stats = this.docker.getStatistics(this.containerId);
        if (this.initNetInfo == null) {
            this.initNetInfo = this.getInitNetInfo();
        }
        NetInfo newNetInfo = this.getNetInfo(this.initNetInfo);
        info.setNetInfo(newNetInfo);
        info.setCpuPercent(this.getCpuUsage());
        double[] mem = this.getMemSwap();
        info.setMem((long)mem[0]);
        info.setSwap((long)mem[1]);
        info.setMemPercent(mem[2]);
        info.setSwapPercent(mem[3]);
        info.setNumThreadsKms(-1);
        return info;
    }

    public NetInfo getNetInfo(NetInfo initNetInfo, NetInfo lastNetInfo) {
        NetInfo netInfo = new NetInfo();
        netInfo.putNetInfo("docker", (Long)this.stats.getNetworkStats().get("rx_bytes"), (Long)this.stats.getNetworkStats().get("rx_bytes"));
        if (initNetInfo != null) {
            netInfo.decrementInitInfo(initNetInfo);
        }
        if (lastNetInfo != null) {
            netInfo.decrementInitInfo(lastNetInfo);
        }
        return netInfo;
    }

    public NetInfo getNetInfo(NetInfo initNetInfo) {
        return this.getNetInfo(initNetInfo, null);
    }

    public NetInfo getInitNetInfo() {
        return this.getNetInfo(null, null);
    }

    public double getCpuUsage() {
        if (this.prevContainerCPU == -1L) {
            // empty if block
        }
        Statistics stats = this.docker.getStatistics(this.containerId);
        long totalUsage = (Long)((Map)stats.getCpuStats().get("cpu_usage")).get("total_usage");
        long systemUsage = (Long)stats.getCpuStats().get("total_usage");
        return totalUsage;
    }

    public double[] getMemSwap() {
        String[] mem = this.runAndWait("free").replaceAll("\n", ",").replaceAll(" +", " ").split(" ");
        long usedMem = Long.parseLong(mem[15]);
        long usedSwap = Long.parseLong(mem[19]);
        long totalMem = Long.parseLong(mem[7]);
        long totalSwap = Long.parseLong(mem[20]);
        double percetageMem = (double)usedMem / (double)totalMem * 100.0;
        double percetageSwap = (double)usedSwap / (double)totalSwap * 100.0;
        if (Double.isNaN(percetageMem)) {
            percetageMem = 0.0;
        }
        if (Double.isNaN(percetageSwap)) {
            percetageSwap = 0.0;
        }
        double[] out = new double[]{usedMem, usedSwap, percetageMem, percetageSwap};
        return out;
    }

    private int getKmsPid() {
        String kmsPid;
        System.out.println("Looking for KMS process...");
        boolean reachable = false;
        long endTimeMillis = System.currentTimeMillis() + 10000L;
        do {
            boolean bl = reachable = !(kmsPid = this.runAndWait("/bin/sh", "-c", "ps axf | grep kurento-media-server | grep -v grep | awk '{print $1}'").replaceAll("\n", "")).equals("");
            if (kmsPid.contains(" ")) {
                throw new RuntimeException("More than one KMS process are started (PIDs:" + kmsPid + ")");
            }
            if (reachable) break;
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        } while (System.currentTimeMillis() <= endTimeMillis);
        if (!reachable) {
            throw new RuntimeException("KMS is not started in the local machine");
        }
        System.out.println("KMS process located in local machine with PID " + kmsPid);
        return Integer.parseInt(kmsPid);
    }

    private int getNumThreads(int kmsPid) {
        return Integer.parseInt(this.runAndWait("/bin/sh", "-c", "cat /proc/" + kmsPid + "/stat | awk '{print $20}'").replaceAll("\n", ""));
    }

    private String runAndWait(String ... command) {
        try {
            Process p = new ProcessBuilder(command).redirectErrorStream(true).start();
            return this.inputStreamToString(p.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Exception executing command on the shell: " + Arrays.toString(command), e);
        }
    }

    private String inputStreamToString(InputStream in) throws IOException {
        InputStreamReader is = new InputStreamReader(in);
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(is);
        String read = br.readLine();
        while (read != null) {
            sb.append(read);
            read = br.readLine();
            sb.append('\n');
            sb.append(' ');
        }
        return sb.toString().trim();
    }
}

