/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import java.io.IOException;
import org.kurento.client.KurentoClient;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.services.KurentoClientTestFactory;
import org.kurento.test.services.KurentoServicesTestHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KurentoClientManager {
    protected static Logger log = LoggerFactory.getLogger(KurentoClientManager.class);
    protected KurentoClient kurentoClient;
    protected KurentoClient fakeKurentoClient;

    public KurentoClientManager() throws IOException {
        KurentoServicesTestHelper.startKurentoServicesIfNeccessary();
        this.kurentoClient = KurentoClientTestFactory.createKurentoForTest();
        String fakeWsUri = PropertiesManager.getProperty((String)"fake.kms.ws.uri");
        if (fakeWsUri != null) {
            this.fakeKurentoClient = KurentoClient.create((String)fakeWsUri);
        }
    }

    public void teardown() throws Exception {
        if (this.kurentoClient != null) {
            this.kurentoClient.destroy();
        }
        if (this.fakeKurentoClient != null) {
            this.fakeKurentoClient.destroy();
        }
        KurentoServicesTestHelper.teardownServices();
    }

    public KurentoClient getKurentoClient() {
        return this.kurentoClient;
    }

    public KurentoClient getFakeKurentoClient() {
        return this.fakeKurentoClient;
    }
}

