/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.InvalidParameterException;
import org.kurento.client.JsonRpcConnectionListenerKurento;
import org.kurento.client.KurentoClient;
import org.kurento.client.KurentoConnectionListener;
import org.kurento.commons.Address;
import org.kurento.commons.PropertiesManager;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.client.JsonRpcClientWebSocket;
import org.kurento.test.config.TestConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KurentoClientTestFactory {
    private static final Logger log = LoggerFactory.getLogger(KurentoClientTestFactory.class);

    public static KurentoClient createKurentoForTest() throws IOException {
        return KurentoClientTestFactory.createKurentoForTest(null);
    }

    public static KurentoClient createKurentoForTest(KurentoConnectionListener listener) throws IOException {
        return KurentoClient.createFromJsonRpcClient((JsonRpcClient)KurentoClientTestFactory.createJsonRpcClient("client", listener));
    }

    public static JsonRpcClient createJsonRpcClient(String prefix) {
        return KurentoClientTestFactory.createJsonRpcClient(prefix, null);
    }

    public static JsonRpcClient createJsonRpcClient(String prefix, KurentoConnectionListener listener) {
        if (prefix.equals("client")) {
            if (PropertiesManager.getProperty((String)"kcs.ws.uri") != null) {
                String wsUri = PropertiesManager.getProperty((String)"kcs.ws.uri");
                log.info("Connecting kurento client with websockets to uri '{}'", (Object)wsUri);
                return new JsonRpcClientWebSocket(wsUri, JsonRpcConnectionListenerKurento.create((KurentoConnectionListener)listener));
            }
            return KurentoClientTestFactory.createJsonRpcClient("kcs");
        }
        if (prefix.equals("kcs")) {
            String kmsTransport;
            switch (kmsTransport = PropertiesManager.getProperty((String)"kms.transport", (String)"ws")) {
                case "ws": {
                    String wsUri = PropertiesManager.getProperty((String)"kms.ws.uri", (String)"ws://localhost:8888/kurento");
                    log.info("Connecting to kms with websockets to uri '{}'", (Object)wsUri);
                    return new JsonRpcClientWebSocket(wsUri);
                }
                case "rabbitmq": {
                    Address rabbitAddress = PropertiesManager.getProperty((String)"kms.rabbitmq.address", (Address)TestConfiguration.KMS_RABBITMQ_ADDRESS_DEFAULT);
                    log.info("Connecting to kms with RabbitMQ in address '{}'", (Object)rabbitAddress);
                    return KurentoClientTestFactory.newJsonRpcClientRabbitMq(rabbitAddress);
                }
            }
            throw new RuntimeException("Invalid transport value in property 'kms.transport': " + kmsTransport + ". Valid values are: " + "rabbitmq" + " or " + "ws");
        }
        throw new InvalidParameterException();
    }

    private static JsonRpcClient newJsonRpcClientRabbitMq(Address rabbitMqAddress) {
        try {
            Class<?> clazz = Class.forName("org.kurento.rabbitmq.client.JsonRpcClientRabbitMq");
            Constructor<?> constructor = clazz.getConstructor(Address.class);
            return (JsonRpcClient)constructor.newInstance(rabbitMqAddress);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("KurentoClient is configured to use RabbitMQ but class JsonRpcClientRabbitMq is not in the classpath. Plase review you have correctly configured the dependency with kurento-rabbitmq project.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception creating JsonRpcClientRabbitMq", e);
        }
    }

    public static KurentoClient createWithJsonRpcClient(JsonRpcClient client) throws IOException {
        return KurentoClient.createFromJsonRpcClient((JsonRpcClient)client);
    }
}

