/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.google.common.io.CharStreams;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.commons.io.FileUtils;
import org.kurento.commons.Address;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.docker.Docker;
import org.kurento.test.services.KurentoServicesTestHelper;
import org.kurento.test.services.Shell;
import org.kurento.test.services.SshConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KurentoMediaServerManager {
    public static Logger log = LoggerFactory.getLogger(KurentoMediaServerManager.class);
    private static String lastWorkspace;
    private static SshConnection remoteKms;
    private String workspace;
    private int httpPort;
    private String serverCommand;
    private String gstPlugins;
    private String debugOptions;
    private Address rabbitMqAddress;
    private String wsUri;
    private String registrarUri;
    private String registrarLocalAddress = "127.0.0.1";
    private static boolean isKmsRemote;
    private static boolean docker;
    private static String dockerContainerName;
    private boolean kmsAutostarted = false;

    public static KurentoMediaServerManager kmsAlreadyStarted(String wsUri) {
        KurentoMediaServerManager manager = new KurentoMediaServerManager();
        manager.wsUri = wsUri;
        KurentoMediaServerManager.checkIfKmsIsRemote(wsUri);
        if (isKmsRemote) {
            String kmsLogin = PropertiesManager.getProperty((String)"kms.login");
            String kmsPasswd = PropertiesManager.getProperty((String)"kms.passwd");
            String kmsPem = PropertiesManager.getProperty((String)"kms.pem");
            String remoteKmsStr = wsUri.substring(wsUri.indexOf("//") + 2, wsUri.lastIndexOf(":"));
            remoteKms = new SshConnection(remoteKmsStr, kmsLogin, kmsPasswd, kmsPem);
            if (kmsPem != null) {
                remoteKms.setPem(kmsPem);
            }
        }
        return manager;
    }

    public static KurentoMediaServerManager createWithWsTransport(String wsUri, int httpPort) {
        KurentoMediaServerManager manager = new KurentoMediaServerManager();
        manager.wsUri = wsUri;
        manager.httpPort = httpPort;
        return manager;
    }

    public static KurentoMediaServerManager createWithRabbitMqTransport(Address rabbitMqAddress, int httpPort) {
        KurentoMediaServerManager manager = new KurentoMediaServerManager();
        manager.rabbitMqAddress = rabbitMqAddress;
        manager.httpPort = httpPort;
        return manager;
    }

    private KurentoMediaServerManager() {
    }

    private boolean isRemote() {
        return remoteKms != null;
    }

    public String getKmsLogPath() {
        String kmsAutoStart = PropertiesManager.getProperty((String)"test.kms.autostart", (String)"test");
        String kmsLogPath = PropertiesManager.getProperty((String)"kms.log.path", (String)"/var/log/kurento-media-server/");
        return kmsAutoStart.equals("false") ? kmsLogPath : (isKmsRemote ? remoteKms.getTmpFolder() + "/" : this.workspace);
    }

    public void start() throws IOException {
        this.start(false);
    }

    public void start(boolean isFake) throws IOException {
        String kmsLoginProp = isFake ? "fake.kms.login" : "kms.login";
        String kmsPasswdProp = isFake ? "fake.kms.passwd" : "kms.passwd";
        String kmsPemProp = isFake ? "fake.kms.pem" : "kms.pem";
        String kmsAutostartProp = isFake ? "fake.kms.autostart" : "test.kms.autostart";
        String kmsAutostartDefaultProp = isFake ? "false" : "test";
        String kmsWsUriProp = isFake ? "fake.kms.ws.uri" : "kms.ws.uri";
        String kmsLogin = PropertiesManager.getProperty((String)kmsLoginProp);
        String kmsPasswd = PropertiesManager.getProperty((String)kmsPasswdProp);
        String kmsPem = PropertiesManager.getProperty((String)kmsPemProp);
        String wsUri = this.wsUri != null ? this.wsUri : PropertiesManager.getProperty((String)kmsWsUriProp, (String)this.wsUri);
        KurentoMediaServerManager.checkIfKmsIsRemote(wsUri);
        if (isKmsRemote && kmsLogin == null && (kmsPem == null || kmsPasswd == null)) {
            String kmsAutoStart = PropertiesManager.getProperty((String)kmsAutostartProp, (String)kmsAutostartDefaultProp);
            throw new RuntimeException("Bad test parameters: " + kmsAutostartProp + "=" + kmsAutoStart + " and " + kmsWsUriProp + "=" + wsUri + ". Remote KMS should be started but its credentials are not present: " + kmsLoginProp + "=" + kmsLogin + ", " + kmsPasswdProp + "=" + kmsPasswd + ", " + kmsPemProp + "=" + kmsPem);
        }
        this.serverCommand = PropertiesManager.getProperty((String)"kms.command", (String)"/usr/bin/kurento-media-server");
        this.gstPlugins = PropertiesManager.getProperty((String)"kms.gst.plugins", (String)"");
        if (!docker) {
            try {
                lastWorkspace = this.workspace = Files.createTempDirectory("kurento-test", new FileAttribute[0]).toString();
            }
            catch (IOException e) {
                this.workspace = PropertiesManager.getProperty((String)"test.workspace", (String)"/tmp");
                log.error("Exception loading temporal folder; instead folder {} will be used", (Object)this.workspace, (Object)e);
            }
            if (!this.workspace.endsWith("/")) {
                this.workspace = this.workspace + "/";
            }
            log.debug("Local folder to store temporal files: {}", (Object)this.workspace);
        }
        this.debugOptions = PropertiesManager.getProperty((String)"kms.debug", (String)"2,*media_server*:5,*Kurento*:5,KurentoMediaServerServiceHandler:7");
        if (this.rabbitMqAddress != null) {
            log.info("Starting KMS with RabbitMQ: RabbitMQAddress:'{}' serverCommand:'{}' gstPlugins:'{}' workspace: '{}'", new Object[]{this.rabbitMqAddress, this.serverCommand, this.gstPlugins, this.workspace});
        } else {
            if (docker) {
                log.info("Starting KMS dockerized with serverCommand:'{}' gstPlugins:'{}' workspace: '{}'", new Object[]{this.serverCommand, this.gstPlugins, this.workspace});
            } else {
                log.info("Starting KMS with Ws uri: '{}' serverCommand:'{}' gstPlugins:'{}' workspace: '{}'", new Object[]{wsUri, this.serverCommand, this.gstPlugins, this.workspace});
            }
            if (!(docker || isKmsRemote || this.isFreePort(wsUri))) {
                throw new RuntimeException("KMS cannot be started in URI: " + wsUri + ". Port is not free");
            }
        }
        if (isKmsRemote) {
            String remoteKmsStr = wsUri.substring(wsUri.indexOf("//") + 2, wsUri.lastIndexOf(":"));
            log.info("Using remote KMS at {}", (Object)remoteKmsStr);
            remoteKms = new SshConnection(remoteKmsStr, kmsLogin, kmsPasswd, kmsPem);
            if (kmsPem != null) {
                remoteKms.setPem(kmsPem);
            }
            remoteKms.start();
            remoteKms.createTmpFolder();
        }
        if (!docker) {
            this.createKurentoConf();
        }
        if (isKmsRemote) {
            String[] filesToBeCopied;
            for (String s : filesToBeCopied = new String[]{"kurento.conf.json", "kurento.sh"}) {
                remoteKms.scp(this.workspace + s, remoteKms.getTmpFolder() + "/" + s);
            }
            remoteKms.runAndWaitCommand("chmod", "+x", remoteKms.getTmpFolder() + "/kurento.sh");
        }
        this.startKms(wsUri);
        this.waitForKurentoMediaServer(this.wsUri);
    }

    private static void checkIfKmsIsRemote(String wsUri) {
        isKmsRemote = !wsUri.contains("localhost") && !wsUri.contains("127.0.0.1") && !docker;
    }

    private void startKms(String wsUri) throws IOException {
        String kmsLogPath = this.getKmsLogPath();
        if (isKmsRemote) {
            remoteKms.runAndWaitCommand("sh", "-c", kmsLogPath + "kurento.sh > /dev/null");
            log.info("Kurento Media Server started in wsUri: " + wsUri);
        } else if (docker) {
            this.startDockerizedKms();
        } else {
            Shell.run("sh", "-c", kmsLogPath + "kurento.sh");
            log.info("Kurento Media Server started in wsUri: " + wsUri);
        }
        this.kmsAutostarted = true;
    }

    private void startDockerizedKms() {
        Docker dockerClient = Docker.getSingleton();
        String kmsImageName = PropertiesManager.getProperty((String)"test.kms.docker.image.name", (String)"kurento/kurento-media-server-dev:latest");
        boolean forcePulling = PropertiesManager.getProperty((String)"test.kms.docker.image.forcepulling", (boolean)true);
        if (!dockerClient.existsImage(kmsImageName) || forcePulling) {
            log.info("Pulling kms image {}", (Object)kmsImageName);
            ((PullImageResultCallback)dockerClient.getClient().pullImageCmd(kmsImageName).exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
            log.info("Kms image {} pulled", (Object)kmsImageName);
        }
        if (dockerClient.existsContainer(dockerContainerName)) {
            log.warn("Trying to create a new container named '" + dockerContainerName + "' but it already exist. Stopping and removing existing one and creating it again.");
            dockerClient.stopAndRemoveContainer(dockerContainerName);
        }
        log.debug("Starting kms container...");
        CreateContainerCmd createContainerCmd = dockerClient.getClient().createContainerCmd(kmsImageName).withName(dockerContainerName).withEnv(new String[]{"GST_DEBUG=" + this.debugOptions}).withCmd(new String[]{"--gst-debug-no-color"});
        if (dockerClient.isRunningInContainer()) {
            createContainerCmd.withVolumesFrom(new VolumesFrom[]{new VolumesFrom(dockerClient.getContainerId())});
        } else {
            String testFilesPath = KurentoServicesTestHelper.getTestFilesPath();
            Volume volume = new Volume(testFilesPath);
            String targetPath = Paths.get(KurentoTest.getDefaultOutputFolder().toURI()).toAbsolutePath().toString();
            Volume volumeTest = new Volume(targetPath);
            createContainerCmd.withVolumes(new Volume[]{volume, volumeTest}).withBinds(new Bind[]{new Bind(testFilesPath, volume, AccessMode.ro), new Bind(targetPath, volumeTest, AccessMode.rw)});
        }
        CreateContainerResponse kmsContainer = createContainerCmd.exec();
        dockerClient.getClient().startContainerCmd(kmsContainer.getId()).exec();
        this.wsUri = "ws://" + dockerClient.inspectContainer(dockerContainerName).getNetworkSettings().getIpAddress() + ":8888/kurento";
        System.setProperty("kms.ws.uri", this.wsUri);
        log.info("Kurento Media Server started in docker container wsUri: " + this.wsUri);
    }

    private boolean isFreePort(String wsUri) {
        try {
            URI wsUrl = new URI(wsUri);
            String result = Shell.runAndWait("/bin/bash", "-c", "nc -z " + wsUrl.getHost() + " " + wsUrl.getPort() + "; echo $?");
            if (result.trim().equals("0")) {
                log.warn("Port " + wsUrl.getPort() + " is used. Maybe another KMS instance is running in this port");
                return false;
            }
        }
        catch (URISyntaxException e) {
            log.warn("WebSocket URI {} is malformed: " + e.getMessage(), (Object)wsUri);
        }
        return true;
    }

    private void waitForKurentoMediaServer(String wsUri) {
        long initTime = System.nanoTime();
        if (wsUri != null) {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            int NUM_RETRIES = 300;
            int WAIT_MILLIS = 100;
            for (int i = 0; i < NUM_RETRIES; ++i) {
                try {
                    @ClientEndpoint
                    class WebSocketClient
                    extends Endpoint {
                        WebSocketClient() {
                        }

                        @OnClose
                        public void onClose(Session session, CloseReason closeReason) {
                        }

                        @OnOpen
                        public void onOpen(Session session, EndpointConfig config) {
                        }
                    }
                    Session wsSession = container.connectToServer((Endpoint)new WebSocketClient(), ClientEndpointConfig.Builder.create().build(), new URI(wsUri));
                    wsSession.close();
                    double time = (double)(System.nanoTime() - initTime) / 1000000.0;
                    log.debug("Connected to KMS in " + String.format("%3.2f", time) + " milliseconds");
                    return;
                }
                catch (IOException | URISyntaxException | DeploymentException e) {
                    try {
                        Thread.sleep(WAIT_MILLIS);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
            }
            throw new KurentoException("Timeout of " + NUM_RETRIES * WAIT_MILLIS + " millis waiting for KMS " + wsUri);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            log.error("InterruptedException {}", (Object)e.getMessage());
        }
    }

    private void createKurentoConf() {
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (this.rabbitMqAddress != null) {
            data.put("transport", "rabbitmq");
            data.put("rabbitAddress", this.rabbitMqAddress.getHost());
            data.put("rabbitPort", String.valueOf(this.rabbitMqAddress.getPort()));
        } else {
            try {
                URI wsAsUri = new URI(this.wsUri);
                int port = wsAsUri.getPort();
                String path = wsAsUri.getPath();
                data.put("transport", "ws");
                data.put("wsPort", String.valueOf(port));
                data.put("wsPath", path.substring(1));
                data.put("registrar", this.registrarUri);
                data.put("registrarLocalAddress", this.registrarLocalAddress);
            }
            catch (URISyntaxException e) {
                throw new KurentoException("Invalid ws uri: " + this.wsUri);
            }
        }
        data.put("gstPlugins", this.gstPlugins);
        data.put("debugOptions", this.debugOptions);
        data.put("serverCommand", this.serverCommand);
        data.put("workspace", this.getKmsLogPath());
        data.put("httpEndpointPort", String.valueOf(this.httpPort));
        cfg.setClassForTemplateLoading(KurentoMediaServerManager.class, "/templates/");
        this.createFileFromTemplate(cfg, data, "kurento.conf.json");
        this.createFileFromTemplate(cfg, data, "kurento.sh");
        Shell.runAndWait("chmod", "+x", this.workspace + "kurento.sh");
    }

    private void createFileFromTemplate(Configuration cfg, Map<String, Object> data, String filename) {
        try {
            Template template = cfg.getTemplate(filename + ".ftl");
            File file = new File(this.workspace + filename);
            FileWriter writer = new FileWriter(file);
            template.process(data, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            log.debug("Created file '" + file.getAbsolutePath() + "'");
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while creating file from template", e);
        }
    }

    public void destroy() throws IOException {
        if (docker) {
            Docker dockerClient = Docker.getSingleton();
            dockerClient.stopAndRemoveContainer(dockerContainerName);
        } else {
            this.killKmsProcesses();
            if (this.isRemote()) {
                remoteKms.stop();
            }
        }
    }

    public void retrieveLogs() throws IOException {
        File targetFolder = KurentoTest.getDefaultOutputFolder();
        String kmsLogsPath = this.getKmsLogPath();
        Path defaultOutput = Paths.get(targetFolder.toURI());
        if (!Files.exists(defaultOutput, new LinkOption[0])) {
            Files.createDirectories(defaultOutput, new FileAttribute[0]);
        }
        if (this.kmsAutostarted) {
            kmsLogsPath = kmsLogsPath + "logs/";
        }
        String testMethodName = KurentoTest.getSimpleTestName();
        if (docker) {
            Docker dockerClient = Docker.getSingleton();
            if (testMethodName != null) {
                dockerClient.downloadLog(dockerContainerName, Paths.get(targetFolder.getAbsolutePath(), testMethodName + "-kms.log"));
            } else {
                log.warn("KMS logs cannot be retrived because testMethodName is not set in KurentoMediaServerManager");
            }
        } else if (this.isRemote()) {
            if (!remoteKms.isStarted()) {
                remoteKms.start();
            }
            log.info("Copying KMS logs located on {} from remote host {} to {}", new Object[]{kmsLogsPath, remoteKms.getConnection(), targetFolder});
            List<String> remoteLogFiles = remoteKms.listFiles(kmsLogsPath, true, false);
            for (String remoteLogFile : remoteLogFiles) {
                String localLogFile = targetFolder + "/" + testMethodName + "-" + remoteLogFile.substring(remoteLogFile.lastIndexOf("/") + 1);
                remoteKms.getFile(localLogFile, remoteLogFile);
                KurentoTest.addLogFile(new File(localLogFile));
                log.debug("Log file: {}", (Object)localLogFile);
            }
        } else {
            log.info("Copying KMS logs from local path {} to {}", (Object)kmsLogsPath, (Object)targetFolder);
            Collection logFiles = FileUtils.listFiles((File)new File(kmsLogsPath), null, (boolean)false);
            for (File logFile : logFiles) {
                File destFile = new File(targetFolder, testMethodName + "-" + logFile.getName());
                try {
                    FileUtils.copyFile((File)logFile, (File)destFile);
                    KurentoTest.addLogFile(destFile);
                    log.debug("Log file: {}", (Object)destFile);
                }
                catch (Throwable e) {
                    log.warn("Exception copy KMS file {} {}", e.getClass(), (Object)e.getMessage());
                }
            }
        }
    }

    private void killKmsProcesses() throws IOException {
        int numKmsProcesses = 0;
        long timeout = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() <= timeout) {
            this.kmsSigTerm();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if ((numKmsProcesses = this.countKmsProcesses()) > 0) continue;
        }
        if (numKmsProcesses > 0) {
            this.kmsSigKill();
        }
    }

    private void kmsSigTerm() throws IOException {
        log.trace("Sending SIGTERM to KMS process");
        if (this.isRemote()) {
            String kmsPid = remoteKms.execAndWaitCommandNoBr("cat", remoteKms.getTmpFolder() + "/kms-pid");
            remoteKms.runAndWaitCommand("kill", kmsPid);
        } else {
            Shell.runAndWait("sh", "-c", "kill `cat " + this.workspace + "kms-pid`");
        }
    }

    private void kmsSigKill() throws IOException {
        log.trace("Sending SIGKILL to KMS process");
        if (this.isRemote()) {
            String kmsPid = remoteKms.execAndWaitCommandNoBr("cat", remoteKms.getTmpFolder() + "/kms-pid");
            remoteKms.runAndWaitCommand("sh", "-c", "kill -9 " + kmsPid);
        } else {
            Shell.runAndWait("sh", "-c", "kill -9 `cat " + this.workspace + "kms-pid`");
        }
    }

    public String getDebugOptions() {
        return this.debugOptions;
    }

    public void setDebugOptions(String debugOptions) {
        this.debugOptions = debugOptions;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int countKmsProcesses() {
        int result = 0;
        try {
            if (this.isRemote()) {
                String kmsPid = remoteKms.execAndWaitCommandNoBr("cat", remoteKms.getTmpFolder() + "/kms-pid");
                result = Integer.parseInt(remoteKms.execAndWaitCommandNoBr("ps --pid " + kmsPid + " --no-headers | wc -l"));
            } else {
                String[] command = new String[]{"sh", "-c", "ps --pid `cat " + this.workspace + "kms-pid` --no-headers | wc -l"};
                Process countKms = Runtime.getRuntime().exec(command);
                String stringFromStream = CharStreams.toString((Readable)new InputStreamReader(countKms.getInputStream(), "UTF-8"));
                result = Integer.parseInt(stringFromStream.trim());
            }
        }
        catch (IOException e) {
            log.error("Exception counting KMS processes", (Throwable)e);
        }
        return result;
    }

    public static String getWorkspace() {
        return lastWorkspace;
    }

    public String getWsUri() {
        return this.wsUri;
    }

    public void setRegistrarUri(String registrarUri) {
        this.registrarUri = registrarUri;
    }

    public void setRegistrarLocalAddress(String registrarLocalAddress) {
        this.registrarLocalAddress = registrarLocalAddress;
    }

    public String getRegistrarLocalAddress() {
        return this.registrarLocalAddress;
    }

    public String getRegistrarUri() {
        return this.registrarUri;
    }

    public void restart() throws IOException {
        this.kmsSigKill();
        this.startKms(this.wsUri);
        this.waitForKurentoMediaServer(this.wsUri);
    }

    public void setDocker(boolean dock) {
        docker = dock;
    }

    public void setDockerContainerName(String containerName) {
        dockerContainerName = containerName;
    }

    public static String getDockerContainerName() {
        return dockerContainerName;
    }

    static {
        remoteKms = null;
        dockerContainerName = "kms";
    }
}

