/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import java.io.IOException;
import org.kurento.commons.Address;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.config.TestConfiguration;
import org.kurento.test.docker.Docker;
import org.kurento.test.services.KurentoMediaServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;

public class KurentoServicesTestHelper {
    public static Logger log = LoggerFactory.getLogger(KurentoServicesTestHelper.class);
    private static KurentoMediaServerManager kms;
    private static KurentoMediaServerManager fakeKms;
    private static String kmsAutostart;
    private static String fakeKmsAutostart;
    private static ConfigurableApplicationContext appContext;

    public static void startKurentoServicesIfNeccessary() throws IOException {
        KurentoServicesTestHelper.startKurentoMediaServerIfNecessary();
    }

    private static void startKurentoMediaServerIfNecessary() throws IOException {
        kmsAutostart = PropertiesManager.getProperty((String)"test.kms.autostart", (String)"test");
        fakeKmsAutostart = PropertiesManager.getProperty((String)"fake.kms.autostart", (String)"false");
        KurentoServicesTestHelper.startKms(kmsAutostart, false);
        KurentoServicesTestHelper.startKms(fakeKmsAutostart, true);
    }

    private static void startKms(String kmsAutostart, boolean isFake) throws IOException {
        KurentoMediaServerManager kmsToBeStarted = isFake ? fakeKms : kms;
        switch (kmsAutostart) {
            case "false": {
                if (kms != null) break;
                kms = KurentoServicesTestHelper.alreadyStartedKurentoMediaServer();
                break;
            }
            case "test": {
                KurentoServicesTestHelper.startKurentoMediaServer(isFake);
                break;
            }
            case "testsuite": {
                if (kmsToBeStarted != null) break;
                KurentoServicesTestHelper.startKurentoMediaServer(isFake);
                break;
            }
            default: {
                throw new IllegalArgumentException("The value '" + kmsAutostart + "' is not valid for property " + (isFake ? "fake.kms.autostart" : "test.kms.autostart"));
            }
        }
    }

    public static KurentoMediaServerManager alreadyStartedKurentoMediaServer() throws IOException {
        return KurentoMediaServerManager.kmsAlreadyStarted(KurentoServicesTestHelper.getWsUri());
    }

    public static KurentoMediaServerManager startKurentoMediaServer(boolean isFake) throws IOException {
        Docker dockerClient;
        KurentoMediaServerManager kmsToBeStarted = isFake ? fakeKms : kms;
        String transport = PropertiesManager.getProperty((String)"kms.transport", (String)"ws");
        int httpPort = KurentoServicesTestHelper.getKmsHttpPort();
        switch (transport) {
            case "ws": {
                kmsToBeStarted = KurentoMediaServerManager.createWithWsTransport(KurentoServicesTestHelper.getWsUri(), httpPort);
                break;
            }
            case "rabbitmq": {
                kmsToBeStarted = KurentoMediaServerManager.createWithRabbitMqTransport(KurentoServicesTestHelper.getRabbitMqAddress(), httpPort);
                break;
            }
            default: {
                throw new IllegalArgumentException("The value " + transport + " is not valid for property " + "kms.transport");
            }
        }
        boolean docker = "docker".equals(PropertiesManager.getProperty((String)"test.kms.scope", (String)"local"));
        kmsToBeStarted.setDocker(docker);
        if (docker && (dockerClient = Docker.getSingleton()).isRunningInContainer()) {
            kmsToBeStarted.setDockerContainerName(dockerClient.getContainerName() + "_kms");
        }
        kmsToBeStarted.start(isFake);
        if (isFake) {
            fakeKms = kmsToBeStarted;
        } else {
            kms = kmsToBeStarted;
        }
        return kmsToBeStarted;
    }

    public static ConfigurableApplicationContext startHttpServer(Object ... sources) {
        System.setProperty("java.security.egd", "file:/dev/./urandom");
        appContext = new SpringApplication(sources).run(new String[]{"--server.port=" + KurentoServicesTestHelper.getAppHttpPort()});
        return appContext;
    }

    public static void teardownServices() throws IOException {
        KurentoServicesTestHelper.teardownHttpServer();
        KurentoServicesTestHelper.teardownKurentoMediaServer();
    }

    public static void teardownHttpServer() {
        if (appContext != null) {
            appContext.stop();
            appContext.close();
        }
    }

    public static void teardownKurentoMediaServer() throws IOException {
        log.debug("Teardown KMS: kms={} kmsAutostart={}", (Object)kms, (Object)kmsAutostart);
        if (kms != null) {
            kms.retrieveLogs();
            if (kmsAutostart.equals("test")) {
                kms.destroy();
                kms = null;
            }
        }
        if (fakeKms != null && fakeKmsAutostart.equals("test")) {
            fakeKms.destroy();
            fakeKms = null;
        }
    }

    public static int getKmsHttpPort() {
        return PropertiesManager.getProperty((String)"kms.http.port", (int)9091);
    }

    public static int getAppHttpPort() {
        return PropertiesManager.getProperty((String)"server.port", (int)7779);
    }

    public static String getBowerKurentoClientTag() {
        return PropertiesManager.getProperty((String)"bower.kurentoclient.tag", (String)"");
    }

    public static String getBowerKurentoUtilsTag() {
        return PropertiesManager.getProperty((String)"bower.kurentoutils.tag", (String)"");
    }

    public static String getTestFilesPath() {
        return PropertiesManager.getProperty((String)"test.files", (String)"/var/lib/jenkins/test-files");
    }

    public static Address getRabbitMqAddress() {
        return KurentoServicesTestHelper.getRabbitMqAddress(null);
    }

    public static Address getRabbitMqAddress(String prefix) {
        return PropertiesManager.getProperty((String)prefix, (String)"kms.rabbitmq.address", (Address)TestConfiguration.KMS_RABBITMQ_ADDRESS_DEFAULT);
    }

    public static String getWsUri() {
        return KurentoServicesTestHelper.getWsUri(null);
    }

    public static String getWsUri(String prefix) {
        return PropertiesManager.getProperty((String)prefix, (String)"kms.ws.uri", (String)"ws://localhost:8888/kurento");
    }

    static {
        kmsAutostart = "test";
        fakeKmsAutostart = "test";
    }
}

