/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.services.FailedTest;
import org.kurento.test.services.FinishedTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KurentoTestWatcher
extends TestWatcher {
    public static Logger log = LoggerFactory.getLogger(KurentoTestWatcher.class);
    private static boolean succees = false;

    protected void starting(Description description) {
        String methodName = description.getMethodName();
        this.logMessage("|       TEST STARTING: " + description.getClassName() + "." + methodName);
        KurentoTest.setTestMethodName(methodName);
    }

    protected void succeeded(Description description) {
        this.logMessage("|       TEST SUCCEEDED: " + description.getClassName() + "." + description.getMethodName());
        super.succeeded(description);
        succees = true;
    }

    protected void failed(Throwable e, Description description) {
        this.logMessage("|       TEST FAILED: " + description.getClassName() + "." + description.getMethodName());
        this.invokeMethodsAnnotatedWith(FailedTest.class, description.getTestClass(), e, description);
    }

    protected void finished(Description description) {
        super.finished(description);
        this.invokeMethodsAnnotatedWith(FinishedTest.class, description.getTestClass(), null, description);
    }

    private void invokeMethodsAnnotatedWith(Class<? extends Annotation> annotation, Class<?> testClass, Throwable throwable, Description description) {
        List<Method> methods = this.getMethodsAnnotatedWith(testClass, annotation);
        this.invokeMethods(methods, annotation, throwable, description);
    }

    public static boolean isSuccees() {
        return succees;
    }

    public void invokeMethods(List<Method> methods, Class<? extends Annotation> annotation, Throwable throwable, Description description) {
        for (Method method : methods) {
            log.debug("Invoking method {} annotated with {}", (Object)method, annotation);
            try {
                if (!Modifier.isPublic(method.getModifiers())) {
                    log.warn("Method {} is not public and it cannot be invoked", (Object)method);
                    continue;
                }
                if (!Modifier.isStatic(method.getModifiers())) {
                    log.warn("Method {} is not static and it cannot be invoked", (Object)method);
                    continue;
                }
                Object[] parameterTypes = method.getParameterTypes();
                switch (parameterTypes.length) {
                    case 0: {
                        method.invoke(null, new Object[0]);
                        break;
                    }
                    case 1: {
                        if (parameterTypes[0].equals(Throwable.class)) {
                            method.invoke(null, throwable);
                            break;
                        }
                        if (parameterTypes[0].equals(Description.class)) {
                            method.invoke(null, description);
                            break;
                        }
                        log.warn("Method {} annotated with {} cannot be invoked. Incorrect argument: {}", new Object[]{method, annotation, parameterTypes[0]});
                        break;
                    }
                    case 2: {
                        Throwable param2;
                        Throwable param1;
                        Throwable throwable2 = parameterTypes[0].equals(Throwable.class) ? throwable : (param1 = parameterTypes[0].equals(Description.class) ? description : null);
                        Throwable throwable3 = parameterTypes[1].equals(Throwable.class) ? throwable : (param2 = parameterTypes[1].equals(Description.class) ? description : null);
                        if (param1 != null && param2 != null) {
                            method.invoke(null, param1, param2);
                            break;
                        }
                        log.warn("Method {} annotated with {} cannot be invoked. Incorrect arguments: {}, {}", new Object[]{method, annotation, parameterTypes[0], parameterTypes[1]});
                        break;
                    }
                    default: {
                        log.warn("Method {} annotated with {} cannot be invoked. Incorrect arguments: {}", new Object[]{method, annotation, Arrays.toString(parameterTypes)});
                        break;
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                log.warn("Exception invoking method {} annotated with {}: {} {}", new Object[]{method, e.getClass(), e.getMessage()});
            }
        }
    }

    public List<Method> getMethodsAnnotatedWith(Class<?> clazz, Class<? extends Annotation> annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        while (clazz != Object.class) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotation)) continue;
                methods.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return methods;
    }

    private void logMessage(String message) {
        log.info("+----------------------------------------------------------");
        log.info(message);
        log.info("+----------------------------------------------------------");
    }
}

