/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.kurento.test.grid.GridNode;
import org.kurento.test.services.AudioChannel;
import org.kurento.test.services.KurentoMediaServerManager;
import org.kurento.test.services.KurentoServicesTestHelper;
import org.kurento.test.services.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recorder {
    private static Logger log = LoggerFactory.getLogger(Recorder.class);
    private static final String HTTP_TEST_FILES = "http://files.kurento.org";
    private static final String PESQ_RESULTS = "pesq_results.txt";
    private static final String RECORDED_WAV = KurentoMediaServerManager.getWorkspace() + "recorded.wav";

    public static void recordRemote(GridNode node, int seconds, int sampleRate, AudioChannel audioChannel) {
        try {
            node.getSshConnection().execCommand("ffmpeg", "-y", "-t", String.valueOf(seconds), "-f", "alsa", "-i", "pulse", "-q:a", "0", "-ac", audioChannel.toString(), "-ar", String.valueOf(sampleRate), RECORDED_WAV);
        }
        catch (IOException e) {
            log.error("IOException recording audio in remote node " + node.getHost());
        }
    }

    public static void record(int seconds, int sampleRate, AudioChannel audioChannel) {
        Shell.run("sh", "-c", "ffmpeg -y -t " + seconds + " -f alsa -i pulse -q:a 0 -ac " + (Object)((Object)audioChannel) + " -ar " + sampleRate + " " + RECORDED_WAV);
    }

    public static float getRemotePesqMos(GridNode node, String audio, int sampleRate) {
        node.getSshConnection().getFile(RECORDED_WAV, RECORDED_WAV);
        return Recorder.getPesqMos(audio, sampleRate);
    }

    public static float getPesqMos(String audio, int sampleRate) {
        float pesqmos = 0.0f;
        try {
            String pesq = KurentoServicesTestHelper.getTestFilesPath() + "/bin/pesq/PESQ";
            String origWav = "";
            if (audio.startsWith(HTTP_TEST_FILES)) {
                origWav = KurentoServicesTestHelper.getTestFilesPath() + audio.replace(HTTP_TEST_FILES, "");
            } else {
                origWav = KurentoMediaServerManager.getWorkspace() + "/downloaded.wav";
                URL url = new URL(audio);
                ReadableByteChannel rbc = Channels.newChannel(url.openStream());
                FileOutputStream fos = new FileOutputStream(origWav);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                fos.close();
            }
            Shell.runAndWait(pesq, "+" + sampleRate, origWav, RECORDED_WAV);
            List lines = FileUtils.readLines((File)new File(PESQ_RESULTS), (String)"utf-8");
            pesqmos = Float.parseFloat(((String)lines.get(1)).split("\t")[2].trim());
            log.info("PESQMOS " + pesqmos);
            Shell.runAndWait("rm", PESQ_RESULTS);
        }
        catch (IOException e) {
            log.error("Exception recording local audio", (Throwable)e);
        }
        return pesqmos;
    }
}

