/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import com.google.common.io.CharStreams;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.ssh.SshConnectionType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.kurento.commons.PropertiesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnection {
    public static Logger log = LoggerFactory.getLogger(SshConnection.class);
    public static final String DEFAULT_TMP_FOLDER = "/tmp";
    private static final int NODE_INITIAL_PORT = 5555;
    private static final int PING_TIMEOUT = 2;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private String host;
    private String login;
    private String passwd;
    private String pem;
    private String tmpFolder;
    private int connectionTimeout;
    private OverthereConnection connection;

    public SshConnection(String host) {
        this.host = host;
        this.login = PropertiesManager.getProperty((String)"test.node.login");
        String pem = PropertiesManager.getProperty((String)"test.node.pem");
        if (pem != null) {
            this.pem = pem;
        } else {
            this.passwd = PropertiesManager.getProperty((String)"test.node.passwd");
        }
        this.connectionTimeout = 30000;
    }

    public SshConnection(String host, String login, String passwd, String pem) {
        this.host = host;
        this.login = login;
        if (pem != null) {
            this.pem = pem;
        } else {
            this.passwd = passwd;
        }
    }

    public List<String> listFiles(String folder, boolean recursive, boolean includeFolders) throws IOException {
        String[] command = null;
        if (recursive && includeFolders) {
            command = new String[]{"find", folder};
        } else if (recursive && !includeFolders) {
            command = new String[]{"find", folder, "-type", "f"};
        } else if (!recursive && includeFolders) {
            command = new String[]{"find", folder, "-maxdepth", "1"};
        } else if (!recursive && !includeFolders) {
            command = new String[]{"find", folder, "-maxdepth", "1", "-type", "f"};
        }
        return Arrays.asList(this.execAndWaitCommand(command).split("\r\n"));
    }

    public void mkdirs(String dir) throws IOException {
        this.execAndWaitCommand("mkdir", "-p", dir);
    }

    public String createTmpFolder() {
        try {
            do {
                this.tmpFolder = "/tmp/" + System.nanoTime();
            } while (this.exists(this.tmpFolder));
            this.execAndWaitCommand("mkdir", this.tmpFolder);
        }
        catch (IOException e) {
            this.tmpFolder = DEFAULT_TMP_FOLDER;
        }
        log.debug("Remote folder to store temporal files in node {}: {} ", (Object)this.host, (Object)this.tmpFolder);
        return this.tmpFolder;
    }

    public void getFile(String targetFile, String origFile) {
        log.debug("Getting remote file: {} (in host {}) to local file: {}", new Object[]{origFile, this.host, targetFile});
        OverthereFile motd = this.connection.getFile(origFile);
        if (!motd.isDirectory()) {
            InputStream is = motd.getInputStream();
            try {
                Files.copy(is, Paths.get(targetFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                is.close();
            }
            catch (IOException e) {
                log.error("Exception getting file: {} to {} ({})", new Object[]{origFile, targetFile, e.getMessage()});
            }
        }
    }

    public void scp(String origFile, String targetFile) throws IOException {
        log.debug("Copying local file: {} to remote file: {} (in host {})", new Object[]{origFile, targetFile, this.host});
        OverthereFile motd = this.connection.getFile(targetFile);
        OutputStream w = motd.getOutputStream();
        byte[] origBytes = Files.readAllBytes(Paths.get(origFile, new String[0]));
        w.write(origBytes);
        w.close();
    }

    public void start() {
        ConnectionOptions options = new ConnectionOptions();
        if (this.pem != null) {
            options.set("privateKeyFile", (Object)this.pem);
        } else {
            options.set("password", (Object)this.passwd);
        }
        options.set("connectionTimeoutMillis", (Object)this.connectionTimeout);
        options.set("username", (Object)this.login);
        options.set("address", (Object)this.host);
        options.set("os", (Object)OperatingSystemFamily.UNIX);
        options.set("connectionType", (Object)SshConnectionType.SCP);
        this.connection = Overthere.getConnection((String)"ssh", (ConnectionOptions)options);
    }

    public boolean isStarted() {
        return this.connection != null;
    }

    public void stop() {
        if (this.isStarted()) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void execCommand(String ... command) throws IOException {
        if (this.connection.canStartProcess()) {
            this.connection.startProcess(CmdLine.build((String[])command));
        }
    }

    public int runAndWaitCommand(String ... command) throws IOException {
        return this.connection.execute(CmdLine.build((String[])command));
    }

    public String execAndWaitCommand(String ... command) throws IOException {
        log.info("execAndWaitCommand: {} ", (Object)Arrays.toString(command));
        CmdLine cmdLine = new CmdLine();
        for (String c : command) {
            cmdLine.addRaw(c);
        }
        OverthereProcess process = this.connection.startProcess(cmdLine);
        BufferedReader r = new BufferedReader(new InputStreamReader(process.getStdout(), "UTF-8"));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = r.readLine()) != null) {
            log.debug(line);
            sb.append(line).append("\r\n");
        }
        return sb.toString();
    }

    public String execAndWaitCommandWithStderr(String ... command) throws IOException {
        OverthereProcess process = this.connection.startProcess(CmdLine.build((String[])command));
        String result = CharStreams.toString((Readable)new InputStreamReader(process.getStdout(), "UTF-8"));
        result = result + CharStreams.toString((Readable)new InputStreamReader(process.getStderr(), "UTF-8"));
        return result;
    }

    public String execAndWaitCommandNoBr(String ... command) throws IOException {
        return this.execAndWaitCommand(command).replace("\n", "").replace("\r", "");
    }

    public boolean exists(String fileOrFolder) throws IOException {
        String output = this.execAndWaitCommand("file", fileOrFolder);
        return !output.contains("ERROR");
    }

    public int getFreePort() throws IOException {
        String output;
        int port = 5554;
        while ((output = this.execAndWaitCommand("netstat", "-auxn")).contains(":" + ++port)) {
        }
        return port;
    }

    public static boolean ping(String ipAddress) {
        return SshConnection.ping(ipAddress, 2);
    }

    public static boolean ping(final String ipAddress, int timeout) {
        final CountDownLatch latch = new CountDownLatch(1);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    String[] command = new String[]{"ping", "-c", "1", ipAddress};
                    Process p = new ProcessBuilder(command).redirectErrorStream(true).start();
                    CharStreams.toString((Readable)new InputStreamReader(p.getInputStream(), "UTF-8"));
                    latch.countDown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
        boolean ping = false;
        try {
            ping = latch.await(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Exception making ping to {} : {}", (Object)ipAddress, e.getClass());
        }
        if (!ping) {
            t.interrupt();
        }
        return ping;
    }

    public String getTmpFolder() {
        return this.tmpFolder;
    }

    public String getHost() {
        return this.host;
    }

    public String getPem() {
        return this.pem;
    }

    public void setPem(String pem) {
        this.pem = pem;
    }

    public OverthereConnection getConnection() {
        return this.connection;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

