/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.browser;

import com.google.common.base.Function;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.kurento.test.browser.Browser;
import org.kurento.test.latency.LatencyException;
import org.kurento.test.latency.VideoTag;
import org.kurento.test.monitor.PeerConnectionStats;
import org.kurento.test.monitor.SystemMonitorManager;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPage {
    public static Logger log = LoggerFactory.getLogger(WebPage.class);
    public Browser browser;

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public void takeScreeshot(String file) throws IOException {
        File scrFile = (File)((TakesScreenshot)this.getBrowser().getWebDriver()).getScreenshotAs(OutputType.FILE);
        FileUtils.copyFile((File)scrFile, (File)new File(file));
    }

    public void setThresholdTime(int thresholdTime) {
        this.browser.setThresholdTime(thresholdTime);
    }

    public void setColorCoordinates(int x, int y) {
        this.browser.executeScript("kurentoTest.setColorCoordinates(" + x + "," + y + ");");
    }

    public void checkColor(String ... videoTags) {
        String tags = "";
        for (String s : videoTags) {
            if (!tags.isEmpty()) {
                tags = tags + ",";
            }
            tags = tags + "'" + s + "'";
        }
        this.browser.executeScript("kurentoTest.checkColor(" + tags + ");");
    }

    public boolean similarColorAt(String videoTag, Color expectedColor, int x, int y) {
        this.setColorCoordinates(x, y);
        return this.similarColor(videoTag, expectedColor);
    }

    public boolean similarColor(String videoTag, Color expectedColor) {
        boolean out;
        long endTimeMillis = System.currentTimeMillis() + (long)(this.browser.getTimeout() * 1000);
        boolean logWarn = true;
        while (!(out = this.compareColor(videoTag, expectedColor, logWarn)) && System.currentTimeMillis() <= endTimeMillis) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                log.trace("InterruptedException in guard condition ({})", (Object)e.getMessage());
            }
            logWarn = false;
        }
        return out;
    }

    public boolean compareColor(String videoTag, Color expectedColor, boolean logWarn) {
        boolean out;
        List realColor = (List)this.browser.executeScriptAndWaitOutput("return kurentoTest.colorInfo['" + videoTag + "'].currentColor;");
        long red = (Long)realColor.get(0);
        long green = (Long)realColor.get(1);
        long blue = (Long)realColor.get(2);
        double distance = Math.sqrt((red - (long)expectedColor.getRed()) * (red - (long)expectedColor.getRed()) + (green - (long)expectedColor.getGreen()) * (green - (long)expectedColor.getGreen()) + (blue - (long)expectedColor.getBlue()) * (blue - (long)expectedColor.getBlue()));
        String expectedColorStr = "[R=" + expectedColor.getRed() + ", G=" + expectedColor.getGreen() + ", B=" + expectedColor.getBlue() + "]";
        String realColorStr = "[R=" + red + ", G=" + green + ", B=" + blue + "]";
        boolean bl = out = distance <= this.browser.getColorDistance();
        if (!out) {
            if (logWarn) {
                log.warn("Color NOT detected in video stream. Expected: {}, Real: {}", (Object)expectedColorStr, (Object)realColorStr);
            }
        } else {
            log.debug("Detected color in video stream. Expected: {}, Real: {}", (Object)expectedColorStr, (Object)realColorStr);
        }
        return out;
    }

    public void activatePeerConnectionInboundStats(String peerConnectionId) {
        this.activatePeerConnectionStats("activateInboundRtcStats", peerConnectionId);
    }

    public void activatePeerConnectionOutboundStats(String peerConnectionId) {
        this.activatePeerConnectionStats("activateOutboundRtcStats", peerConnectionId);
    }

    private void activatePeerConnectionStats(String jsFunction, String peerConnectionId) {
        try {
            this.browser.executeScript("kurentoTest." + jsFunction + "('" + peerConnectionId + "');");
        }
        catch (WebDriverException we) {
            we.printStackTrace();
            log.warn("Client does not support RTC statistics (function kurentoTest.{}() not defined)", (Object)"activateLocalRtcStats");
        }
    }

    public long getLatency() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final long[] out = new long[1];
        Thread t = new Thread(){

            @Override
            public void run() {
                Object latency = WebPage.this.browser.executeScript("return kurentoTest.getLatency();");
                out[0] = latency != null ? (Long)latency : Long.MIN_VALUE;
                latch.countDown();
            }
        };
        t.start();
        if (!latch.await(this.browser.getTimeout(), TimeUnit.SECONDS)) {
            t.interrupt();
            t.stop();
            throw new LatencyException("Timeout getting latency (" + this.browser.getTimeout() + "  seconds)");
        }
        return out[0];
    }

    public void waitColor(long timeoutSeconds, final VideoTag videoTag, final Color color) {
        WebDriverWait wait = new WebDriverWait(this.browser.getWebDriver(), timeoutSeconds);
        wait.until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver d) {
                return !((JavascriptExecutor)d).executeScript(videoTag.getColor(), new Object[0]).equals(color);
            }
        });
    }

    public long getCurrentTime(VideoTag videoTag) {
        Object time = this.browser.executeScript(videoTag.getTime());
        return time == null ? 0L : (Long)time;
    }

    public Color getCurrentColor(VideoTag videoTag) {
        return this.getColor((List)this.browser.executeScript(videoTag.getColor()));
    }

    private Color getColor(List<Long> color) {
        return new Color(color.get(0).intValue(), color.get(1).intValue(), color.get(2).intValue());
    }

    public void checkLatencyUntil(SystemMonitorManager monitor, long endTimeMillis) throws InterruptedException, IOException {
        while (System.currentTimeMillis() <= endTimeMillis) {
            Thread.sleep(100L);
            try {
                long latency = this.getLatency();
                if (latency == Long.MIN_VALUE) continue;
                monitor.addCurrentLatency(latency);
            }
            catch (LatencyException le) {
                monitor.incrementLatencyErrors();
            }
        }
    }

    public PeerConnectionStats getRtcStats() {
        Map<String, Object> out = new HashMap<String, Object>();
        try {
            if (this.browser != null && this.browser.getWebDriver() != null) {
                out = (Map)this.browser.executeScript("return kurentoTest.rtcStats;");
                log.debug(">>>>>>>>>> kurentoTest.rtcStats {} {}", (Object)this.browser.getId(), out);
            }
        }
        catch (WebDriverException we) {
            log.warn("Client does not support RTC statistics (variable rtcStats is not defined)");
        }
        return new PeerConnectionStats(out);
    }

    public void activateLatencyControl(String localId, String remoteId) {
        this.browser.executeScript("kurentoTest.activateLatencyControl('" + localId + "', '" + remoteId + "');");
    }

    public int getTimeout() {
        return this.browser.getTimeout();
    }

    public void setTimeout(int timeoutSeconds) {
        this.browser.changeTimeout(timeoutSeconds);
    }

    public int getThresholdTime() {
        return this.browser.getThresholdTime();
    }
}

