/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.grid;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import com.google.gson.JsonElement;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.Assert;
import org.kurento.commons.PropertiesManager;
import org.kurento.test.base.PerformanceTest;
import org.kurento.test.browser.BrowserType;
import org.kurento.test.grid.GridHub;
import org.kurento.test.grid.GridNode;
import org.kurento.test.utils.Randomizer;
import org.kurento.test.utils.Shell;
import org.kurento.test.utils.SshConnection;
import org.openqa.grid.selenium.GridLauncher;
import org.openqa.jetty.http.HttpListener;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridHandler {
    public static Logger log = LoggerFactory.getLogger(GridHandler.class);
    public static final String REMOTE_FOLDER = ".kurento-test";
    public static final String REMOTE_PID_FILE = "node-pid";
    public static final String IPS_REGEX = "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
    private static final int TIMEOUT_NODE = 300;
    private static final String LAUNCH_SH = "launch-node.sh";
    private static GridHandler instance = null;
    private GridHub hub;
    private String hubAddress = PropertiesManager.getProperty((String)"selenium.hub.address", (String)"127.0.0.1");
    private int hubPort = PropertiesManager.getProperty((String)"selenium.hub.port", (int)4444);
    private CountDownLatch countDownLatch;
    private Map<String, GridNode> nodes = new ConcurrentHashMap<String, GridNode>();
    private List<String> nodeList;
    private boolean hubStarted = false;
    private boolean nodeListFiltered = false;

    protected GridHandler() {
        String nodesListProp = System.getProperty("test.nodes.list");
        String nodesListFileProp = System.getProperty("test.nodes.file.list");
        String nodesListUrlProp = System.getProperty("test.nodes.url.list");
        if (nodesListUrlProp != null) {
            if (this.nodeList == null) {
                this.nodeList = new ArrayList<String>();
                try {
                    log.trace("Reading node list from URL {}", (Object)nodesListUrlProp);
                    String contents = GridHandler.readContents(nodesListUrlProp);
                    Pattern p = Pattern.compile(IPS_REGEX);
                    Matcher m = p.matcher(contents);
                    while (m.find()) {
                        this.nodeList.add(m.group());
                    }
                }
                catch (IOException e) {
                    Assert.fail((String)("Exception reading URL " + nodesListUrlProp + " : " + e.getMessage()));
                }
            }
        } else if (nodesListFileProp != null) {
            log.trace("Reading node list from file {}", (Object)nodesListFileProp);
            try {
                this.nodeList = FileUtils.readLines((File)new File(nodesListFileProp), (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                Assert.fail((String)("Exception reading node list file: " + e.getMessage()));
            }
        } else if (nodesListProp != null) {
            log.trace("Reading node list from property {}", (Object)nodesListProp);
            this.nodeList = new ArrayList<String>(Arrays.asList(nodesListProp.split(";")));
        } else {
            log.trace("Using default node list {}", (Object)"node-list.txt");
            InputStream inputStream = PerformanceTest.class.getClassLoader().getResourceAsStream("node-list.txt");
            try {
                this.nodeList = CharStreams.readLines((Readable)new InputStreamReader(inputStream, Charsets.UTF_8));
            }
            catch (IOException e) {
                Assert.fail((String)("Exception reading node-list.txt: " + e.getMessage()));
            }
        }
    }

    public static synchronized GridHandler getInstance() {
        if (instance == null) {
            instance = new GridHandler();
        }
        return instance;
    }

    public synchronized void stopGrid() {
        log.info("Stopping Selenium Grid");
        try {
            if (this.hub != null) {
                log.info("Stopping Hub");
                this.hub.stop();
                this.hubStarted = false;
            }
            if (this.nodes != null) {
                log.info("Number of nodes: {}", (Object)this.nodes.size());
                for (GridNode node : this.nodes.values()) {
                    log.info("Stopping Node {}", (Object)node.getHost());
                    this.stopNode(node);
                }
            }
            this.nodes.clear();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void startHub() {
        try {
            if (this.hubAddress != null && !this.hubStarted) {
                this.hub = new GridHub(this.hubPort);
                this.hub.start();
                this.hubStarted = true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void startNodes() {
        try {
            this.countDownLatch = new CountDownLatch(this.nodes.size());
            ExecutorService exec = Executors.newFixedThreadPool(this.nodes.size());
            for (final GridNode n : this.nodes.values()) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        GridHandler.this.startNode(n);
                    }
                };
                exec.execute(t);
            }
            if (!this.countDownLatch.await(300L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout waiting nodes (300 seconds)");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void startNode(GridNode node) {
        try {
            this.countDownLatch = new CountDownLatch(1);
            log.info("Launching node {}", (Object)node.getHost());
            node.startSsh();
            String chromeDriverSource = System.getProperty("webdriver.chrome.driver");
            Class[] classpath = new Class[]{GridLauncher.class, ImmutableList.class, HttpListener.class, NetworkUtils.class, WebDriverException.class, LogFactory.class, HttpServlet.class, ChromeDriver.class, FirefoxDriver.class, JsonElement.class, HttpEntity.class, HttpClient.class, WebDriverEventListener.class, ExecuteWatchdog.class};
            String remoteHome = node.getHome();
            String remoteFolder = remoteHome + "/" + REMOTE_FOLDER;
            String remoteChromeDriver = remoteFolder + "/chromedriver";
            String remoteScript = node.getTmpFolder() + "/" + LAUNCH_SH;
            String remotePort = String.valueOf(node.getSshConnection().getFreePort());
            if (!node.getSshConnection().exists(remoteFolder) || node.isOverwrite()) {
                node.getSshConnection().execAndWaitCommand("mkdir", "-p", remoteFolder);
            }
            if (!node.getSshConnection().exists(remoteChromeDriver) || node.isOverwrite()) {
                node.getSshConnection().scp(chromeDriverSource, remoteChromeDriver);
                node.getSshConnection().execAndWaitCommand("chmod", "+x", remoteChromeDriver);
            }
            String cp = "";
            for (Class clazz : classpath) {
                if (!cp.isEmpty()) {
                    cp = cp + ":";
                }
                String jarSource = this.getJarPath(clazz).getAbsolutePath();
                String remoteSeleniumJar = remoteFolder + "/" + this.getJarPath(clazz).getName();
                cp = cp + remoteSeleniumJar;
                if (node.getSshConnection().exists(remoteSeleniumJar) && !node.isOverwrite()) continue;
                node.getSshConnection().scp(jarSource, remoteSeleniumJar);
            }
            this.createRemoteScript(node, remotePort, remoteScript, remoteFolder, remoteChromeDriver, cp, node.getBrowserType(), node.getMaxInstances());
            node.getSshConnection().execCommand(remoteScript);
            this.waitForNode(node.getHost(), remotePort);
            node.setStarted(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private File getJarPath(Class<?> aclass) {
        URL url;
        try {
            url = aclass.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (SecurityException ex) {
            url = aclass.getResource(aclass.getSimpleName() + ".class");
        }
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            return new File(url.getPath());
        }
    }

    private void createRemoteScript(GridNode node, String remotePort, String remoteScript, String remoteFolder, String remoteChromeDriver, String classpath, BrowserType browser, int maxInstances) throws IOException {
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("remotePort", String.valueOf(remotePort));
        data.put("maxInstances", String.valueOf(maxInstances));
        data.put("hubIp", this.hubAddress);
        data.put("hubPort", String.valueOf(this.hubPort));
        data.put("tmpFolder", node.getTmpFolder());
        data.put("remoteChromeDriver", remoteChromeDriver);
        data.put("classpath", classpath);
        data.put("pidFile", REMOTE_PID_FILE);
        data.put("browser", (Object)browser);
        cfg.setClassForTemplateLoading(PerformanceTest.class, "/templates/");
        String tmpScript = node.getTmpFolder() + LAUNCH_SH;
        try {
            Template template = cfg.getTemplate("launch-node.sh.ftl");
            FileWriter writer = new FileWriter(new File(tmpScript));
            template.process(data, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while creating file from template", e);
        }
        node.getSshConnection().scp(tmpScript, remoteScript);
        node.getSshConnection().execAndWaitCommand("chmod", "+x", remoteScript);
        Shell.runAndWait("rm", tmpScript);
    }

    public void copyRemoteVideo(GridNode node, String video) {
        try {
            if (!node.getSshConnection().exists(node.getRemoteVideo(video)) || node.isOverwrite()) {
                node.getSshConnection().scp(video, node.getRemoteVideo(video));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void waitForNode(String node, String port) {
        log.info("Waiting for node {} to be ready...", (Object)node);
        int responseStatusCode = 0;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet("http://" + node + ":" + port + "/wd/hub/static/resource/hub.html");
        long maxSystemTime = System.currentTimeMillis() + 300000L;
        do {
            try {
                HttpResponse response = client.execute((HttpUriRequest)httpGet);
                responseStatusCode = response.getStatusLine().getStatusCode();
            }
            catch (Exception e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= maxSystemTime) continue;
                log.error("Timeout ({} sec) waiting for node {}", (Object)300, (Object)node);
            }
        } while (responseStatusCode != 200);
        if (responseStatusCode == 200) {
            log.info("Node {} ready (responseStatus {})", (Object)node, (Object)responseStatusCode);
            this.countDownLatch.countDown();
        }
    }

    public synchronized void filterValidNodes() {
        if (!this.nodeListFiltered) {
            log.debug("Node availables in the node list: {}", (Object)this.nodeList.size());
            int nodeListSize = this.nodeList.size();
            ExecutorService executor = Executors.newFixedThreadPool(nodeListSize);
            final CountDownLatch latch = new CountDownLatch(nodeListSize);
            for (final String nodeCandidate : this.nodeList) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!GridHandler.this.nodeIsValid(nodeCandidate)) {
                            GridHandler.this.nodeList.remove(nodeCandidate);
                        }
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.nodeListFiltered = true;
            log.debug("Node availables in the node list after filtering: {}", (Object)this.nodeList.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodeIsValid(String nodeCandidate) {
        boolean valid = false;
        log.debug("Node candidate {}", (Object)nodeCandidate);
        if (SshConnection.ping(nodeCandidate)) {
            SshConnection remoteHost = new SshConnection(nodeCandidate);
            try {
                remoteHost.start();
                int xvfb = remoteHost.runAndWaitCommand("xvfb-run");
                if (xvfb != 2) {
                    log.debug("Node {} has no Xvfb", (Object)nodeCandidate);
                }
                valid = true;
            }
            catch (Exception e) {
                log.debug("Invalid credentials to access node {} ", (Object)nodeCandidate);
            }
            finally {
                remoteHost.stop();
            }
        } else {
            log.debug("Node {} seems to be down", (Object)nodeCandidate);
        }
        return valid;
    }

    public synchronized GridNode getRandomNodeFromList(String browserKey, BrowserType browserType, int browserPerInstance) {
        GridNode node;
        log.info("getRandomNodeFromList for browser {}", (Object)browserKey);
        GridNode gridNode = node = browserPerInstance > 1 ? this.existsNode(browserKey) : null;
        if (node == null) {
            try {
                String nodeCandidate = this.nodeList.get(Randomizer.getInt(0, this.nodeList.size()));
                log.info("######## Creating node {} in host {}", (Object)browserKey, (Object)nodeCandidate);
                node = new GridNode(nodeCandidate, browserType, browserPerInstance);
                this.addNode(browserKey, node);
                this.nodeList.remove(nodeCandidate);
                log.info(">>>> Using node {} for browser '{}'", (Object)node.getHost(), (Object)browserKey);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("No valid available node(s) to perform Selenim Grid test");
            }
        } else {
            log.info(">>>> Re-using node {} for browser '{}'", (Object)node.getHost(), (Object)browserKey);
            node.setStarted(true);
        }
        return node;
    }

    private synchronized GridNode existsNode(String browserKey) {
        GridNode gridNode = null;
        int indexOfSeparator = browserKey.lastIndexOf("-");
        if (indexOfSeparator != -1) {
            String browserPreffix = browserKey.substring(0, indexOfSeparator + 1);
            log.debug("browserPreffix {}", (Object)browserPreffix);
            for (String node : this.nodes.keySet()) {
                if (!node.startsWith(browserPreffix)) continue;
                gridNode = this.nodes.get(node);
                break;
            }
        }
        log.debug("Exists node {} = {}", (Object)browserKey, (Object)(gridNode != null ? 1 : 0));
        return gridNode;
    }

    private void stopNode(GridNode node) throws IOException {
        if (node.getSshConnection().isStarted()) {
            node.getSshConnection().execCommand("kill", "-9", "-1");
            node.stopSsh();
        }
    }

    public void runParallel(List<GridNode> nodeList, Runnable myFunc) throws InterruptedException, ExecutionException {
        ExecutorService exec = Executors.newFixedThreadPool(this.nodes.size());
        ArrayList results = new ArrayList();
        for (int i = 0; i < this.nodes.size(); ++i) {
            results.add(exec.submit(myFunc));
        }
        for (Future future : results) {
            future.get();
        }
    }

    public String getHubHost() {
        return this.hubAddress;
    }

    public int getHubPort() {
        return this.hubPort;
    }

    public GridNode getNode(String browserKey) {
        return this.nodes.get(browserKey);
    }

    public synchronized void addNode(String browserKey, GridNode node) {
        log.info("Adding node {} ({}) to map", (Object)browserKey, (Object)node.getHost());
        this.nodes.put(browserKey, node);
    }

    public boolean useRemoteNodes() {
        return !this.nodes.isEmpty();
    }

    public void logNodeList() {
        String nodeListStr = "";
        for (GridNode node : this.nodes.values()) {
            nodeListStr = nodeListStr + node.getHost() + " ";
        }
        log.debug("Node list: {}", (Object)nodeListStr);
    }

    public GridNode getFirstNode(String browserKey) {
        if (this.nodes.containsKey(browserKey)) {
            return this.nodes.get(browserKey);
        }
        return this.nodes.get(browserKey.substring(0, browserKey.indexOf("-") + 1) + 0);
    }

    public synchronized boolean containsSimilarBrowserKey(String browserKey) {
        boolean constainsSimilarBrowser = false;
        int index = browserKey.indexOf("-");
        String browser = null;
        if (index != -1) {
            String prefix = browserKey.substring(0, browserKey.indexOf("-"));
            for (String key : this.nodes.keySet()) {
                if (!(constainsSimilarBrowser |= key.startsWith(prefix))) continue;
                browser = key;
                break;
            }
        }
        if (constainsSimilarBrowser && !this.nodes.keySet().contains(browserKey) && browser != null) {
            this.addNode(browserKey, this.nodes.get(browser));
        }
        return constainsSimilarBrowser;
    }

    public void setHubAddress(String hubAddress) {
        this.hubAddress = hubAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readContents(String address) throws IOException {
        StringBuilder contents = new StringBuilder(2048);
        try (BufferedReader br = null;){
            URL url = new URL(address);
            br = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = "";
            while (line != null) {
                line = br.readLine();
                contents.append(line);
            }
        }
        return contents.toString();
    }

    public List<String> getNodeList() {
        return this.nodeList;
    }
}

