/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.mediainfo;

import com.google.common.base.Strings;
import java.io.File;
import org.junit.Assert;
import org.kurento.test.mediainfo.MediaInfo;

public class AssertMedia {
    public static void assertCodecs(String pathToMedia, String expectedVideoCodec, String expectedAudioCodec) {
        MediaInfo info = new MediaInfo();
        info.open(new File(pathToMedia));
        String videoFormat = info.get(MediaInfo.StreamKind.Video, 0, "Format", MediaInfo.InfoKind.Text, MediaInfo.InfoKind.Name);
        String audioFormat = info.get(MediaInfo.StreamKind.Audio, 0, "Format", MediaInfo.InfoKind.Text, MediaInfo.InfoKind.Name);
        info.close();
        if (expectedVideoCodec != null) {
            Assert.assertEquals((String)("Wrong video codec in " + pathToMedia), (Object)expectedVideoCodec, (Object)videoFormat);
        }
        if (expectedAudioCodec != null) {
            Assert.assertEquals((String)("Wrong audio codec in " + pathToMedia), (Object)expectedAudioCodec, (Object)audioFormat);
        }
    }

    public static void assertDuration(String pathToMedia, double expectedDurationMs, double thresholdMs) {
        AssertMedia.assertAudioDuration(pathToMedia, expectedDurationMs, thresholdMs);
        AssertMedia.assertGeneralDuration(pathToMedia, expectedDurationMs, thresholdMs);
    }

    public static void assertAudioDuration(String pathToMedia, double expectedDurationMs, double thresholdMs) {
        MediaInfo info = new MediaInfo();
        info.open(new File(pathToMedia));
        String audioDuration = info.get(MediaInfo.StreamKind.Audio, 0, "Duration", MediaInfo.InfoKind.Text, MediaInfo.InfoKind.Name);
        info.close();
        Assert.assertFalse((String)("Audio duration is empty or null in " + pathToMedia), (boolean)Strings.isNullOrEmpty((String)audioDuration));
        long audioDurationMs = Long.parseLong(audioDuration);
        double difference = Math.abs((double)audioDurationMs - expectedDurationMs);
        Assert.assertTrue((String)("Wrong audio duration (expected=" + expectedDurationMs + " ms, real= " + audioDurationMs + " ms) in " + pathToMedia), (difference < thresholdMs ? 1 : 0) != 0);
    }

    public static void assertGeneralDuration(String pathToMedia, double expectedDurationMs, double thresholdMs) {
        MediaInfo info = new MediaInfo();
        info.open(new File(pathToMedia));
        String generalDuration = info.get(MediaInfo.StreamKind.General, 0, "Duration", MediaInfo.InfoKind.Text, MediaInfo.InfoKind.Name);
        info.close();
        Assert.assertFalse((String)("General duration is empty or null in " + pathToMedia), (boolean)Strings.isNullOrEmpty((String)generalDuration));
        long generalDurationMs = Long.parseLong(generalDuration);
        double difference = Math.abs((double)generalDurationMs - expectedDurationMs);
        Assert.assertTrue((String)("Wrong general duration (expected=" + expectedDurationMs + " ms, real= " + generalDurationMs + " ms) in " + pathToMedia), (difference < thresholdMs ? 1 : 0) != 0);
    }
}

