/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import java.util.HashMap;
import java.util.Map;
import org.kurento.client.MediaType;
import org.kurento.client.RTCInboundRTPStreamStats;
import org.kurento.client.RTCOutboundRTPStreamStats;
import org.kurento.client.Stats;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.test.browser.WebPage;
import org.kurento.test.monitor.PeerConnectionStats;
import org.kurento.test.monitor.WebRtcEndpointStats;
import org.kurento.test.monitor.WebRtcStats;

public class WebRtcClient {
    public static final String INBOUND = "webrtcendpoint_inbound";
    public static final String OUTBOUND = "webrtcendpoint_outbound";
    private String id;
    private WebPage webPage;
    private WebRtcEndpoint webRtcEndpoint;

    public WebRtcClient(String id, WebRtcEndpoint webRtcEndpoint, WebPage webPage) {
        this.id = id;
        this.webPage = webPage;
        this.webRtcEndpoint = webRtcEndpoint;
    }

    public WebPage getWebPage() {
        return this.webPage;
    }

    public WebRtcEndpoint getWebRtcEndpoint() {
        return this.webRtcEndpoint;
    }

    public String toString() {
        return "WebRtcClient [webPage=" + this.webPage + ", webRtcEndpoint=" + this.webRtcEndpoint + "]";
    }

    public WebRtcStats getWebRtcStats() {
        PeerConnectionStats pcStats = null;
        if (this.webPage != null) {
            pcStats = this.webPage.getRtcStats();
        }
        WebRtcEndpointStats webRtcEpStats = null;
        if (this.webRtcEndpoint != null) {
            webRtcEpStats = this.getStats(this.webRtcEndpoint);
        }
        return new WebRtcStats(this.id, pcStats, webRtcEpStats);
    }

    private WebRtcEndpointStats getStats(WebRtcEndpoint webRtcEndpoint) {
        MediaType[] types;
        HashMap<String, Stats> stats = new HashMap<String, Stats>();
        for (MediaType type : types = new MediaType[]{MediaType.VIDEO, MediaType.AUDIO, MediaType.DATA}) {
            Map trackStats = webRtcEndpoint.getStats(type);
            for (Stats track : trackStats.values()) {
                stats.put(type.name().toLowerCase() + "_" + this.getRtcStatsType(track.getClass()), track);
            }
        }
        return new WebRtcEndpointStats(stats);
    }

    private String getRtcStatsType(Class<?> clazz) {
        String type = clazz.getSimpleName();
        if (clazz.equals(RTCInboundRTPStreamStats.class)) {
            type = INBOUND;
        } else if (clazz.equals(RTCOutboundRTPStreamStats.class)) {
            type = OUTBOUND;
        }
        return type;
    }
}

