/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import org.kurento.commons.PropertiesManager;
import org.kurento.test.services.TestService;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;

public class WebServerService
extends TestService {
    private Class<?> webServerClass;
    protected ConfigurableApplicationContext context;

    public WebServerService() {
        this.webServerClass = WebServer.class;
    }

    public WebServerService(Class<?> webServerClass) {
        this.webServerClass = webServerClass;
    }

    @Override
    public void start() {
        super.start();
        System.setProperty("java.security.egd", "file:/dev/./urandom");
        this.startContext();
    }

    private void startContext() {
        this.context = new SpringApplication(new Object[]{this.webServerClass}).run(new String[]{"--server.port=" + WebServerService.getAppHttpPort()});
        this.context.registerShutdownHook();
    }

    @Override
    public void stop() {
        super.stop();
        this.stopContext();
    }

    private void stopContext() {
        if (this.context != null && this.context.isRunning()) {
            this.context.stop();
            this.context.close();
        }
    }

    @Override
    public TestService.TestServiceScope getScope() {
        return TestService.TestServiceScope.TEST;
    }

    public ConfigurableApplicationContext getContext() {
        return this.context;
    }

    public static int getAppHttpPort() {
        return PropertiesManager.getProperty((String)"server.port", (int)8443);
    }

    public void setWebServerClass(Class<?> webServerClass) {
        this.webServerClass = webServerClass;
        this.stopContext();
        this.startContext();
    }

    @EnableAutoConfiguration
    public static class WebServer {
    }
}

