/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.jmeter.JMeter;
import org.kurento.test.browser.BrowserEventListener;
import org.w3c.dom.Document;

public class JMeterClient {
    static final String ROOT = "src/test/resources/jmeter/";
    static final String JMXFOLDER = "target/test-classes/";
    static final String REPORTS = "target/jmeter-reports/";
    static final String JMXFILE = "player.jmx";
    private BrowserEventListener eventListener;
    private URL url;
    private int concurrentUsers;
    private CountDownLatch terminationEvent;
    private int timeout;

    public JMeterClient(URL url) {
        this.url = url;
        this.terminationEvent = new CountDownLatch(1);
        this.concurrentUsers = 5;
        this.timeout = 60;
    }

    private void setup() throws TemplateException, IOException {
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        Template template = cfg.getTemplate("src/test/resources/jmeter/player.jmx.ftl");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("protocol", this.url.getProtocol());
        data.put("port", String.valueOf(this.url.getPort()));
        data.put("host", this.url.getHost());
        data.put("path", this.url.getPath());
        data.put("numUsers", this.concurrentUsers);
        FileWriter file = new FileWriter(new File("target/test-classes/player.jmx"));
        template.process(data, (Writer)file);
        ((Writer)file).flush();
        ((Writer)file).close();
    }

    public void start() throws Exception {
        String[] files;
        this.addEventListener(new BrowserEventListener(){

            @Override
            public void onEvent(String event) {
                JMeterClient.this.terminationEvent.countDown();
            }
        });
        this.setup();
        String jmxExtension = ".jmx";
        String jtlExtension = ".jtl";
        String htmlExtension = ".html";
        String logFile = "target/jmeter-reports/jmeter.log";
        String jmeterProperties = "src/test/resources/jmeter/bin/jmeter.properties";
        File xsl = new File("src/test/resources/jmeter/bin/jmeter-results-detail.xsl");
        File fileFeports = new File(REPORTS);
        if (!fileFeports.exists()) {
            fileFeports.mkdir();
        }
        JMeter jmeter = new JMeter();
        for (String file : files = new File(JMXFOLDER).list()) {
            if (!file.toLowerCase().endsWith(".jmx")) continue;
            String fileNoExt = file.substring(0, file.length() - ".jmx".length());
            String outputFileJtl = REPORTS + fileNoExt + ".jtl";
            String[] arguments = new String[]{"-n", "-t", JMXFOLDER + file, "-p", "src/test/resources/jmeter/bin/jmeter.properties", "-d", ROOT, "-l", outputFileJtl, "-j", "target/jmeter-reports/jmeter.log"};
            jmeter.start(arguments);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            System.setOut(new PrintStream(baos));
            boolean running = true;
            do {
                String line;
                BufferedReader br = new BufferedReader(new StringReader(baos.toString()));
                while ((line = br.readLine()) != null) {
                    running = !line.equals("... end of run");
                }
            } while (running);
            String outputFileHtml = REPORTS + fileNoExt + ".html";
            this.jtl2html(xsl, new File(outputFileJtl), new File(outputFileHtml));
        }
        File jmxFile = new File("target/test-classes/player.jmx");
        jmxFile.delete();
    }

    private void jtl2html(File stylesheet, File datafile, File fileOutput) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(datafile);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        StreamSource stylesource = new StreamSource(stylesheet);
        Transformer transformer = tFactory.newTransformer(stylesource);
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(fileOutput);
        transformer.transform(source, result);
        this.eventListener.onEvent("end");
    }

    public boolean waitForEnding() throws InterruptedException {
        return this.terminationEvent.await(this.getTimeout(), TimeUnit.SECONDS);
    }

    public void addEventListener(BrowserEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public int getConcurrentUsers() {
        return this.concurrentUsers;
    }

    public void setConcurrentUsers(int concurrentUsers) {
        this.concurrentUsers = concurrentUsers;
    }

    public URL getUrl() {
        return this.url;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

