/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.browser;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.commons.net.RemoteService;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.browser.BrowserType;
import org.kurento.test.docker.Docker;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBrowserManager {
    public static final int REMOTE_WEB_DRIVER_CREATION_MAX_RETRIES = 3;
    private static final int REMOTE_WEB_DRIVER_CREATION_TIMEOUT_S = 20;
    private static final int HUB_CREATION_WAIT_POOL_TIME_MS = 1000;
    private static final int HUB_CREATION_TIMEOUT_MS = 30000;
    private static Logger log = LoggerFactory.getLogger(DockerBrowserManager.class);
    private Docker docker = Docker.getSingleton();
    private AtomicInteger numBrowsers = new AtomicInteger();
    private CountDownLatch hubStarted = new CountDownLatch(1);
    private String dockerHubIp;
    private String hubContainerName;
    private String hubUrl;
    private ExecutorService exec = Executors.newFixedThreadPool(10);
    private ConcurrentMap<String, DockerBrowser> browsers = new ConcurrentHashMap<String, DockerBrowser>();
    private boolean record;
    private Path downloadLogsPath;

    public DockerBrowserManager() {
        this.docker = Docker.getSingleton();
        this.record = PropertiesManager.getProperty((String)"test.selenium.record", (boolean)true);
        this.calculateHubContainerName();
    }

    public void setDownloadLogsPath(Path path) {
        this.downloadLogsPath = path;
    }

    private void calculateHubContainerName() {
        this.hubContainerName = PropertiesManager.getProperty((String)"docker.hub.container.name", (String)"hub");
        if (this.docker.isRunningInContainer()) {
            String containerName = this.docker.getContainerName();
            this.hubContainerName = containerName + "-" + this.hubContainerName;
        }
    }

    public RemoteWebDriver createDockerDriver(String id, DesiredCapabilities capabilities) throws MalformedURLException {
        DockerBrowser browser = new DockerBrowser(id, capabilities);
        if (this.browsers.putIfAbsent(id, browser) != null) {
            throw new KurentoException("Browser with id " + id + " already exists");
        }
        boolean firstBrowser = this.numBrowsers.incrementAndGet() == 1;
        this.startHub(firstBrowser);
        browser.create();
        return browser.getRemoteWebDriver();
    }

    public void closeDriver(String id) {
        DockerBrowser browser = (DockerBrowser)this.browsers.remove(id);
        if (browser == null) {
            log.warn("Browser " + id + " does not exists");
            return;
        }
        browser.close();
        if (this.numBrowsers.decrementAndGet() == 0) {
            this.closeHub();
        }
    }

    private synchronized void closeHub() {
        if (this.hubContainerName == null) {
            log.warn("Trying to close Hub, but it is not created");
            return;
        }
        this.downloadLogsForContainer(this.hubContainerName, "hub");
        this.docker.stopAndRemoveContainers(this.hubContainerName);
        this.dockerHubIp = null;
        this.hubUrl = null;
        this.hubStarted = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHub(boolean firstBrowser) {
        if (firstBrowser) {
            DockerBrowserManager dockerBrowserManager = this;
            synchronized (dockerBrowserManager) {
                log.debug("Creating hub...");
                String hubImageId = PropertiesManager.getProperty((String)"docker.hub.image", (String)"selenium/hub:2.48.2");
                this.dockerHubIp = this.docker.startAndWaitHub(this.hubContainerName, hubImageId);
                this.hubUrl = "http://" + this.dockerHubIp + ":4444";
                this.hubStarted.countDown();
            }
        }
        if (this.hubStarted.getCount() != 0L) {
            log.debug("Waiting for hub...");
            try {
                this.hubStarted.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("InterruptedException while waiting to hub creation");
            }
        }
    }

    private String createSecretFile() throws IOException {
        Path secretFile = Paths.get(KurentoTest.getTestDir() + "vnc-passwd", new String[0]);
        try (BufferedWriter bw = Files.newBufferedWriter(secretFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            bw.write("secret");
        }
        return secretFile.toAbsolutePath().toString();
    }

    private String calculateBrowserImageName(DesiredCapabilities capabilities) {
        String browserName = capabilities.getBrowserName();
        if (browserName.equals(DesiredCapabilities.chrome().getBrowserName())) {
            if (this.record) {
                return PropertiesManager.getProperty((String)"docker.node.chrome-debug.image", (String)"selenium/node-chrome-debug:2.48.1");
            }
            return PropertiesManager.getProperty((String)"docker.node.chrome.image", (String)"selenium/node-chrome:2.48.2");
        }
        if (browserName.equals(DesiredCapabilities.firefox().getBrowserName())) {
            if (this.record) {
                return PropertiesManager.getProperty((String)"docker.node.firefox-debug.image", (String)"selenium/node-firefox-debug:2.48.2");
            }
            return PropertiesManager.getProperty((String)"docker.node.firefox.image", (String)"selenium/node-firefox:2.48.2");
        }
        throw new RuntimeException("Browser " + browserName + " is not supported currently for Docker scope");
    }

    private void downloadLogsForContainer(String container, String logName) {
        if (this.docker.existsContainer(container) && this.downloadLogsPath != null) {
            try {
                Path logFile = this.downloadLogsPath.resolve(logName + ".log");
                if (Files.exists(logFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
                }
                log.debug("Downloading log for container {} in file {}", (Object)container, (Object)logFile.toAbsolutePath());
                this.docker.downloadLog(container, logFile);
            }
            catch (IOException e) {
                log.warn("Exception writing logs for container {}", (Object)container, (Object)e);
            }
        }
    }

    private class DockerBrowser {
        private String id;
        private String browserContainerName;
        private String vncrecorderContainerName;
        private String browserContainerIp;
        private DesiredCapabilities capabilities;
        private RemoteWebDriver driver;

        public DockerBrowser(String id, DesiredCapabilities capabilities) {
            this.id = id;
            this.capabilities = capabilities;
            this.calculateContainerNames();
            capabilities.setCapability("applicationName", this.browserContainerName);
        }

        private void calculateContainerNames() {
            this.browserContainerName = this.id;
            this.vncrecorderContainerName = this.browserContainerName + "-" + PropertiesManager.getProperty((String)"docker.vncrecorder.container.name", (String)"vncrecorder");
            if (DockerBrowserManager.this.docker.isRunningInContainer()) {
                String containerName = DockerBrowserManager.this.docker.getContainerName();
                this.browserContainerName = containerName + "-" + this.browserContainerName;
                this.vncrecorderContainerName = containerName + "-" + this.vncrecorderContainerName;
            }
        }

        private void waitForNodeRegisteredInHub() {
            long timeoutMs = System.currentTimeMillis() + 30000L;
            while (true) {
                try {
                    while (true) {
                        JsonObject result;
                        if ((result = this.curl(DockerBrowserManager.this.hubUrl + "/grid/api/proxy?id=http://" + this.browserContainerIp + ":5555")).get("success").getAsBoolean()) {
                            log.info("Capabilities of container {}: {}", (Object)this.browserContainerName, (Object)result.get("request").getAsJsonObject().get("capabilities"));
                            return;
                        }
                        log.debug("Node {} not registered in hub. Waiting {} ms...", (Object)this.id, (Object)1000);
                        this.waitPoolTime(timeoutMs, "node registration in hub");
                    }
                }
                catch (MalformedURLException e) {
                    throw new Error(e);
                }
                catch (IOException e) {
                    log.debug("Hub is not ready ({} : {}). Waiting {} ms...", new Object[]{e.getClass().getName(), e.getMessage(), 1000});
                    this.waitPoolTime(timeoutMs, "hub service ready");
                    continue;
                }
                break;
            }
        }

        private void waitPoolTime(long timeoutMs, String message) {
            if (System.currentTimeMillis() > timeoutMs) {
                throw new RuntimeException("Timeout of 30000 ms waiting for " + message);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private JsonObject curl(String urlString) throws MalformedURLException, IOException {
            URL url = new URL(urlString);
            URLConnection connection = url.openConnection();
            BufferedReader is = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            JsonObject result = (JsonObject)new GsonBuilder().create().fromJson((Reader)is, JsonObject.class);
            return result;
        }

        public void create() {
            String nodeImageId = DockerBrowserManager.this.calculateBrowserImageName(this.capabilities);
            BrowserType type = BrowserType.valueOf(this.capabilities.getBrowserName().toUpperCase());
            int numRetries = 0;
            do {
                try {
                    DockerBrowserManager.this.docker.startAndWaitNode(this.browserContainerName, type, this.browserContainerName, nodeImageId, DockerBrowserManager.this.dockerHubIp);
                    this.browserContainerIp = DockerBrowserManager.this.docker.inspectContainer(this.browserContainerName).getNetworkSettings().getIpAddress();
                    this.waitForNodeRegisteredInHub();
                    this.createAndWaitRemoteDriver(DockerBrowserManager.this.hubUrl + "/wd/hub", this.capabilities);
                }
                catch (TimeoutException e) {
                    if (numRetries == 3) {
                        throw new KurentoException("Timeout of 60 seconds trying to create a RemoteWebDriver after3retries");
                    }
                    log.warn("Timeout of {} seconds creating RemoteWebDriver. Retrying {}...", (Object)20, (Object)numRetries);
                    DockerBrowserManager.this.docker.stopAndRemoveContainer(this.browserContainerName);
                    this.browserContainerName = this.browserContainerName + "r";
                    this.capabilities.setCapability("applicationName", this.browserContainerName);
                    ++numRetries;
                }
            } while (this.driver == null);
            log.debug("RemoteWebDriver for browser {} created (Version={}, Capabilities={})", new Object[]{this.id, this.driver.getCapabilities().getVersion(), this.driver.getCapabilities()});
            if (DockerBrowserManager.this.record) {
                this.createVncRecorderContainer();
            }
        }

        private void createAndWaitRemoteDriver(final String driverUrl, final DesiredCapabilities capabilities) throws TimeoutException {
            log.debug("Creating remote driver for browser {} in hub {}", (Object)this.id, (Object)driverUrl);
            int timeoutSeconds = PropertiesManager.getProperty((String)"selenium.max.driver.error", (int)10);
            long timeoutMs = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeoutSeconds);
            do {
                Future<RemoteWebDriver> driverFuture = null;
                try {
                    driverFuture = DockerBrowserManager.this.exec.submit(new Callable<RemoteWebDriver>(){

                        @Override
                        public RemoteWebDriver call() throws Exception {
                            return new RemoteWebDriver(new URL(driverUrl), (Capabilities)capabilities);
                        }
                    });
                    RemoteWebDriver remoteDriver = driverFuture.get(20L, TimeUnit.SECONDS);
                    SessionId sessionId = remoteDriver.getSessionId();
                    String nodeIp = this.obtainBrowserNodeIp(sessionId);
                    if (!nodeIp.equals(this.browserContainerIp)) {
                        log.warn("Browser {} is not created in its container. Container IP: {} Browser IP:{}", new Object[]{this.id, this.browserContainerIp, nodeIp});
                    }
                    log.debug("Created selenium session {} for browser {} in node {}", new Object[]{sessionId, this.id, nodeIp});
                    this.driver = remoteDriver;
                }
                catch (TimeoutException e) {
                    driverFuture.cancel(true);
                    throw e;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted exception waiting for RemoteWebDriver", e);
                }
                catch (ExecutionException e) {
                    log.warn("Exception creating RemoveWebDriver", (Throwable)e);
                    if (System.currentTimeMillis() > timeoutMs) {
                        throw new KurentoException("Timeout of " + timeoutMs + " millis waiting to create a RemoteWebDriver", e.getCause());
                    }
                    log.debug("Exception creating RemoteWebDriver for browser \"{}\". Retrying...", (Object)this.id, (Object)e.getCause());
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException t) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            } while (this.driver == null);
        }

        private String obtainBrowserNodeIp(SessionId sessionId) {
            try {
                JsonObject result = this.curl(DockerBrowserManager.this.hubUrl + "/grid/api/testsession?session=" + sessionId);
                String nodeIp = result.get("proxyId").getAsString();
                return nodeIp.substring(7, nodeIp.length()).split(":")[0];
            }
            catch (IOException e) {
                log.warn("Exception while trying to obtain node Ip. {}:{}", (Object)e.getClass().getName(), (Object)e.getMessage());
                return null;
            }
        }

        private void createVncRecorderContainer() {
            try {
                try {
                    RemoteService.waitForReady((String)this.browserContainerIp, (int)5900, (int)10, (TimeUnit)TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException("Timeout when connecting to browser VNC");
                }
                String vncrecordImageId = PropertiesManager.getProperty((String)"docker.vncrecorder.image", (String)"softsam/vncrecorder");
                if (DockerBrowserManager.this.docker.existsContainer(this.vncrecorderContainerName)) {
                    throw new KurentoException("Vncrecorder container '" + this.vncrecorderContainerName + "' already exists");
                }
                String secretFile = DockerBrowserManager.this.createSecretFile();
                DockerBrowserManager.this.docker.pullImageIfNecessary(vncrecordImageId, false);
                String videoFile = Paths.get(KurentoTest.getDefaultOutputFile("-" + this.id + "-record.flv"), new String[0]).toAbsolutePath().toString();
                log.debug("Creating container {} for recording video from browser {} in file {}", new Object[]{this.vncrecorderContainerName, this.browserContainerName, videoFile});
                CreateContainerCmd createContainerCmd = DockerBrowserManager.this.docker.getClient().createContainerCmd(vncrecordImageId).withName(this.vncrecorderContainerName).withCmd(new String[]{"-o", videoFile, "-P", secretFile, this.browserContainerIp, "5900"});
                DockerBrowserManager.this.docker.mountDefaultFolders(createContainerCmd);
                createContainerCmd.exec();
                DockerBrowserManager.this.docker.startContainer(this.vncrecorderContainerName);
                log.debug("Container {} started...", (Object)this.vncrecorderContainerName);
            }
            catch (Exception e) {
                log.warn("Exception creating vncRecorder container");
            }
        }

        public RemoteWebDriver getRemoteWebDriver() {
            return this.driver;
        }

        public void close() {
            DockerBrowserManager.this.downloadLogsForContainer(this.browserContainerName, this.id);
            DockerBrowserManager.this.downloadLogsForContainer(this.vncrecorderContainerName, this.id + "-recorder");
            DockerBrowserManager.this.docker.stopAndRemoveContainers(this.vncrecorderContainerName, this.browserContainerName);
        }
    }
}

