/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.latency;

public enum VideoTagType {
    LOCAL,
    REMOTE;

    public static String localId;
    public static String remoteId;

    public String getColor() {
        switch (this) {
            case LOCAL: {
                return "return kurentoTest.colorInfo['" + localId + "'].changeColor;";
            }
        }
        return "return kurentoTest.colorInfo['" + remoteId + "'].changeColor;";
    }

    public String getTime() {
        switch (this) {
            case LOCAL: {
                return "return kurentoTest.colorInfo['" + localId + "'].changeTime;";
            }
        }
        return "return kurentoTest.colorInfo['" + remoteId + "'].changeTime;";
    }

    public String toString() {
        switch (this) {
            case LOCAL: {
                return "local stream";
            }
        }
        return "remote stream";
    }

    public String getName() {
        switch (this) {
            case LOCAL: {
                return "local";
            }
        }
        return "remote";
    }

    public String getId() {
        if (localId == null || remoteId == null) {
            throw new RuntimeException("You must specify local/remote video tag id in order to perform latency control");
        }
        switch (this) {
            case LOCAL: {
                return localId;
            }
        }
        return remoteId;
    }

    public static void setLocalId(String id) {
        localId = id;
    }

    public static void setRemoteId(String id) {
        remoteId = id;
    }
}

