/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.FrameworkField;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.lifecycle.FinishedTest;
import org.kurento.test.lifecycle.KurentoTestWatcher;
import org.kurento.test.services.TestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KurentoTestListener
extends RunListener {
    private Class<?> testClass;
    private List<FrameworkField> serviceFields;
    private static List<TestService> serviceRunners = new ArrayList<TestService>();
    protected static Logger log = LoggerFactory.getLogger(KurentoTestListener.class);

    public KurentoTestListener(List<FrameworkField> services) {
        this.serviceFields = services;
        for (FrameworkField service : this.serviceFields) {
            TestService serviceRunner = null;
            try {
                serviceRunner = (TestService)service.getField().get(null);
                if (serviceRunners.contains(serviceRunner)) continue;
                serviceRunners.add(serviceRunner);
                if (serviceRunner.getScope() != TestService.TestServiceScope.TESTSUITE) continue;
                serviceRunner.start();
            }
            catch (Throwable e) {
                log.warn("Exception instanting service in class {}", (Object)serviceRunner, (Object)e);
            }
        }
    }

    private void invokeServices(ServiceMethod method, TestService.TestServiceScope scope) {
        for (TestService serviceRunner : serviceRunners) {
            log.info("** Only for debugging: serviceRunner: {}. All Service Runners: {}", (Object)serviceRunner, serviceRunners);
            log.info("** Only for debugging: serviceRunner.getScope: {}", (Object)serviceRunner.getScope());
            if (serviceRunner.getScope() != scope) continue;
            if (method == ServiceMethod.START) {
                serviceRunner.start();
                continue;
            }
            if (method != ServiceMethod.STOP) continue;
            log.info("** Only for debugging: serviceRunner.stop() {}", (Object)serviceRunner);
            serviceRunner.stop();
            log.info("### Only for debugging: After serviceRunner.stop() -> serviceRunner: {}. All Service Runners: {}", (Object)serviceRunner, serviceRunners);
        }
    }

    public void testRunStarted(Description description) {
        this.testClass = description.getTestClass();
        log.debug("Starting test class {}", (Object)this.testClass.getName());
        this.invokeServices(ServiceMethod.START, TestService.TestServiceScope.TESTCLASS);
    }

    public void testRunFinished(Result result) {
        log.debug("Finishing test class {}. Test(s) failed: {}", (Object)this.testClass.getName(), (Object)result.getFailureCount());
        this.invokeServices(ServiceMethod.STOP, TestService.TestServiceScope.TESTCLASS);
    }

    public void testStarted(Description description) {
        String methodName = description.getMethodName();
        KurentoTest.setTestMethodName(methodName);
        log.debug("Starting test {}.{}", (Object)this.testClass.getName(), (Object)methodName);
        this.invokeServices(ServiceMethod.START, TestService.TestServiceScope.TEST);
        KurentoTest.logMessage("|       TEST STARTING: " + description.getClassName() + "." + methodName);
    }

    public void testFinished(Description description) {
        String methodName = description.getMethodName();
        log.debug("Finishing test {}.{}", (Object)this.testClass.getName(), (Object)methodName);
        this.invokeServices(ServiceMethod.STOP, TestService.TestServiceScope.TEST);
        KurentoTestWatcher.invokeMethodsAnnotatedWith(FinishedTest.class, description.getTestClass(), null, description);
    }

    public void testSuiteFinished() {
        log.debug("Finishing test suite");
        this.invokeServices(ServiceMethod.STOP, TestService.TestServiceScope.TESTSUITE);
    }

    public static enum ServiceMethod {
        START,
        STOP;

    }
}

