/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.services;

import java.util.ArrayList;
import java.util.List;
import org.kurento.client.EventListener;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaPipeline;
import org.kurento.client.OnIceCandidateEvent;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.test.monitor.SystemMonitorManager;
import org.kurento.test.services.KmsService;
import org.kurento.test.utils.WebRtcConnector;

public class FakeKmsService
extends KmsService {
    protected List<WebRtcEndpoint> fakeWebRtcList = new ArrayList<WebRtcEndpoint>();

    public FakeKmsService() {
        this.kmsLoginProp = "fake.kms.login";
        this.kmsPasswdProp = "fake.kms.passwd";
        this.kmsPemProp = "fake.kms.pem";
        this.kmsAutostartProp = "fake.kms.autostart";
        this.kmsAutostartDefault = "false";
        this.kmsWsUriProp = "fake.kms.ws.uri";
        this.kmsWsUriExportProp = "fake.kms.url";
        this.kmsScopeProp = "fake.kms.scope";
        this.kmsScopeDefault = "local";
        String uri = PropertiesManager.getProperty((String)"fake.kms.ws.uri");
        if (uri == null) {
            if (PropertiesManager.getProperty((String)"kms.ws.uri") != null) {
                this.kmsWsUriProp = "kms.ws.uri";
                this.setWsUri(PropertiesManager.getProperty((String)"kms.ws.uri"));
            } else {
                this.setWsUri("ws://localhost:8888/kurento");
            }
        } else {
            this.setWsUri(uri);
        }
    }

    @Override
    protected String getDockerContainerNameSuffix() {
        return "_fakekms";
    }

    @Override
    protected String getDockerLogSuffix() {
        return "-fakekms";
    }

    public void addFakeClients(int numFakeClients, final int bandwidht, final MediaPipeline mainPipeline, final WebRtcEndpoint inputWebRtc, long timeBetweenClientMs, SystemMonitorManager monitor, final WebRtcConnector connector) {
        if (this.kurentoClient == null) {
            throw new KurentoException("Fake kurentoClient for is not defined.");
        }
        log.info("* * * Adding {} fake clients * * *", (Object)numFakeClients);
        final MediaPipeline fakePipeline = this.kurentoClient.createMediaPipeline();
        for (int i = 0; i < numFakeClients; ++i) {
            log.info("* * * Adding fake client {} * * *", (Object)i);
            new Thread(){

                @Override
                public void run() {
                    final WebRtcEndpoint fakeOutputWebRtc = (WebRtcEndpoint)new WebRtcEndpoint.Builder(mainPipeline).build();
                    final WebRtcEndpoint fakeBrowser = (WebRtcEndpoint)new WebRtcEndpoint.Builder(fakePipeline).build();
                    if (bandwidht != -1) {
                        fakeOutputWebRtc.setMaxVideoSendBandwidth(bandwidht);
                        fakeOutputWebRtc.setMinVideoSendBandwidth(bandwidht);
                        fakeBrowser.setMaxVideoRecvBandwidth(bandwidht);
                    }
                    fakeOutputWebRtc.addOnIceCandidateListener((EventListener)new EventListener<OnIceCandidateEvent>(){

                        public void onEvent(OnIceCandidateEvent event) {
                            fakeBrowser.addIceCandidate(event.getCandidate());
                        }
                    });
                    fakeBrowser.addOnIceCandidateListener((EventListener)new EventListener<OnIceCandidateEvent>(){

                        public void onEvent(OnIceCandidateEvent event) {
                            fakeOutputWebRtc.addIceCandidate(event.getCandidate());
                        }
                    });
                    String sdpOffer = fakeBrowser.generateOffer();
                    String sdpAnswer = fakeOutputWebRtc.processOffer(sdpOffer);
                    fakeBrowser.processAnswer(sdpAnswer);
                    fakeOutputWebRtc.gatherCandidates();
                    fakeBrowser.gatherCandidates();
                    if (connector == null) {
                        inputWebRtc.connect((MediaElement)fakeOutputWebRtc);
                    } else {
                        connector.connect(inputWebRtc, fakeOutputWebRtc);
                    }
                    FakeKmsService.this.fakeWebRtcList.add(fakeOutputWebRtc);
                }
            }.start();
            if (monitor != null) {
                monitor.incrementNumClients();
            }
            this.waitMs(timeBetweenClientMs);
        }
    }

    public void removeAllFakeClients(long timeBetweenClientMs, WebRtcEndpoint inputWebRtc, SystemMonitorManager monitor) {
        for (WebRtcEndpoint fakeWebRtc : this.fakeWebRtcList) {
            inputWebRtc.disconnect((MediaElement)fakeWebRtc);
            monitor.decrementNumClients();
            this.waitMs(timeBetweenClientMs);
        }
    }

    private void waitMs(long timeBetweenClientMs) {
        if (timeBetweenClientMs > 0L) {
            try {
                Thread.sleep(timeBetweenClientMs);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted exception working with fake clients", (Throwable)e);
            }
        }
    }
}

