/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.lept;
import org.bytedeco.javacpp.tesseract;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.browser.Browser;
import org.kurento.test.browser.WebPage;
import org.kurento.test.config.TestScenario;
import org.kurento.test.internal.AbortableCountDownLatch;

public abstract class BrowserTest<W extends WebPage>
extends KurentoTest {
    public static final Color CHROME_VIDEOTEST_COLOR = new Color(0, 135, 0);
    public static final int OCR_TIME_THRESHOLD_MS = 300;
    public static final int OCR_COLOR_THRESHOLD = 180;
    public static final String LATENCY_KEY = "latencyMs";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("H:mm:ss:S");
    private Map<String, W> pages = new ConcurrentHashMap<String, W>();

    @Before
    public void setupBrowserTest() throws InterruptedException {
        if (this.testScenario != null && this.testScenario.getBrowserMap() != null && this.testScenario.getBrowserMap().size() > 0) {
            ExecutorService executor = Executors.newFixedThreadPool(this.testScenario.getBrowserMap().size());
            final AbortableCountDownLatch latch = new AbortableCountDownLatch(this.testScenario.getBrowserMap().size());
            for (final String browserKey : this.testScenario.getBrowserMap().keySet()) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Browser browser = BrowserTest.this.testScenario.getBrowserMap().get(browserKey);
                            int timeout = PropertiesManager.getProperty((String)"test.url.timeout", (int)30);
                            URL url = browser.getUrl();
                            if (!BrowserTest.this.testScenario.getUrlList().contains(url)) {
                                BrowserTest.this.waitForHostIsReachable(url, timeout);
                                BrowserTest.this.testScenario.getUrlList().add(url);
                            }
                            BrowserTest.this.initBrowser(browserKey, browser);
                            latch.countDown();
                        }
                        catch (Throwable t) {
                            latch.abort("Exception setting up test. A browser could not be initialised", t);
                            t.printStackTrace();
                        }
                    }
                });
            }
            latch.await();
        }
    }

    private void initBrowser(String browserKey, Browser browser) {
        browser.setId(browserKey);
        browser.setName(BrowserTest.getTestMethodName());
        browser.init();
        browser.injectKurentoTestJs();
    }

    @After
    public void teardownBrowserTest() {
        if (this.testScenario != null) {
            for (Browser browser : this.testScenario.getBrowserMap().values()) {
                try {
                    browser.close();
                }
                catch (Exception e) {
                    log.warn("Exception closing browser {}", (Object)browser.getId(), (Object)e);
                }
            }
        }
    }

    public TestScenario getTestScenario() {
        return this.testScenario;
    }

    public void addBrowser(String browserKey, Browser browser) {
        this.testScenario.getBrowserMap().put(browserKey, browser);
        this.initBrowser(browserKey, browser);
    }

    public W getPage(String browserKey) {
        return this.assertAndGetPage(browserKey);
    }

    public W getPage() {
        try {
            return this.assertAndGetPage("browser");
        }
        catch (RuntimeException e) {
            if (this.testScenario.getBrowserMap().isEmpty()) {
                throw new RuntimeException("Empty test scenario: no available browser to run tests!");
            }
            String browserKey = this.testScenario.getBrowserMap().entrySet().iterator().next().getKey();
            log.debug("browser is not registered in test scenarario, instead using first browser in the test scenario, i.e. " + browserKey);
            return this.getOrCreatePage(browserKey);
        }
    }

    public W getPage(int index) {
        return this.assertAndGetPage("browser" + index);
    }

    public W getPresenter() {
        return this.assertAndGetPage("presenter");
    }

    public W getPresenter(int index) {
        return this.assertAndGetPage("presenter" + index);
    }

    public W getViewer() {
        return this.assertAndGetPage("viewer");
    }

    public W getViewer(int index) {
        return this.assertAndGetPage("viewer" + index);
    }

    private W assertAndGetPage(String browserKey) {
        if (!this.testScenario.getBrowserMap().keySet().contains(browserKey)) {
            throw new RuntimeException(browserKey + " is not registered as browser in the test scenario");
        }
        return this.getOrCreatePage(browserKey);
    }

    private synchronized W getOrCreatePage(String browserKey) {
        Object webPage;
        if (this.pages.containsKey(browserKey)) {
            webPage = (WebPage)this.pages.get(browserKey);
            ((WebPage)webPage).setBrowser(this.testScenario.getBrowserMap().get(browserKey));
        } else {
            webPage = this.createWebPage();
            ((WebPage)webPage).setBrowser(this.testScenario.getBrowserMap().get(browserKey));
            this.pages.put(browserKey, webPage);
        }
        return (W)webPage;
    }

    protected W createWebPage() {
        Class<?> testClientClass = BrowserTest.getParamType(this.getClass());
        try {
            return (W)((WebPage)testClientClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Exception creating an instance of class " + testClientClass.getName(), e);
        }
    }

    public static Class<?> getParamType(Class<?> testClass) {
        Type genericSuperclass = testClass.getGenericSuperclass();
        if (genericSuperclass != null) {
            if (genericSuperclass instanceof Class) {
                return BrowserTest.getParamType((Class)genericSuperclass);
            }
            ParameterizedType paramClass = (ParameterizedType)genericSuperclass;
            return (Class)paramClass.getActualTypeArguments()[0];
        }
        throw new RuntimeException("Unable to obtain the type paramter of KurentoTest");
    }

    public void waitForHostIsReachable(URL url, int timeout) {
        long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, TimeUnit.SECONDS);
        long endTimeMillis = System.currentTimeMillis() + timeoutMillis;
        log.debug("Waiting for {} to be reachable (timeout {} seconds)", (Object)url, (Object)timeout);
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            int responseCode = 0;
            while (true) {
                try {
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setConnectTimeout((int)timeoutMillis);
                    connection.setReadTimeout((int)timeoutMillis);
                    connection.setRequestMethod("HEAD");
                    responseCode = connection.getResponseCode();
                }
                catch (SocketException | SSLHandshakeException e) {
                    log.warn("Error {} waiting URL {}, trying again in 1 second", (Object)e.getMessage(), (Object)url);
                    Thread.sleep(1000L);
                    if (System.currentTimeMillis() <= endTimeMillis) continue;
                }
                break;
            }
            if (responseCode != 200) {
                Assert.fail((String)("URL " + url + " not reachable. Response code=" + responseCode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("URL " + url + " not reachable in " + timeout + " seconds (" + e.getClass().getName() + ", " + e.getMessage() + ")"));
        }
        log.debug("URL {} already reachable", (Object)url);
    }

    public void waitSeconds(long waitTime) {
        this.waitMilliSeconds(TimeUnit.SECONDS.toMillis(waitTime));
    }

    public void waitMilliSeconds(long waitTime) {
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException e) {
            log.warn("InterruptedException waiting {} milliseconds", (Object)waitTime, (Object)e);
        }
    }

    public void syncTimeForOcr(W[] webpages, String[] videoTagsId, String[] peerConnectionsId) throws InterruptedException {
        int webpagesLength = webpages.length;
        int videoTagsLength = videoTagsId.length;
        if (webpagesLength != videoTagsLength) {
            throw new KurentoException("The size of webpage arrays (" + webpagesLength + "}) must be the same as videoTags (" + videoTagsLength + ")");
        }
        ExecutorService service = Executors.newFixedThreadPool(webpagesLength);
        CountDownLatch latch = new CountDownLatch(webpagesLength);
        int i = 0;
        while (i < webpagesLength) {
            int j = i++;
            service.execute(new Runnable((WebPage[])webpages, j, videoTagsId, peerConnectionsId, latch){
                final /* synthetic */ WebPage[] val$webpages;
                final /* synthetic */ int val$j;
                final /* synthetic */ String[] val$videoTagsId;
                final /* synthetic */ String[] val$peerConnectionsId;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$webpages = webPageArray;
                    this.val$j = n;
                    this.val$videoTagsId = stringArray;
                    this.val$peerConnectionsId = stringArray2;
                    this.val$latch = countDownLatch;
                }

                @Override
                public void run() {
                    this.val$webpages[this.val$j].syncTimeForOcr(this.val$videoTagsId[this.val$j], this.val$peerConnectionsId[this.val$j]);
                    this.val$latch.countDown();
                }
            });
        }
        latch.await();
        service.shutdown();
    }

    public void serializeObject(Object object, String file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(object);
        oos.close();
        fos.close();
    }

    public void processDataToCsv(String outputFile, final Map<String, Map<String, String>> presenter, final Map<String, Map<String, String>> viewer) throws InterruptedException, IOException {
        log.info("Processing OCR and stats to CSV ({})", (Object)outputFile);
        log.trace("Presenter {} : {}", (Object)presenter.size(), presenter.keySet());
        log.trace("Viewer {} : {}", (Object)viewer.size(), viewer.keySet());
        HashBasedTable resultTable = HashBasedTable.create();
        int numRows = presenter.size();
        ExecutorService executor = Executors.newFixedThreadPool(numRows);
        CountDownLatch latch = new CountDownLatch(numRows);
        Iterator<String> iteratorPresenter = presenter.keySet().iterator();
        int i = 0;
        while (i < numRows) {
            int j = i++;
            final String key = iteratorPresenter.next();
            executor.execute(new Runnable((Table)resultTable, j, latch){
                final /* synthetic */ Table val$resultTable;
                final /* synthetic */ int val$j;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$resultTable = table;
                    this.val$j = n;
                    this.val$latch = countDownLatch;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block7: {
                        try {
                            String matchKey = BrowserTest.this.containSimilarDate(key, viewer.keySet());
                            if (matchKey == null) break block7;
                            String presenterBase64 = (String)((Map)presenter.get(key)).get(BrowserTest.LATENCY_KEY);
                            String viewerBase64 = (String)((Map)viewer.get(matchKey)).get(BrowserTest.LATENCY_KEY);
                            String presenterDateStr = BrowserTest.this.ocr(presenterBase64);
                            String viewerDateStr = BrowserTest.this.ocr(viewerBase64);
                            String latency = String.valueOf(BrowserTest.this.processOcr(presenterDateStr, viewerDateStr, presenterBase64, viewerBase64));
                            Table table = this.val$resultTable;
                            synchronized (table) {
                                if (!this.val$resultTable.row((Object)0).containsValue(BrowserTest.LATENCY_KEY)) {
                                    this.val$resultTable.put((Object)0, (Object)0, (Object)BrowserTest.LATENCY_KEY);
                                }
                                this.val$resultTable.put((Object)(this.val$j + 1), (Object)0, (Object)latency);
                            }
                        }
                        finally {
                            this.val$latch.countDown();
                        }
                    }
                }
            });
        }
        latch.await();
        executor.shutdown();
        this.processStats(presenter, (Table<Integer, Integer, String>)resultTable);
        this.processStats(viewer, (Table<Integer, Integer, String>)resultTable);
        log.info("OCR + Stats results: {}", (Object)resultTable);
        this.writeCSV(outputFile, (Table<Integer, Integer, String>)resultTable);
    }

    public synchronized long processOcr(String presenterDateStr, String viewerDateStr, String presenterBase64, String viewerBase64) {
        long latency = -1L;
        try {
            Date presenterDate = DATE_FORMAT.parse(presenterDateStr);
            Date viewerDate = DATE_FORMAT.parse(viewerDateStr);
            latency = presenterDate.getTime() - viewerDate.getTime();
        }
        catch (Exception e) {
            log.warn("Unparseable date(s) (presenter: '{}' - viewer: '{}')\nBase64 presenter: {}\nBase64 viewer: {}", new Object[]{presenterDateStr, viewerDateStr, presenterBase64, viewerBase64, e});
        }
        log.info("--> Latency {} ms (presenter: '{}' - viewer: '{}')", new Object[]{latency, presenterDateStr, viewerDateStr});
        if (latency > 1000L || latency < -1L) {
            log.warn(">>> Bad latency measurement: {} ms (presenter: '{}' - viewer: '{}')\nBase64 presenter: {}\nBase64 viewer: {}", new Object[]{latency, presenterDateStr, viewerDateStr, presenterBase64, viewerBase64});
        }
        return latency;
    }

    public void processStats(Map<String, Map<String, String>> stats, Table<Integer, Integer, String> resultTable) {
        Iterator<String> iterator = stats.keySet().iterator();
        for (int i = 0; i < stats.size(); ++i) {
            String mapKey = iterator.next();
            Map<String, String> entryStat = stats.get(mapKey);
            for (String key : entryStat.keySet()) {
                if (key.equalsIgnoreCase(LATENCY_KEY)) continue;
                if (!resultTable.row((Object)0).containsValue(key)) {
                    int columnCount = resultTable.columnKeySet().size();
                    resultTable.put((Object)0, (Object)columnCount, (Object)key);
                    resultTable.put((Object)(1 + i), (Object)columnCount, (Object)entryStat.get(key));
                    log.trace("Inserting new header for stat: {} on column {}", (Object)key, (Object)columnCount);
                    log.trace("Inserting first value for stat: {} on row {} column {}", new Object[]{entryStat.get(key), 1 + i, columnCount});
                    continue;
                }
                int columnIndex = this.getKeyOfValue(resultTable.row((Object)0), key);
                resultTable.put((Object)(1 + i), (Object)columnIndex, (Object)entryStat.get(key));
                log.trace("Inserting value for stat: {} on row {} column {}", new Object[]{entryStat.get(key), 1 + i, columnIndex});
            }
        }
    }

    public void writeCSV(String outputFile, Table<Integer, Integer, String> resultTable) throws IOException {
        FileWriter writer = new FileWriter(outputFile);
        for (Integer row : resultTable.rowKeySet()) {
            boolean first = true;
            for (Integer column : resultTable.columnKeySet()) {
                String value;
                if (!first) {
                    writer.append(',');
                }
                if ((value = (String)resultTable.get((Object)row, (Object)column)) != null) {
                    writer.append(value);
                }
                first = false;
            }
            writer.append('\n');
        }
        writer.flush();
        writer.close();
    }

    public Integer getKeyOfValue(Map<Integer, String> map, String value) {
        Integer key = null;
        for (Integer i : map.keySet()) {
            if (!map.get(i).equalsIgnoreCase(value)) continue;
            key = i;
            break;
        }
        return key;
    }

    public String containSimilarDate(String key, Set<String> keySet) {
        long minDiff = 0L;
        for (String k : keySet) {
            long diff = Math.abs(Long.parseLong(key) - Long.parseLong(k));
            if (diff < 300L) {
                return k;
            }
            if (minDiff == 0L) {
                minDiff = diff;
                continue;
            }
            if (diff >= minDiff) continue;
            minDiff = diff;
        }
        log.warn("Not matching key for {} [min difference {}]", (Object)key, (Object)minDiff);
        return null;
    }

    public String ocr(String imgBase64) {
        String parsedOut = null;
        try {
            BufferedImage imgBuff = ImageIO.read(new ByteArrayInputStream(Base64.decodeBase64((String)imgBase64.substring(imgBase64.lastIndexOf(",") + 1))));
            for (int x = 0; x < imgBuff.getWidth(); ++x) {
                for (int y = 0; y < imgBuff.getHeight(); ++y) {
                    int blue;
                    int green;
                    Color color = new Color(imgBuff.getRGB(x, y));
                    int red = color.getRed();
                    if (red + (green = color.getBlue()) + (blue = color.getGreen()) > 180) {
                        blue = 0;
                        green = 0;
                        red = 0;
                    } else {
                        blue = 255;
                        green = 255;
                        red = 255;
                    }
                    Color col = new Color(red, green, blue);
                    imgBuff.setRGB(x, y, col.getRGB());
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)imgBuff, "png", baos);
            byte[] imageBytes = baos.toByteArray();
            tesseract.TessBaseAPI api = new tesseract.TessBaseAPI();
            api.Init(null, "eng");
            ByteBuffer imgBB = ByteBuffer.wrap(imageBytes);
            lept.PIX image = lept.pixReadMem((ByteBuffer)imgBB, (long)imageBytes.length);
            api.SetImage(image);
            BytePointer outText = api.GetUTF8Text();
            api.End();
            api.close();
            outText.deallocate();
            lept.pixDestroy((lept.PIX)image);
            parsedOut = outText.getString().replaceAll("l", "1").replaceAll("Z", "2").replaceAll("O", "0").replaceAll("B", "8").replaceAll("G", "6").replaceAll("S", "8").replaceAll("'", "").replaceAll("\u2018", "");
            int iSpace = parsedOut.lastIndexOf(" ");
            if (iSpace != -1) {
                parsedOut = parsedOut.substring(0, iSpace);
            }
        }
        catch (IOException e) {
            log.warn("IOException in OCR", (Throwable)e);
        }
        return parsedOut;
    }
}

