/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import java.awt.Color;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.kurento.client.EndOfStreamEvent;
import org.kurento.client.EventListener;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaFlowInStateChangeEvent;
import org.kurento.client.MediaFlowState;
import org.kurento.client.MediaPipeline;
import org.kurento.client.PlayerEndpoint;
import org.kurento.client.WebRtcEndpoint;
import org.kurento.commons.testing.SystemStabilityTests;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.base.RepositoryMongoTest;
import org.kurento.test.browser.WebRtcChannel;
import org.kurento.test.browser.WebRtcMode;
import org.kurento.test.browser.WebRtcTestPage;

@Category(value={SystemStabilityTests.class})
public class StabilityTest
extends RepositoryMongoTest {
    public final long DEFAULT_TEST_DURATION = 300000L;
    public long endTestTime = 0L;

    public StabilityTest() {
        StabilityTest.setDeleteLogsIfSuccess(false);
    }

    public boolean isTimeToFinishTest() {
        return System.currentTimeMillis() > this.endTestTime;
    }

    public void testPlayerMultipleSeek(String mediaUrl, WebRtcChannel webRtcChannel, int pauseTimeSeconds, int numSeeks, Map<Integer, Color> expectedPositionAndColor) throws Exception {
        MediaPipeline mp = kurentoClient.createMediaPipeline();
        PlayerEndpoint playerEp = (PlayerEndpoint)new PlayerEndpoint.Builder(mp, mediaUrl).build();
        WebRtcEndpoint webRtcEp = (WebRtcEndpoint)new WebRtcEndpoint.Builder(mp).build();
        playerEp.connect((MediaElement)webRtcEp);
        final CountDownLatch eosLatch = new CountDownLatch(1);
        final CountDownLatch flowingLatch = new CountDownLatch(1);
        playerEp.addEndOfStreamListener((EventListener)new EventListener<EndOfStreamEvent>(){

            public void onEvent(EndOfStreamEvent event) {
                KurentoTest.log.debug("Received EndOfStream Event");
                eosLatch.countDown();
            }
        });
        webRtcEp.addMediaFlowInStateChangeListener((EventListener)new EventListener<MediaFlowInStateChangeEvent>(){

            public void onEvent(MediaFlowInStateChangeEvent event) {
                if (event.getState().equals((Object)MediaFlowState.FLOWING)) {
                    flowingLatch.countDown();
                }
            }
        });
        ((WebRtcTestPage)this.getPage()).subscribeEvents("playing");
        ((WebRtcTestPage)this.getPage()).initWebRtc(webRtcEp, webRtcChannel, WebRtcMode.RCV_ONLY);
        playerEp.play();
        Assert.assertTrue((String)("Not received media (timeout waiting playing event): " + mediaUrl + " " + (Object)((Object)webRtcChannel)), (boolean)((WebRtcTestPage)this.getPage()).waitForEvent("playing"));
        Assert.assertTrue((String)("Not received FLOWING IN event in webRtcEp: " + mediaUrl + " " + (Object)((Object)webRtcChannel)), (boolean)flowingLatch.await(((WebRtcTestPage)this.getPage()).getTimeout(), TimeUnit.SECONDS));
        Thread.sleep(TimeUnit.SECONDS.toMillis(pauseTimeSeconds));
        Integer executions = -1;
        for (int i = 0; i < numSeeks; ++i) {
            Integer n = executions;
            Integer n2 = executions = Integer.valueOf(executions + 1);
            log.debug("Try to set position in 0");
            playerEp.setPosition(0L);
            for (Integer position : expectedPositionAndColor.keySet()) {
                Integer n3 = executions;
                Integer n4 = executions = Integer.valueOf(executions + 1);
                log.debug("Try to set position in {}", (Object)position);
                playerEp.setPosition((long)position.intValue());
                if (webRtcChannel == WebRtcChannel.AUDIO_ONLY) continue;
                boolean isSimilarColor = ((WebRtcTestPage)this.getPage()).similarColor(expectedPositionAndColor.get(position));
                log.debug("Is the color of the video: {} ? {} ", (Object)expectedPositionAndColor.get(position), (Object)isSimilarColor);
                if (eosLatch.getCount() == 0L) break;
                Assert.assertTrue((String)("After set position to " + position + "ms, the color of the video should be " + expectedPositionAndColor.get(position)), (boolean)isSimilarColor);
            }
            if (eosLatch.getCount() == 0L) break;
        }
        Integer executionsExpected = numSeeks * expectedPositionAndColor.size() + numSeeks - 1;
        log.info("The times executed. Expected  {}. Total {}.", (Object)executionsExpected, (Object)executions);
        Assert.assertTrue((String)("The times executed is wrong. Minimun should be 1. Total: " + executions), (executions > 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Not received EOS event in player: " + mediaUrl + " " + (Object)((Object)webRtcChannel)), (boolean)eosLatch.await(((WebRtcTestPage)this.getPage()).getTimeout(), TimeUnit.SECONDS));
        playerEp.release();
        mp.release();
    }
}

