/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.internal;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.kurento.test.utils.SshConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckNodes {
    public Logger log = LoggerFactory.getLogger(CheckNodes.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("node-list.txt");
        List nodeList = CharStreams.readLines((Readable)new InputStreamReader(inputStream, Charsets.UTF_8));
        ArrayList<String> nodesWithoutXvfb = new ArrayList<String>();
        ArrayList<String> nodesWithException = new ArrayList<String>();
        ArrayList<String> nodesDown = new ArrayList<String>();
        ArrayList<String> nodesOk = new ArrayList<String>();
        for (String node : nodeList) {
            if (SshConnection.ping(node)) {
                SshConnection remoteHost = new SshConnection(node);
                try {
                    remoteHost.start();
                    int xvfb = remoteHost.runAndWaitCommand("xvfb-run");
                    if (xvfb != 2) {
                        nodesWithoutXvfb.add(node);
                    } else {
                        nodesOk.add(node);
                    }
                    this.log.info("{} {}", (Object)node, (Object)xvfb);
                    continue;
                }
                catch (Exception e) {
                    this.log.error("Exception in node {} : {}", (Object)node, e.getClass());
                    nodesWithException.add(node);
                    continue;
                }
                finally {
                    remoteHost.stop();
                    continue;
                }
            }
            this.log.error("Node down {}", (Object)node);
            nodesDown.add(node);
        }
        this.log.info("Nodes Ok: {} {}", (Object)nodesOk.size(), nodesOk);
        this.log.info("Nodes without Xvfb: {} {}", (Object)nodesWithoutXvfb.size(), nodesWithoutXvfb);
        this.log.info("Nodes with exception: {} {}", (Object)nodesWithException.size(), nodesWithException);
        this.log.info("Nodes down: {} {}", (Object)nodesDown.size(), nodesDown);
    }

    public static void main(String[] args) throws IOException {
        CheckNodes checkNodes = new CheckNodes();
        checkNodes.check();
    }
}

