/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.kurento.test.monitor.KmsSystemInfo;
import org.kurento.test.monitor.MonitorSample;
import org.kurento.test.monitor.WebRtcStats;

public class MonitorSampleRegistrer {
    private Map<Long, MonitorSample> samples = new TreeMap<Long, MonitorSample>();
    private boolean showLantency = false;

    public void addSample(long time, MonitorSample sample) {
        this.samples.put(time, sample);
    }

    public void writeResults(String csvFile) throws IOException {
        Path path = Paths.get(csvFile, new String[0]);
        Path parent = path.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (PrintWriter pw = new PrintWriter(new FileWriter(csvFile));){
            this.printKmsProcessHeaders(pw);
            Map<String, List<String>> headers = this.printWebRtcHeaders(pw);
            pw.println("");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm:ss.SSS");
            for (long time : this.samples.keySet()) {
                MonitorSample sample = this.samples.get(time);
                pw.print(simpleDateFormat.format(time) + ",");
                this.printKmsProcessStats(pw, sample);
                this.printWebRtcStats(pw, headers, sample);
                pw.println("");
            }
        }
    }

    private void printWebRtcStats(PrintWriter pw, Map<String, List<String>> headers, MonitorSample sample) {
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            WebRtcStats stats = sample.getWebRtcStats(e.getKey());
            if (stats != null) {
                for (Object value : stats.calculateValues(e.getValue())) {
                    if (value != null) {
                        pw.print("," + value);
                        continue;
                    }
                    pw.print(",");
                }
                continue;
            }
            for (int i = 0; i < e.getValue().size(); ++i) {
                pw.print(",");
            }
        }
    }

    private void printKmsProcessHeaders(PrintWriter pw) {
        pw.print("time,clients_number,kms_threads_number");
        pw.print(",cpu_percentage,mem_bytes,mem_percentage");
        if (this.showLantency) {
            pw.print(",latency_ms_avg");
        }
        if (this.samples != null && !this.samples.entrySet().isEmpty()) {
            MonitorSample firstSample = this.samples.entrySet().iterator().next().getValue();
            pw.print(firstSample.getSystemInfo().getNetInfo().createHeader());
        }
    }

    private void printKmsProcessStats(PrintWriter pw, MonitorSample sample) {
        KmsSystemInfo systemInfo = sample.getSystemInfo();
        int numClients = sample.getNumClients();
        int numThreadsKms = systemInfo.getNumThreadsKms();
        double cpu = systemInfo.getCpuPercent();
        long mem = systemInfo.getMem();
        double memPercent = systemInfo.getMemPercent();
        pw.format(Locale.ENGLISH, numClients + "," + numThreadsKms + ",%.2f," + mem + ",%.2f", cpu, memPercent);
        if (this.showLantency) {
            pw.format(",%.2f", sample.getLatency());
        }
        pw.print(systemInfo.getNetInfo().createEntries());
    }

    private Map<String, List<String>> printWebRtcHeaders(PrintWriter pw) {
        TreeMap<String, List<String>> headers = new TreeMap<String, List<String>>();
        for (MonitorSample monitorSample : this.samples.values()) {
            Map<String, WebRtcStats> statsMap = monitorSample.getStats();
            for (Map.Entry<String, WebRtcStats> stats : statsMap.entrySet()) {
                List prevHeaders = (List)headers.get(stats.getKey());
                List<String> newHeaders = stats.getValue().calculateHeaders();
                if (prevHeaders == null) {
                    headers.put(stats.getKey(), newHeaders);
                    continue;
                }
                for (String newHeader : newHeaders) {
                    if (prevHeaders.contains(newHeader)) continue;
                    prevHeaders.add(newHeader);
                }
            }
        }
        for (Map.Entry entry : headers.entrySet()) {
            for (String h : (List)entry.getValue()) {
                pw.print("," + (String)entry.getKey() + "_" + h);
            }
        }
        return headers;
    }

    public void setShowLantency(boolean showLantency) {
        this.showLantency = showLantency;
    }
}

