/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.lept;
import org.bytedeco.javacpp.tesseract;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.browser.Browser;
import org.kurento.test.browser.WebPage;
import org.kurento.test.config.TestScenario;
import org.kurento.test.internal.AbortableCountDownLatch;
import org.kurento.test.lifecycle.FailedTest;
import org.kurento.test.utils.Shell;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrowserTest<W extends WebPage>
extends KurentoTest {
    public static Logger log = LoggerFactory.getLogger(BrowserTest.class);
    public static final Color CHROME_VIDEOTEST_COLOR = new Color(0, 135, 0);
    public static final int OCR_TIME_THRESHOLD_MS = 300;
    public static final int OCR_COLOR_THRESHOLD = 180;
    public static final String LATENCY_KEY = "E2ELatencyMs";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("H:mm:ss:S");
    public static final double FPS = 30.0;
    public static final int BLOCKSIZE = 1;
    public static final String SSIM_KEY = "avg_ssim";
    public static final String PSNR_KEY = "avg_psnr";
    public static final String PNG = ".png";
    public static final String Y4M = ".y4m";
    private static Map<String, LogEntries> browserLogs = new ConcurrentHashMap<String, LogEntries>();
    private final Map<String, W> pages = new ConcurrentHashMap<String, W>();

    @Before
    public void setupBrowserTest() throws InterruptedException {
        if (this.testScenario != null && this.testScenario.getBrowserMap() != null && this.testScenario.getBrowserMap().size() > 0) {
            ExecutorService executor = Executors.newFixedThreadPool(this.testScenario.getBrowserMap().size());
            final AbortableCountDownLatch latch = new AbortableCountDownLatch(this.testScenario.getBrowserMap().size());
            for (final String browserKey : this.testScenario.getBrowserMap().keySet()) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Browser browser = BrowserTest.this.testScenario.getBrowserMap().get(browserKey);
                            int timeout = PropertiesManager.getProperty((String)"test.url.timeout", (int)30);
                            URL url = browser.getUrl();
                            if (!BrowserTest.this.testScenario.getUrlList().contains(url)) {
                                BrowserTest.this.waitForHostIsReachable(url, timeout);
                                BrowserTest.this.testScenario.getUrlList().add(url);
                            }
                            BrowserTest.this.initBrowser(browserKey, browser);
                            latch.countDown();
                        }
                        catch (Throwable t) {
                            latch.abort("Exception setting up test. A browser could not be initialised", t);
                            t.printStackTrace();
                        }
                    }
                });
            }
            latch.await();
        }
    }

    private void initBrowser(String browserKey, Browser browser) throws IOException {
        browser.setId(browserKey);
        browser.setName(BrowserTest.getTestMethodName());
        browser.init();
        browser.injectKurentoTestJs();
    }

    @After
    public void teardownBrowserTest() {
        if (this.testScenario != null) {
            for (Browser browser : this.testScenario.getBrowserMap().values()) {
                try {
                    if (browser.getWebDriver() != null) {
                        browserLogs.put(browser.getId(), browser.getWebDriver().manage().logs().get("browser"));
                    } else {
                        log.warn("It was not possible to recover logs for {} since browser is no longer available (maybe it has been closed manually or crashed)", (Object)browser.getId());
                    }
                }
                catch (Exception e) {
                    log.warn("Exception getting logs {}", (Object)browser.getId(), (Object)e);
                }
                try {
                    browser.close();
                }
                catch (Exception e) {
                    log.warn("Exception closing browser {}", (Object)browser.getId(), (Object)e);
                }
            }
        }
    }

    @FailedTest
    public static void storeBrowsersLogs() {
        ArrayList<String> lines = new ArrayList<String>();
        for (String browserKey : browserLogs.keySet()) {
            for (LogEntry logEntry : browserLogs.get(browserKey)) {
                lines.add(logEntry.toString());
            }
            File file = new File(BrowserTest.getDefaultOutputTestPath() + browserKey + ".log");
            try {
                FileUtils.writeLines((File)file, lines);
            }
            catch (IOException e) {
                log.error("Error while writing browser log to a file", (Throwable)e);
            }
        }
    }

    public TestScenario getTestScenario() {
        return this.testScenario;
    }

    public void addBrowser(String browserKey, Browser browser) throws IOException {
        this.testScenario.getBrowserMap().put(browserKey, browser);
        this.initBrowser(browserKey, browser);
    }

    public W getPage(String browserKey) {
        return this.assertAndGetPage(browserKey);
    }

    public W getPage() {
        try {
            return this.assertAndGetPage("browser");
        }
        catch (RuntimeException e) {
            if (this.testScenario.getBrowserMap().isEmpty()) {
                throw new RuntimeException("Empty test scenario: no available browser to run tests!");
            }
            String browserKey = this.testScenario.getBrowserMap().entrySet().iterator().next().getKey();
            log.debug("browser is not registered in test scenarario, instead using first browser in the test scenario, i.e. " + browserKey);
            return this.getOrCreatePage(browserKey);
        }
    }

    public W getPage(int index) {
        return this.assertAndGetPage("browser" + index);
    }

    public W getPresenter() {
        return this.assertAndGetPage("presenter");
    }

    public W getPresenter(int index) {
        return this.assertAndGetPage("presenter" + index);
    }

    public W getViewer() {
        return this.assertAndGetPage("viewer");
    }

    public W getViewer(int index) {
        return this.assertAndGetPage("viewer" + index);
    }

    private W assertAndGetPage(String browserKey) {
        if (!this.testScenario.getBrowserMap().keySet().contains(browserKey)) {
            throw new RuntimeException(browserKey + " is not registered as browser in the test scenario");
        }
        return this.getOrCreatePage(browserKey);
    }

    private synchronized W getOrCreatePage(String browserKey) {
        Object webPage;
        if (this.pages.containsKey(browserKey)) {
            webPage = (WebPage)this.pages.get(browserKey);
            ((WebPage)webPage).setBrowser(this.testScenario.getBrowserMap().get(browserKey));
        } else {
            webPage = this.createWebPage();
            ((WebPage)webPage).setBrowser(this.testScenario.getBrowserMap().get(browserKey));
            this.pages.put(browserKey, webPage);
        }
        return (W)webPage;
    }

    protected W createWebPage() {
        Class<?> testClientClass = BrowserTest.getParamType(this.getClass());
        try {
            return (W)((WebPage)testClientClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Exception creating an instance of class " + testClientClass.getName(), e);
        }
    }

    public static Class<?> getParamType(Class<?> testClass) {
        Type genericSuperclass = testClass.getGenericSuperclass();
        if (genericSuperclass != null) {
            if (genericSuperclass instanceof Class) {
                return BrowserTest.getParamType((Class)genericSuperclass);
            }
            ParameterizedType paramClass = (ParameterizedType)genericSuperclass;
            return (Class)paramClass.getActualTypeArguments()[0];
        }
        throw new RuntimeException("Unable to obtain the type paramter of KurentoTest");
    }

    public void waitForHostIsReachable(URL url, int timeout) {
        long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, TimeUnit.SECONDS);
        long endTimeMillis = System.currentTimeMillis() + timeoutMillis;
        log.debug("Waiting for {} to be reachable (timeout {} seconds)", (Object)url, (Object)timeout);
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            int responseCode = 0;
            while (true) {
                try {
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setConnectTimeout((int)timeoutMillis);
                    connection.setReadTimeout((int)timeoutMillis);
                    connection.setRequestMethod("HEAD");
                    responseCode = connection.getResponseCode();
                }
                catch (SocketException | SSLHandshakeException e) {
                    log.warn("Error {} waiting URL {}, trying again in 1 second", (Object)e.getMessage(), (Object)url);
                    Thread.sleep(1000L);
                    if (System.currentTimeMillis() <= endTimeMillis) continue;
                }
                break;
            }
            if (responseCode != 200) {
                log.warn("URL " + url + " not reachable. Response code=" + responseCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("URL " + url + " not reachable in " + timeout + " seconds (" + e.getClass().getName() + ", " + e.getMessage() + ")"));
        }
        log.debug("URL {} already reachable", (Object)url);
    }

    public void waitSeconds(long waitTime) {
        this.waitMilliSeconds(TimeUnit.SECONDS.toMillis(waitTime));
    }

    public void waitMilliSeconds(long waitTime) {
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException e) {
            log.warn("InterruptedException waiting {} milliseconds", (Object)waitTime, (Object)e);
        }
    }

    public void syncTimeForOcr(W[] webpages, String[] videoTagsId, String[] peerConnectionsId) throws InterruptedException {
        int webpagesLength = webpages.length;
        int videoTagsLength = videoTagsId.length;
        if (webpagesLength != videoTagsLength) {
            throw new KurentoException("The size of webpage arrays (" + webpagesLength + "}) must be the same as videoTags (" + videoTagsLength + ")");
        }
        ExecutorService service = Executors.newFixedThreadPool(webpagesLength);
        CountDownLatch latch = new CountDownLatch(webpagesLength);
        int i = 0;
        while (i < webpagesLength) {
            int j = i++;
            service.execute(new Runnable((WebPage[])webpages, j, videoTagsId, peerConnectionsId, latch){
                final /* synthetic */ WebPage[] val$webpages;
                final /* synthetic */ int val$j;
                final /* synthetic */ String[] val$videoTagsId;
                final /* synthetic */ String[] val$peerConnectionsId;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$webpages = webPageArray;
                    this.val$j = n;
                    this.val$videoTagsId = stringArray;
                    this.val$peerConnectionsId = stringArray2;
                    this.val$latch = countDownLatch;
                }

                @Override
                public void run() {
                    this.val$webpages[this.val$j].syncTimeForOcr(this.val$videoTagsId[this.val$j], this.val$peerConnectionsId[this.val$j]);
                    this.val$latch.countDown();
                }
            });
        }
        latch.await();
        service.shutdown();
    }

    public void serializeObject(Object object, String file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(object);
        oos.close();
        fos.close();
    }

    public Table<Integer, Integer, String> processOcrAndStats(final Map<String, Map<String, Object>> presenter, final Map<String, Map<String, Object>> viewer) throws InterruptedException, IOException {
        log.debug("Processing OCR and stats");
        log.trace("Presenter {} : {}", (Object)presenter.size(), presenter.keySet());
        log.trace("Viewer {} : {}", (Object)viewer.size(), viewer.keySet());
        HashBasedTable resultTable = HashBasedTable.create();
        int numRows = presenter.size();
        int threadPoolSize = Runtime.getRuntime().availableProcessors();
        ExecutorService executor = Executors.newFixedThreadPool(threadPoolSize);
        CountDownLatch latch = new CountDownLatch(numRows);
        Iterator<String> iteratorPresenter = presenter.keySet().iterator();
        int i = 0;
        while (i < numRows) {
            int j = i++;
            final String key = iteratorPresenter.next();
            executor.execute(new Runnable((Table)resultTable, j, latch){
                final /* synthetic */ Table val$resultTable;
                final /* synthetic */ int val$j;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$resultTable = table;
                    this.val$j = n;
                    this.val$latch = countDownLatch;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block7: {
                        try {
                            String matchKey = BrowserTest.this.containSimilarDate(key, viewer.keySet());
                            if (matchKey == null) break block7;
                            String presenterBase64 = ((Map)presenter.get(key)).get(BrowserTest.LATENCY_KEY).toString();
                            String viewerBase64 = ((Map)viewer.get(matchKey)).get(BrowserTest.LATENCY_KEY).toString();
                            String presenterDateStr = BrowserTest.this.ocr(presenterBase64);
                            String viewerDateStr = BrowserTest.this.ocr(viewerBase64);
                            String latency = String.valueOf(BrowserTest.this.processOcr(presenterDateStr, viewerDateStr, presenterBase64, viewerBase64));
                            Table table = this.val$resultTable;
                            synchronized (table) {
                                if (!this.val$resultTable.row((Object)0).containsValue(BrowserTest.LATENCY_KEY)) {
                                    this.val$resultTable.put((Object)0, (Object)0, (Object)BrowserTest.LATENCY_KEY);
                                }
                                this.val$resultTable.put((Object)(this.val$j + 1), (Object)0, (Object)latency);
                            }
                        }
                        finally {
                            this.val$latch.countDown();
                        }
                    }
                }
            });
        }
        latch.await();
        executor.shutdown();
        this.processStats(presenter, (Table<Integer, Integer, String>)resultTable);
        this.processStats(viewer, (Table<Integer, Integer, String>)resultTable);
        log.debug("OCR + Stats results: {}", (Object)resultTable);
        return resultTable;
    }

    public synchronized long processOcr(String presenterDateStr, String viewerDateStr, String presenterBase64, String viewerBase64) {
        long latency = -1L;
        try {
            Date presenterDate = DATE_FORMAT.parse(presenterDateStr);
            Date viewerDate = DATE_FORMAT.parse(viewerDateStr);
            latency = presenterDate.getTime() - viewerDate.getTime();
        }
        catch (Exception e) {
            log.warn("Unparseable date(s) (presenter: '{}' - viewer: '{}')\nBase64 presenter: {}\nBase64 viewer: {}", new Object[]{presenterDateStr, viewerDateStr, presenterBase64, viewerBase64, e});
        }
        log.debug("--> Latency {} ms (presenter: '{}' - viewer: '{}')", new Object[]{latency, presenterDateStr, viewerDateStr});
        if (latency > 1000L || latency < -1L) {
            log.warn(">>> Bad latency measurement: {} ms (presenter: '{}' - viewer: '{}')\nBase64 presenter: {}\nBase64 viewer: {}", new Object[]{latency, presenterDateStr, viewerDateStr, presenterBase64, viewerBase64});
        }
        return latency;
    }

    public void processStats(Map<String, Map<String, Object>> stats, Table<Integer, Integer, String> resultTable) {
        Iterator<String> iterator = stats.keySet().iterator();
        for (int i = 0; i < stats.size(); ++i) {
            String mapKey = iterator.next();
            Map<String, Object> entryStat = stats.get(mapKey);
            for (String key : entryStat.keySet()) {
                if (key.equalsIgnoreCase(LATENCY_KEY)) continue;
                if (!resultTable.row((Object)0).containsValue(key)) {
                    int columnCount = resultTable.columnKeySet().size();
                    resultTable.put((Object)0, (Object)columnCount, (Object)key);
                    resultTable.put((Object)(1 + i), (Object)columnCount, (Object)entryStat.get(key).toString());
                    log.trace("Inserting new header for stat: {} on column {}", (Object)key, (Object)columnCount);
                    log.trace("Inserting first value for stat: {} on row {} column {}", new Object[]{entryStat.get(key), 1 + i, columnCount});
                    continue;
                }
                int columnIndex = this.getKeyOfValue(resultTable.row((Object)0), key);
                resultTable.put((Object)(1 + i), (Object)columnIndex, (Object)entryStat.get(key).toString());
                log.trace("Inserting value for stat: {} on row {} column {}", new Object[]{entryStat.get(key), 1 + i, columnIndex});
            }
        }
    }

    public void writeCSV(String outputFile, Table<Integer, Integer, String> resultTable) throws IOException {
        FileWriter writer = new FileWriter(outputFile);
        for (Integer row : resultTable.rowKeySet()) {
            boolean first = true;
            for (Integer column : resultTable.columnKeySet()) {
                String value;
                if (!first) {
                    writer.append(',');
                }
                if ((value = (String)resultTable.get((Object)row, (Object)column)) != null) {
                    writer.append(value);
                }
                first = false;
            }
            writer.append('\n');
        }
        writer.flush();
        writer.close();
    }

    public void writeCSV(String outputFile, Multimap<String, Object> multimap, boolean orderKeys) throws IOException {
        boolean moreValues;
        FileWriter writer = new FileWriter(outputFile);
        boolean first = true;
        Set keySet = orderKeys ? new TreeSet(multimap.keySet()) : multimap.keySet();
        for (String key : keySet) {
            if (!first) {
                writer.append(',');
            }
            writer.append(key);
            first = false;
        }
        writer.append('\n');
        int i = 0;
        do {
            moreValues = false;
            first = true;
            for (String key : keySet) {
                Object[] array = multimap.get((Object)key).toArray();
                boolean bl = moreValues = i < array.length;
                if (moreValues) {
                    if (!first) {
                        writer.append(',');
                    }
                    writer.append(array[i].toString());
                }
                first = false;
            }
            ++i;
            if (!moreValues) continue;
            writer.append('\n');
        } while (moreValues);
        writer.flush();
        writer.close();
    }

    public Integer getKeyOfValue(Map<Integer, String> map, String value) {
        Integer key = null;
        for (Integer i : map.keySet()) {
            if (!map.get(i).equalsIgnoreCase(value)) continue;
            key = i;
            break;
        }
        return key;
    }

    public String containSimilarDate(String key, Set<String> keySet) {
        long minDiff = 0L;
        for (String k : keySet) {
            long diff = Math.abs(Long.parseLong(key) - Long.parseLong(k));
            if (diff < 300L) {
                return k;
            }
            if (minDiff == 0L) {
                minDiff = diff;
                continue;
            }
            if (diff >= minDiff) continue;
            minDiff = diff;
        }
        log.warn("Not matching key for {} [min difference {}]", (Object)key, (Object)minDiff);
        return null;
    }

    public String ocr(String imgBase64) {
        BufferedImage imgBuff = null;
        try {
            imgBuff = ImageIO.read(new ByteArrayInputStream(Base64.decodeBase64((String)imgBase64.substring(imgBase64.lastIndexOf(",") + 1))));
        }
        catch (IOException e) {
            log.warn("IOException converting image to buffer", (Throwable)e);
        }
        return this.ocr(imgBuff);
    }

    public String ocr(BufferedImage imgBuff) {
        String parsedOut = null;
        try {
            int iSpace;
            for (int x = 0; x < imgBuff.getWidth(); ++x) {
                for (int y = 0; y < imgBuff.getHeight(); ++y) {
                    int blue;
                    int green;
                    Color color = new Color(imgBuff.getRGB(x, y));
                    int red = color.getRed();
                    if (red + (green = color.getBlue()) + (blue = color.getGreen()) > 180) {
                        blue = 0;
                        green = 0;
                        red = 0;
                    } else {
                        blue = 255;
                        green = 255;
                        red = 255;
                    }
                    Color col = new Color(red, green, blue);
                    imgBuff.setRGB(x, y, col.getRGB());
                }
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)imgBuff, "png", baos);
            byte[] imageBytes = baos.toByteArray();
            tesseract.TessBaseAPI api = new tesseract.TessBaseAPI();
            api.Init(null, "eng");
            ByteBuffer imgBB = ByteBuffer.wrap(imageBytes);
            lept.PIX image = lept.pixReadMem((ByteBuffer)imgBB, (long)imageBytes.length);
            api.SetImage(image);
            BytePointer outText = api.GetUTF8Text();
            api.End();
            api.close();
            outText.deallocate();
            lept.pixDestroy((lept.PIX)image);
            parsedOut = outText.getString().replaceAll("l", "1").replaceAll("Z", "2").replaceAll("O", "0").replaceAll("B", "8").replaceAll("G", "6").replaceAll("S", "8").replaceAll("'", "").replaceAll("\u2018", "").replaceAll("\\.", ":").replaceAll("E", "8").replaceAll("o", "0").replaceAll("\ufb02", "0").replaceAll("\ufb01", "6").replaceAll("\u00a7", "5").replaceAll("I", "1").replaceAll("T", "7").replaceAll("\u2019", "").replaceAll("U", "0").replaceAll("D", "0");
            if (parsedOut.length() > 7) {
                parsedOut = parsedOut.substring(0, 7) + ":" + parsedOut.substring(8, parsedOut.length());
            }
            if ((iSpace = (parsedOut = parsedOut.replaceAll("::", ":")).lastIndexOf(" ")) != -1) {
                parsedOut = parsedOut.substring(0, iSpace);
            }
        }
        catch (IOException e) {
            log.warn("IOException in OCR", (Throwable)e);
        }
        return parsedOut;
    }

    public File convertToRaw(File inputFile, File tmpFolder, double fps) {
        File y4m = new File(tmpFolder.toString() + File.separator + inputFile.getName() + Y4M);
        Object[] ffmpegCommand = new String[]{"ffmpeg", "-i", inputFile.toString(), "-f", "yuv4mpegpipe", "-r", this.parseFps(fps), y4m.toString()};
        log.debug("Running command to convert to raw: {}", (Object)Arrays.toString(ffmpegCommand));
        Shell.runAndWait((String[])ffmpegCommand);
        return y4m;
    }

    public Multimap<String, Object> getVideoQuality(File inputFile1, File inputFile2, String videoAlgorithm, double fps, int blocksize) throws IOException {
        String qpsnrCommand = "qpsnr -a " + videoAlgorithm + " -o blocksize=" + blocksize + ":fpa=" + this.parseFps(fps) + " -r " + inputFile1.getAbsolutePath() + " " + inputFile2.getAbsolutePath();
        log.debug("Running qpsnr to calcule video quality ({}): {}", (Object)videoAlgorithm, (Object)qpsnrCommand);
        String[] outputShell = Shell.runAndWait("sh", "-c", qpsnrCommand).split("\\r?\\n");
        ArrayListMultimap outputMap = ArrayListMultimap.create();
        boolean insertValues = false;
        for (String s : outputShell) {
            if (s.startsWith("Sample,")) {
                insertValues = true;
                continue;
            }
            if (!insertValues) continue;
            outputMap.put((Object)videoAlgorithm, (Object)s.split(",")[1]);
        }
        return outputMap;
    }

    public String parseFps(double fps) {
        DecimalFormat df = new DecimalFormat("0");
        return df.format(fps);
    }

    public File cutVideo(File inputFile, File tmpFolder, int cutFrame, double fps) {
        double cutTime = (double)cutFrame / fps;
        DecimalFormat df = new DecimalFormat("0.00");
        File cutVideoFile = new File(tmpFolder.toString() + File.separator + "cut-" + inputFile.getName());
        Object[] command = new String[]{"ffmpeg", "-i", inputFile.getAbsolutePath(), "-ss", df.format(cutTime), cutVideoFile.getAbsolutePath()};
        log.debug("Running command to cut video: {}", (Object)Arrays.toString(command));
        Shell.runAndWait((String[])command);
        return cutVideoFile;
    }

    public File cutAndTranscodeVideo(File inputFile, File tmpFolder, int cutFrame, double fps) {
        double cutTime = (double)cutFrame / fps;
        DecimalFormat df = new DecimalFormat("0.00");
        File cutVideoFile = new File(tmpFolder.toString() + File.separator + "cut-" + inputFile.getName());
        Object[] command = new String[]{"ffmpeg", "-i", inputFile.getAbsolutePath(), "-ss", df.format(cutTime), "-acodec", "copy", "-codec:v", "libvpx", cutVideoFile.getAbsolutePath()};
        log.debug("Running command to cut video: {}", (Object)Arrays.toString(command));
        Shell.runAndWait((String[])command);
        return cutVideoFile;
    }

    public File transcodeVideo(File inputFile, File tmpFolder, double fps) {
        File transVideoFile = new File(tmpFolder.toString() + File.separator + "trans-" + inputFile.getName());
        Object[] command = new String[]{"ffmpeg", "-i", inputFile.getAbsolutePath(), "-acodec", "copy", "-codec:v", "libvpx", transVideoFile.getAbsolutePath()};
        log.debug("Running command to transcode video: {}", (Object)Arrays.toString(command));
        Shell.runAndWait((String[])command);
        return transVideoFile;
    }

    public int getCutFrame(final File inputFile1, final File inputFile2, File tmpFolder) throws IOException {
        int i;
        FilenameFilter fileNameFilter1 = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(inputFile1.getName()) && name.endsWith(BrowserTest.PNG);
            }
        };
        FilenameFilter fileNameFilter2 = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(inputFile2.getName()) && name.endsWith(BrowserTest.PNG);
            }
        };
        Object[] ls1 = tmpFolder.listFiles(fileNameFilter1);
        Object[] ls2 = tmpFolder.listFiles(fileNameFilter2);
        Arrays.sort(ls1);
        Arrays.sort(ls2);
        ArrayList<String> ocrList1 = new ArrayList<String>();
        ArrayList<String> ocrList2 = new ArrayList<String>();
        for (i = 0; i < Math.min(ls1.length, ls2.length); ++i) {
            String ocr1 = this.ocr(ImageIO.read((File)ls1[i]));
            String ocr2 = this.ocr(ImageIO.read((File)ls2[i]));
            ocrList1.add(ocr1);
            ocrList2.add(ocr2);
            log.trace("---> Time comparsion to find cut frame: {} vs {}", (Object)ocr1, (Object)ocr2);
            if (ocrList2.contains(ocr1)) {
                log.debug("Found OCR match {} at position {}", (Object)ocr1, (Object)i);
                i *= -1;
                break;
            }
            if (!ocrList1.contains(ocr2)) continue;
            log.debug("Found OCR match {} at position {}", (Object)ocr2, (Object)i);
            break;
        }
        return i;
    }

    public void getFrames(final File inputFile, final File tmpFolder) {
        Thread t = new Thread(){

            @Override
            public void run() {
                Object[] command = new String[]{"ffmpeg", "-i", inputFile.getAbsolutePath(), tmpFolder.toString() + File.separator + inputFile.getName() + "-%03d" + BrowserTest.PNG};
                log.debug("Running command to get frames: {}", (Object)Arrays.toString(command));
                Shell.runAndWait((String[])command);
            }
        };
        t.start();
        this.waitMilliSeconds(500L);
        t.interrupt();
    }

    public Multimap<String, Object> getSsim(File inputFile1, File inputFile2) throws IOException {
        return this.getVideoQuality(inputFile1, inputFile2, SSIM_KEY, 30.0, 1);
    }

    public Multimap<String, Object> getPsnr(File inputFile1, File inputFile2) throws IOException {
        return this.getVideoQuality(inputFile1, inputFile2, PSNR_KEY, 30.0, 1);
    }

    public void waitForFilesInFolder(String folder, final String ext, int expectedFilesNumber) {
        File dir = new File(folder);
        File[] files = null;
        do {
            if (files != null) {
                this.waitMilliSeconds(500L);
            }
            files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(ext);
                }
            });
            log.debug("Number of files with extension {} in {} = {} (expected {})", new Object[]{ext, folder, files.length, expectedFilesNumber});
        } while (files.length != expectedFilesNumber);
    }

    public void addColumnsToTable(Table<Integer, Integer, String> table, Multimap<String, Object> column, int columnKey) {
        for (String key : column.keySet()) {
            this.shiftTable(table, columnKey);
            table.put((Object)0, (Object)columnKey, (Object)key);
            Collection content = column.get((Object)key);
            Iterator iterator = content.iterator();
            log.debug("Adding columun {} ({} elements) to table in position {}", new Object[]{key, content.size(), columnKey});
            for (int i = 0; i < content.size(); ++i) {
                table.put((Object)(i + 1), (Object)columnKey, (Object)iterator.next().toString());
            }
            ++columnKey;
        }
    }

    private void shiftTable(Table<Integer, Integer, String> table, int columnKey) {
        for (int i = table.columnKeySet().size() - 1; i >= columnKey; --i) {
            Map column = table.column((Object)i);
            Iterator i$ = column.keySet().iterator();
            while (i$.hasNext()) {
                int j = (Integer)i$.next();
                table.put((Object)j, (Object)(i + 1), column.get(j));
            }
        }
        table.column((Object)columnKey).clear();
    }
}

