/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.base;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.servlet.Servlet;
import org.junit.Before;
import org.kurento.repository.Repository;
import org.kurento.repository.RepositoryApiConfiguration;
import org.kurento.repository.RepositoryHttpPlayer;
import org.kurento.repository.RepositoryItem;
import org.kurento.repository.internal.http.RepositoryHttpServlet;
import org.kurento.test.base.BrowserTest;
import org.kurento.test.base.KurentoClientBrowserTest;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.browser.WebRtcTestPage;
import org.kurento.test.config.Protocol;
import org.kurento.test.services.WebServerService;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

public class RepositoryMongoTest
extends KurentoClientBrowserTest<WebRtcTestPage> {
    public Repository repository;

    @Before
    public void setupRepository() {
        webServer.setWebServerClass(RepositoryWebServer.class);
        this.repository = (Repository)webServer.getContext().getBean("repository");
    }

    public String getMediaUrl(Protocol protocol, String nameMedia) {
        String mediaUrl = "";
        switch (protocol) {
            case HTTP: {
                mediaUrl = (Object)((Object)Protocol.HTTP) + "://" + RepositoryMongoTest.getTestFilesHttpPath();
                break;
            }
            case FILE: {
                mediaUrl = (Object)((Object)Protocol.FILE) + "://" + RepositoryMongoTest.getTestFilesDiskPath();
                break;
            }
            case S3: {
                mediaUrl = (Object)((Object)Protocol.S3) + "://" + RepositoryMongoTest.getTestFilesS3Path();
                break;
            }
            case MONGODB: {
                List repositoryItem = this.repository.findRepositoryItemsByAttRegex("file", nameMedia);
                RepositoryHttpPlayer repositoryPlayer = ((RepositoryItem)repositoryItem.get(0)).createRepositoryHttpPlayer();
                mediaUrl = repositoryPlayer.getURL();
                return mediaUrl;
            }
            default: {
                throw new RuntimeException((Object)((Object)protocol) + "is not supported in this test.");
            }
        }
        return mediaUrl + nameMedia;
    }

    @ComponentScan(basePackageClasses={RepositoryItem.class})
    public static class RepositoryWebServer
    extends WebServerService.WebServer {
        @Bean
        public RepositoryHttpServlet repositoryHttpServlet() {
            return new RepositoryHttpServlet();
        }

        @Bean
        public ServletRegistrationBean repositoryServletRegistrationBean(RepositoryHttpServlet repositoryHttpServlet) {
            ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)repositoryHttpServlet, new String[]{"/repository_servlet/*"});
            servletRegistrationBean.setLoadOnStartup(1);
            return servletRegistrationBean;
        }

        @Bean
        public RepositoryApiConfiguration repositoryApiConfiguration() throws UnknownHostException {
            BrowserTest.log.debug("Repository for playing test");
            RepositoryApiConfiguration config = new RepositoryApiConfiguration();
            config.setWebappPublicUrl("http://" + InetAddress.getLocalHost().getHostAddress() + ":" + WebServerService.getAppHttpPort() + "/");
            config.setMongoDatabaseName("testfiles");
            config.setMongoUrlConnection((Object)((Object)Protocol.MONGODB) + "://" + KurentoTest.getTestFilesMongoPath());
            config.setRepositoryType(RepositoryApiConfiguration.RepoType.MONGODB);
            return config;
        }
    }
}

