/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.browser;

import org.kurento.test.base.KurentoTest;

public enum WebRtcCandidateType {
    HOST,
    RELAY,
    SRFLX,
    ALL,
    PRFLX;


    public static WebRtcCandidateType find(String candidateType) {
        for (WebRtcCandidateType v : WebRtcCandidateType.values()) {
            if (!v.toString().equals(candidateType)) continue;
            return v;
        }
        return null;
    }

    public String getJsFunction() {
        switch (this) {
            case RELAY: {
                String url = KurentoTest.getTestIceServerUrl();
                String username = KurentoTest.getTestIceServerUsername();
                String password = KurentoTest.getTestIceServerCredential();
                return "setIceServers('" + url + "', '" + username + "', '" + password + "');";
            }
            case SRFLX: {
                String url = KurentoTest.getTestStunServerUrl();
                return "setIceServers('" + url + "', '', '');";
            }
            case HOST: 
            case ALL: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        switch (this) {
            case HOST: {
                return "host";
            }
            case RELAY: {
                return "relay";
            }
            case SRFLX: {
                return "srflx";
            }
            case PRFLX: {
                return "prflx";
            }
            case ALL: {
                return "all";
            }
        }
        throw new IllegalArgumentException();
    }
}

