/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.DockerClientException;
import com.github.dockerjava.api.NotFoundException;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.Statistics;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.browser.BrowserType;
import org.kurento.test.docker.FirstObjectResultCallback;
import org.kurento.test.utils.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Docker
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Docker.class);
    private static final String DOCKER_SERVER_URL_PROPERTY = "docker.server.url";
    private static final String DOCKER_SERVER_URL_DEFAULT = "http://localhost:2375";
    public static final String DOCKER_CONTAINER_NAME_PROPERTY = "docker.container.name";
    private static final int WAIT_CONTAINER_POLL_TIME = 200;
    private static final int WAIT_CONTAINER_POLL_TIMEOUT = 10;
    private static Docker singleton = null;
    private static Boolean isRunningInContainer;
    private static String hostIp;
    private DockerClient client;
    private String containerName;
    private String dockerServerUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Docker getSingleton(String dockerServerUrl) {
        if (singleton != null) return singleton;
        Class<Docker> clazz = Docker.class;
        synchronized (Docker.class) {
            if (singleton != null) return singleton;
            singleton = new Docker(dockerServerUrl);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public static Docker getSingleton() {
        return Docker.getSingleton(PropertiesManager.getProperty((String)DOCKER_SERVER_URL_PROPERTY, (String)Docker.getDefaultDockerServerUrl()));
    }

    private static String getDefaultDockerServerUrl() {
        if (Docker.isRunningInContainerInternal()) {
            return "http://" + Docker.getHostIp() + ":2375";
        }
        return DOCKER_SERVER_URL_DEFAULT;
    }

    public Docker(String dockerServerUrl) {
        this.dockerServerUrl = dockerServerUrl;
    }

    public boolean isRunningInContainer() {
        return Docker.isRunningInContainerInternal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized boolean isRunningInContainerInternal() {
        if (isRunningInContainer != null) return isRunningInContainer;
        try (BufferedReader br = Files.newBufferedReader(Paths.get("/proc/1/cgroup", new String[0]), StandardCharsets.UTF_8);){
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.endsWith("/")) continue;
                boolean bl = true;
                return bl;
            }
            isRunningInContainer = false;
            return isRunningInContainer;
        }
        catch (IOException e) {
            isRunningInContainer = false;
        }
        return isRunningInContainer;
    }

    private static synchronized String getHostIp() {
        if (hostIp == null) {
            if (Docker.isRunningInContainerInternal()) {
                try {
                    String ipRoute = Shell.runAndWait("sh", "-c", "/sbin/ip route");
                    String[] tokens = ipRoute.split("\\s");
                    hostIp = tokens[2];
                }
                catch (Exception e) {
                    throw new DockerClientException("Exception executing /sbin/ip route", (Throwable)e);
                }
            } else {
                hostIp = "127.0.0.1";
            }
        }
        log.debug("Host IP is {}", (Object)hostIp);
        return hostIp;
    }

    public boolean isRunningContainer(String containerName) {
        boolean isRunning = false;
        if (this.existsContainer(containerName)) {
            isRunning = this.inspectContainer(containerName).getState().isRunning();
            log.trace("Container {} is running: {}", (Object)containerName, (Object)isRunning);
        }
        return isRunning;
    }

    public boolean existsContainer(String containerName) {
        boolean exists = true;
        try {
            this.getClient().inspectContainerCmd(containerName).exec();
            log.trace("Container {} already exist", (Object)containerName);
        }
        catch (NotFoundException e) {
            log.trace("Container {} does not exist", (Object)containerName);
            exists = false;
        }
        return exists;
    }

    public boolean existsImage(String imageName) {
        boolean exists = true;
        try {
            this.getClient().inspectImageCmd(imageName).exec();
            log.trace("Image {} exists", (Object)imageName);
        }
        catch (NotFoundException e) {
            log.trace("Image {} does not exist", (Object)imageName);
            exists = false;
        }
        return exists;
    }

    public void createContainer(String imageId, String containerName, boolean mountFolders, String ... env) {
        if (!this.existsContainer(containerName)) {
            this.pullImageIfNecessary(imageId, false);
            log.debug("Creating container {}", (Object)containerName);
            CreateContainerCmd createContainerCmd = this.getClient().createContainerCmd(imageId).withName(containerName).withEnv(env);
            if (mountFolders) {
                this.mountDefaultFolders(createContainerCmd);
            }
            createContainerCmd.exec();
            log.debug("Container {} started...", (Object)containerName);
        } else {
            log.debug("Container {} already exists", (Object)containerName);
        }
    }

    public void mountDefaultFolders(CreateContainerCmd createContainerCmd) {
        this.mountDefaultFolders(createContainerCmd, null);
    }

    public void mountDefaultFolders(CreateContainerCmd createContainerCmd, String configFilePath) {
        if (this.isRunningInContainer()) {
            createContainerCmd.withVolumesFrom(new VolumesFrom[]{new VolumesFrom(this.getContainerId())});
            if (configFilePath != null) {
                String workspace = PropertiesManager.getProperty((String)"test.workspace", (String)"/tmp");
                String workspaceHost = PropertiesManager.getProperty((String)"test.workspace.host", (String)"/tmp");
                String hostConfigFilePath = Paths.get(workspaceHost, new String[0]).resolve(Paths.get(workspace, new String[0]).relativize(Paths.get(configFilePath, new String[0]))).toString();
                log.debug("Config file volume {}", (Object)hostConfigFilePath);
                Volume configVol = new Volume("/opt/selenium/config.json");
                createContainerCmd.withVolumes(new Volume[]{configVol}).withBinds(new Bind[]{new Bind(hostConfigFilePath, configVol)});
            }
        } else {
            String testFilesPath = KurentoTest.getTestFilesDiskPath();
            Volume testFilesVolume = new Volume(testFilesPath);
            String workspacePath = Paths.get(KurentoTest.getTestDir(), new String[0]).toAbsolutePath().toString();
            Volume workspaceVolume = new Volume(workspacePath);
            Volume configVol = new Volume("/opt/selenium/config.json");
            if (configFilePath != null) {
                createContainerCmd.withVolumes(new Volume[]{testFilesVolume, workspaceVolume, configVol}).withBinds(new Bind[]{new Bind(testFilesPath, testFilesVolume, AccessMode.ro), new Bind(workspacePath, workspaceVolume, AccessMode.rw), new Bind(configFilePath, configVol)});
            } else {
                createContainerCmd.withVolumes(new Volume[]{testFilesVolume, workspaceVolume}).withBinds(new Bind[]{new Bind(testFilesPath, testFilesVolume, AccessMode.ro), new Bind(workspacePath, workspaceVolume, AccessMode.rw)});
            }
        }
    }

    public void pullImageIfNecessary(String imageId, boolean force) {
        if (force || !this.existsImage(imageId)) {
            log.debug("Pulling Docker image {} ... please be patient until the process finishes", (Object)imageId);
            ((PullImageResultCallback)this.getClient().pullImageCmd(imageId).exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
            log.debug("Image {} downloaded", (Object)imageId);
        } else {
            log.debug("Image {} already exists", (Object)imageId);
        }
    }

    public InspectContainerResponse inspectContainer(String containerName) {
        return this.getClient().inspectContainerCmd(containerName).exec();
    }

    public void startContainer(String containerName) {
        if (!this.isRunningContainer(containerName)) {
            log.debug("Starting container {}", (Object)containerName);
            this.getClient().startContainerCmd(containerName).exec();
            log.debug("Started container {}", (Object)containerName);
        } else {
            log.debug("Container {} is already started", (Object)containerName);
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.getClient().close();
            }
            catch (IOException e) {
                log.error("Exception closing Docker client", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerClient getClient() {
        if (this.client == null) {
            Docker docker = this;
            synchronized (docker) {
                if (this.client == null) {
                    this.client = DockerClientBuilder.getInstance((String)this.dockerServerUrl).build();
                }
            }
        }
        return this.client;
    }

    public void stopContainers(String ... containerNames) {
        for (String containerName : containerNames) {
            this.stopContainer(containerName);
        }
    }

    public void stopContainer(String containerName) {
        if (this.isRunningContainer(containerName)) {
            log.debug("Stopping container {}", (Object)containerName);
            this.getClient().stopContainerCmd(containerName).exec();
        } else {
            log.debug("Container {} is not running", (Object)containerName);
        }
    }

    public void removeContainers(String ... containerNames) {
        for (String containerName : containerNames) {
            this.removeContainer(containerName);
        }
    }

    public void removeContainer(String containerName) {
        if (this.existsContainer(containerName)) {
            log.debug("Removing container {}", (Object)containerName);
            boolean removed = false;
            int count = 0;
            do {
                try {
                    this.getClient().removeContainerCmd(containerName).withRemoveVolumes(true).exec();
                    log.debug("*** Only for debuggin: After Docker.removeContainer({}). Times: {}", (Object)containerName, (Object)(++count));
                    removed = true;
                }
                catch (Throwable e) {
                    if (count == 10) {
                        log.error("*** Only for debugging: Exception {} -> Docker.removeContainer({}).", (Object)containerName, (Object)e.getMessage());
                    }
                    try {
                        log.debug("Waiting for removing {}. Times: {}", (Object)containerName, (Object)count);
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } while (!removed && count <= 10);
        }
    }

    public void stopAndRemoveContainer(String containerName) {
        this.stopContainer(containerName);
        this.removeContainer(containerName);
    }

    public void stopAndRemoveContainers(String ... containerNames) {
        for (String containerName : containerNames) {
            this.stopAndRemoveContainer(containerName);
        }
    }

    public synchronized String startHub(String hubName, String imageId) {
        this.createContainer(imageId, hubName, false, "GRID_TIMEOUT=3600000");
        this.startContainer(hubName);
        String hubIp = this.inspectContainer(hubName).getNetworkSettings().getIpAddress();
        log.debug("Hub started on IP address: {}", (Object)hubIp);
        return hubIp;
    }

    public void startNode(String id, BrowserType browserType, String nodeName, String imageId, String hubIp) {
        if (!this.existsContainer(nodeName)) {
            this.pullImageIfNecessary(imageId, false);
            log.debug("Creating container {}", (Object)nodeName);
            CreateContainerCmd createContainerCmd = this.getClient().createContainerCmd(imageId).withName(nodeName);
            String configFile = this.generateConfigFile(id, browserType);
            this.mountDefaultFolders(createContainerCmd, configFile);
            createContainerCmd.withEnv(new String[]{"HUB_PORT_4444_TCP_ADDR=" + hubIp});
            createContainerCmd.exec();
            log.debug("Container {} started...", (Object)nodeName);
        } else {
            log.debug("Container {} already exists", (Object)nodeName);
        }
        this.startContainer(nodeName);
    }

    public void startNode(String id, BrowserType browserType, String nodeName, String imageId, String hubIp, String containerIp) {
        if (!this.existsContainer(nodeName)) {
            this.pullImageIfNecessary(imageId, false);
            log.debug("Creating container {}", (Object)nodeName);
            CreateContainerCmd createContainerCmd = this.getClient().createContainerCmd(imageId).withName(nodeName);
            String configFile = this.generateConfigFile(id, browserType);
            this.mountDefaultFolders(createContainerCmd, configFile);
            createContainerCmd.withNetworkMode("none");
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("KurentoDnat", "true");
            labels.put("Transport", PropertiesManager.getProperty((String)"test.selenium.transport"));
            labels.put("IpAddress", containerIp);
            createContainerCmd.withLabels(labels);
            createContainerCmd.withEnv(new String[]{"HUB_PORT_4444_TCP_ADDR=" + hubIp, "REMOTE_HOST=http://" + containerIp + ":5555"});
            createContainerCmd.exec();
            log.debug("Container {} started...", (Object)nodeName);
        } else {
            log.debug("Container {} already exists", (Object)nodeName);
        }
        this.startContainer(nodeName);
    }

    private String generateConfigFile(String id, BrowserType browserType) {
        try {
            String browserName2;
            String browserName1;
            String workspace = PropertiesManager.getProperty((String)"test.workspace", (String)"/tmp");
            Path config = Files.createTempFile(Paths.get(workspace, new String[0]), "", "-config.json", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--")));
            if (browserType == BrowserType.CHROME) {
                browserName1 = "*googlechrome";
                browserName2 = "chrome";
            } else if (browserType == BrowserType.FIREFOX) {
                browserName1 = "*firefox";
                browserName2 = "firefox";
            } else {
                throw new KurentoException("Unsupported browser type: " + (Object)((Object)browserType));
            }
            try (BufferedWriter w = Files.newBufferedWriter(config, StandardCharsets.UTF_8, new OpenOption[0]);){
                w.write("{\n  \"capabilities\": [\n    {\n      \"browserName\": \"" + browserName1 + "\",\n" + "      \"maxInstances\": 1,\n" + "      \"seleniumProtocol\": \"Selenium\",\n" + "      \"applicationName\": \"" + id + "\"\n" + "    },\n" + "    {\n" + "      \"browserName\": \"" + browserName2 + "\",\n" + "      \"maxInstances\": 1,\n" + "      \"seleniumProtocol\": \"WebDriver\",\n" + "      \"applicationName\": \"" + id + "\"\n" + "    }\n" + "  ],\n" + "  \"configuration\": {\n" + "    \"proxy\": \"org.openqa.grid.selenium.proxy.DefaultRemoteProxy\",\n" + "    \"maxSession\": 1,\n" + "    \"port\": 5555,\n" + "    \"register\": true,\n" + "    \"registerCycle\": 5000\n" + "  }\n" + "}");
            }
            return config.toAbsolutePath().toString();
        }
        catch (IOException e) {
            throw new KurentoException("Exception creating config file", (Throwable)e);
        }
    }

    public void startAndWaitNode(String id, BrowserType browserType, String nodeName, String imageId, String hubIp) {
        this.startNode(id, browserType, nodeName, imageId, hubIp);
        this.waitForContainer(nodeName);
    }

    public void startAndWaitNode(String id, BrowserType browserType, String nodeName, String imageId, String hubIp, String containerIp) {
        this.startNode(id, browserType, nodeName, imageId, hubIp, containerIp);
        this.waitForContainer(nodeName);
    }

    public String startAndWaitHub(String hubName, String imageId) {
        String hubIp = this.startHub(hubName, imageId);
        this.waitForContainer(hubName);
        return hubIp;
    }

    public void waitForContainer(String containerName) {
        boolean isRunning = false;
        long timeoutMs = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        do {
            if (isRunning = this.isRunningContainer(containerName)) continue;
            if (System.currentTimeMillis() > timeoutMs) {
                throw new KurentoException("Timeout of 10 seconds waiting for container " + containerName);
            }
            try {
                log.debug("Container {} is not still running ... waiting {} ms", (Object)containerName, (Object)200);
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                log.error("Exception waiting for hub");
            }
        } while (!isRunning);
    }

    public String getContainerId() {
        try {
            BufferedReader br = Files.newBufferedReader(Paths.get("/proc/self/cgroup", new String[0]), StandardCharsets.UTF_8);
            String line = null;
            while ((line = br.readLine()) != null) {
                log.debug(line);
                if (!line.contains("docker")) continue;
                return line.substring(line.lastIndexOf(47) + 1, line.length());
            }
            throw new DockerClientException("Exception obtaining containerId. The file /proc/self/cgroup doesn't contain a line with 'docker'");
        }
        catch (IOException e) {
            throw new DockerClientException("Exception obtaining containerId. Exception reading file /proc/self/cgroup", (Throwable)e);
        }
    }

    public String getContainerName() {
        if (!this.isRunningInContainer()) {
            throw new DockerClientException("Can't obtain container name if not running in container");
        }
        if (this.containerName == null) {
            this.containerName = System.getProperty(DOCKER_CONTAINER_NAME_PROPERTY);
            if (this.containerName == null) {
                String containerId = this.getContainerId();
                this.containerName = this.inspectContainer(containerId).getName();
                this.containerName = this.containerName.substring(1);
            }
        }
        return this.containerName;
    }

    public String getContainerIpAddress() {
        if (this.isRunningInContainer()) {
            String ipAddr = this.inspectContainer(this.getContainerName()).getNetworkSettings().getIpAddress();
            log.debug("Docker container IP address {}", (Object)ipAddr);
            return ipAddr;
        }
        throw new DockerClientException("Can't obtain container ip address if not running in container");
    }

    public String getHostIpForContainers() {
        try {
            Enumeration<NetworkInterface> b = NetworkInterface.getNetworkInterfaces();
            while (b.hasMoreElements()) {
                NetworkInterface iface = b.nextElement();
                if (!iface.getName().contains("docker")) continue;
                for (InterfaceAddress f : iface.getInterfaceAddresses()) {
                    if (!f.getAddress().isSiteLocalAddress()) continue;
                    String addr = f.getAddress().toString();
                    log.debug("Host IP for container is {}", (Object)addr);
                    return addr;
                }
            }
        }
        catch (SocketException e) {
            log.warn("Exception getting docker address", (Throwable)e);
        }
        return null;
    }

    public String generateIpAddressForContainer() {
        String baseIpAddress = "172.17";
        String ipAddress = "";
        Random random = new Random();
        String output = "";
        do {
            Integer x = random.nextInt(240) + 1;
            Integer y = random.nextInt(240) + 1;
            ipAddress = baseIpAddress + "." + x + "." + y;
        } while (!(output = Shell.runAndWaitString("ping -c 1 " + ipAddress)).contains("Destination Host Unreachable"));
        log.debug("Ip address generated: {}", (Object)ipAddress);
        return ipAddress;
    }

    public void downloadLog(String containerName, Path file) throws IOException {
        LogContainerRetrieverCallback loggingCallback = new LogContainerRetrieverCallback(file);
        this.getClient().logContainerCmd(containerName).withStdErr(true).withStdOut(true).exec((ResultCallback)loggingCallback);
        try {
            loggingCallback.awaitCompletion();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while downloading logs for container {}", (Object)containerName);
        }
    }

    public Statistics getStatistics(String containerId) {
        FirstObjectResultCallback resultCallback = new FirstObjectResultCallback();
        try {
            return (Statistics)((FirstObjectResultCallback)this.getClient().statsCmd().withContainerId(containerId).exec(resultCallback)).waitForObject();
        }
        catch (InterruptedException e) {
            throw new KurentoException("Interrupted while waiting for statistics");
        }
    }

    public String execCommand(String containerId, String ... command) {
        ExecCreateCmdResponse exec = (ExecCreateCmdResponse)this.client.execCreateCmd(containerId).withCmd(command).withTty(false).withAttachStdin(true).withAttachStdout(true).withAttachStderr(true).exec();
        InputStream execInputStream = this.client.execStartCmd(exec.getId()).exec();
        String output = null;
        try {
            output = IOUtils.toString((InputStream)execInputStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            log.warn("Exception executing command {} on container {}", new Object[]{Arrays.toString(command), containerId, e});
        }
        return output;
    }

    public static class LogContainerRetrieverCallback
    extends LogContainerResultCallback {
        private PrintWriter pw;

        public LogContainerRetrieverCallback(Path file) throws IOException {
            this.pw = new PrintWriter(Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));
        }

        public void onNext(Frame frame) {
            this.pw.append(new String(frame.getPayload()));
            super.onNext(frame);
        }

        public void onComplete() {
            this.pw.close();
            super.onComplete();
        }
    }
}

