/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.grid;

import org.openqa.grid.internal.utils.GridHubConfiguration;
import org.openqa.grid.web.Hub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridHub {
    public static Logger log = LoggerFactory.getLogger(GridHub.class);
    private static final int DEFAULT_TIMEOUT = 60;
    private String bindIp = "0.0.0.0";
    private int port;
    private int timeout;
    private Hub hub;

    public GridHub(int port) {
        this.port = port;
        this.timeout = 60;
    }

    public void start() throws Exception {
        GridHubConfiguration config = new GridHubConfiguration();
        config.setHost(this.bindIp);
        config.setPort(this.port);
        config.setTimeout(this.getTimeout());
        this.hub = new Hub(config);
        log.debug("Starting hub on {}:{}", (Object)this.bindIp, (Object)this.port);
        this.hub.start();
    }

    public void stop() throws Exception {
        if (this.hub != null) {
            this.hub.stop();
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

