/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.latency;

import java.awt.Color;
import java.text.SimpleDateFormat;
import org.kurento.test.browser.WebPage;
import org.kurento.test.latency.ChangeColorEvent;
import org.kurento.test.latency.ChangeColorObservable;
import org.kurento.test.latency.VideoTag;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorTrigger
implements Runnable {
    public Logger log = LoggerFactory.getLogger(ColorTrigger.class);
    private VideoTag videoTag;
    private WebPage testClient;
    private Color color = Color.BLACK;
    private ChangeColorObservable observable;
    private long timeoutSeconds;

    public ColorTrigger(VideoTag videoTag, WebPage testClient, ChangeColorObservable observable, long timeoutSeconds) {
        this.videoTag = videoTag;
        this.testClient = testClient;
        this.observable = observable;
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.testClient.waitColor(this.timeoutSeconds, this.videoTag, this.color);
                    Color currentColor = this.testClient.getCurrentColor(this.videoTag);
                    if (currentColor.equals(this.color)) continue;
                    long changeTimeMilis = this.testClient.getCurrentTime(this.videoTag);
                    String parsedtime = new SimpleDateFormat("mm:ss.SSS").format(changeTimeMilis);
                    this.log.debug("Color changed on {} from {} to {} at minute {}", new Object[]{this.videoTag, this.color, currentColor, parsedtime});
                    this.color = currentColor;
                    ChangeColorEvent event = new ChangeColorEvent(this.videoTag, changeTimeMilis, this.color);
                    this.observable.detectedColorChange(event);
                }
            }
            catch (WebDriverException currentColor) {
                continue;
            }
            catch (Exception e) {
                return;
            }
            break;
        }
    }
}

