/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.latency;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;
import org.kurento.test.latency.LatencyRegistry;

public class ChartWriter {
    private XYDataset dataset;
    private String xAxisLabel;
    private String yAxisLabel;
    private String chartTitle;

    public ChartWriter(Map<Long, LatencyRegistry> latencyMap, String seriestTitle) {
        this(latencyMap, seriestTitle, "Latency Control", "Remote Tag Time (s)", "Lantecy (ms)");
    }

    public ChartWriter(Map<Long, LatencyRegistry> latencyMap, String seriesTitle, String chartTitle, String xAxisLabel, String yAxisLabel) {
        XYSeries series = new XYSeries((Comparable)((Object)seriesTitle));
        for (long time : latencyMap.keySet()) {
            series.add((double)time, (double)Math.abs(latencyMap.get(time).getLatency()));
        }
        this.dataset = new XYSeriesCollection();
        ((XYSeriesCollection)this.dataset).addSeries(series);
        this.xAxisLabel = xAxisLabel;
        this.yAxisLabel = yAxisLabel;
        this.chartTitle = chartTitle;
    }

    public void drawChart(String filename, int width, int height) throws IOException {
        NumberAxis xAxis = new NumberAxis(this.xAxisLabel);
        NumberAxis yAxis = new NumberAxis(this.yAxisLabel);
        XYSplineRenderer renderer = new XYSplineRenderer();
        XYPlot plot = new XYPlot(this.dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(4.0, 4.0, 4.0, 4.0));
        JFreeChart chart = new JFreeChart(this.chartTitle, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        ChartUtilities.applyCurrentTheme((JFreeChart)chart);
        ChartPanel chartPanel = new ChartPanel(chart, false);
        BufferedImage bi = new BufferedImage(width, height, 4);
        Graphics graphics = bi.getGraphics();
        chartPanel.setBounds(0, 0, width, height);
        chartPanel.paint(graphics);
        ImageIO.write((RenderedImage)bi, "png", new File(filename));
    }
}

