/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.mediainfo;

import com.google.common.base.Strings;
import java.io.File;
import org.junit.Assert;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.config.Protocol;
import org.kurento.test.mediainfo.MediaInfo;
import org.kurento.test.utils.Shell;

public class AssertMedia {
    public static void assertCodecs(String pathToMedia, String expectedVideoCodec, String expectedAudioCodec) {
        MediaInfo info = AssertMedia.getInfoByPath(pathToMedia);
        String videoFormat = info.get(MediaInfo.StreamKind.Video, 0, "Format", MediaInfo.InfoKind.Text, MediaInfo.InfoKind.Name);
        String audioFormat = info.get(MediaInfo.StreamKind.Audio, 0, "Format", MediaInfo.InfoKind.Text, MediaInfo.InfoKind.Name);
        info.close();
        if (expectedVideoCodec != null) {
            Assert.assertEquals((String)("Wrong video codec in " + pathToMedia), (Object)expectedVideoCodec, (Object)videoFormat);
        }
        if (expectedAudioCodec != null) {
            Assert.assertEquals((String)("Wrong audio codec in " + pathToMedia), (Object)expectedAudioCodec, (Object)audioFormat);
        }
    }

    public static void assertDuration(String pathToMedia, double expectedDurationMs, double thresholdMs) {
        AssertMedia.assertAudioDuration(pathToMedia, expectedDurationMs, thresholdMs);
        AssertMedia.assertGeneralDuration(pathToMedia, expectedDurationMs, thresholdMs);
    }

    public static void assertAudioDuration(String pathToMedia, double expectedDurationMs, double thresholdMs) {
        MediaInfo info = AssertMedia.getInfoByPath(pathToMedia);
        String audioDuration = info.get(MediaInfo.StreamKind.Audio, 0, "Duration", MediaInfo.InfoKind.Text, MediaInfo.InfoKind.Name);
        info.close();
        Assert.assertFalse((String)("Audio duration is empty or null in " + pathToMedia), (boolean)Strings.isNullOrEmpty((String)audioDuration));
        long audioDurationMs = Long.parseLong(audioDuration);
        double difference = Math.abs((double)audioDurationMs - expectedDurationMs);
        Assert.assertTrue((String)("Wrong audio duration (expected=" + expectedDurationMs + " ms, real= " + audioDurationMs + " ms) in " + pathToMedia), (difference < thresholdMs ? 1 : 0) != 0);
    }

    public static void assertGeneralDuration(String pathToMedia, double expectedDurationMs, double thresholdMs) {
        MediaInfo info = AssertMedia.getInfoByPath(pathToMedia);
        String generalDuration = info.get(MediaInfo.StreamKind.General, 0, "Duration", MediaInfo.InfoKind.Text, MediaInfo.InfoKind.Name);
        info.close();
        Assert.assertFalse((String)("General duration is empty or null in " + pathToMedia), (boolean)Strings.isNullOrEmpty((String)generalDuration));
        long generalDurationMs = Long.parseLong(generalDuration);
        double difference = Math.abs((double)generalDurationMs - expectedDurationMs);
        Assert.assertTrue((String)("Wrong general duration (expected=" + expectedDurationMs + " ms, real= " + generalDurationMs + " ms) in " + pathToMedia), (difference < thresholdMs ? 1 : 0) != 0);
    }

    private static MediaInfo getInfoByPath(String pathToMedia) {
        MediaInfo info = new MediaInfo();
        String[] pathToMedia_ = pathToMedia.split("://");
        String protocol = "";
        String path = "";
        if (pathToMedia_.length > 1) {
            protocol = pathToMedia_[0];
            path = pathToMedia_[1];
        } else {
            String recordDefaultPath = KurentoTest.getRecordDefaultPath();
            if (recordDefaultPath != null) {
                String[] defaultPathToMedia_ = recordDefaultPath.split("://");
                protocol = defaultPathToMedia_[0];
                String pathStart = defaultPathToMedia_[1];
                path = pathStart + pathToMedia_[0];
            }
        }
        if (Protocol.FILE.toString().equals(protocol)) {
            info.open(new File(path));
            return info;
        }
        if (!Protocol.HTTP.toString().equals(protocol) && !Protocol.HTTPS.toString().equals(protocol)) {
            if (Protocol.S3.toString().equals(protocol)) {
                pathToMedia = protocol + "://" + path;
                String pathDownload = KurentoTest.getDefaultOutputFolder().getAbsolutePath() + File.separator + path;
                String pathOut = KurentoTest.getDefaultOutputFolder().getAbsolutePath() + File.separator + path.replace("/test", "/ffmpeg");
                Shell.runAndWaitString("aws s3 cp " + pathToMedia + " " + pathDownload);
                Shell.runAndWaitString("ffmpeg -y -i " + pathDownload + " -c:a copy -c:v copy -map 0 " + pathOut);
                info.open(new File(pathOut));
                return info;
            }
            if (Protocol.MONGODB.toString().equals(protocol)) {
                // empty if block
            }
        }
        return info;
    }
}

