/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.browser;

import com.github.dockerjava.api.model.ContainerNetwork;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.test.base.KurentoTest;
import org.kurento.test.browser.BrowserType;
import org.kurento.test.docker.Docker;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerBrowserManager {
    public static final int REMOTE_WEB_DRIVER_CREATION_MAX_RETRIES = 3;
    private static final int REMOTE_WEB_DRIVER_CREATION_TIMEOUT_S = 300;
    private static final int WAIT_URL_POLL_TIME_MS = 200;
    private static final int WAIT_URL_TIMEOUT_SEC = 10;
    private static Logger log = LoggerFactory.getLogger(DockerBrowserManager.class);
    private Docker docker = Docker.getSingleton();
    private ExecutorService exec = Executors.newFixedThreadPool(10);
    private ConcurrentMap<String, DockerBrowser> browsers = new ConcurrentHashMap<String, DockerBrowser>();
    private boolean record;
    private Path downloadLogsPath;

    public DockerBrowserManager() {
        this.docker = Docker.getSingleton();
        this.record = PropertiesManager.getProperty((String)"test.selenium.record", (boolean)true);
    }

    public void setDownloadLogsPath(Path path) {
        this.downloadLogsPath = path;
    }

    public RemoteWebDriver createDockerDriver(String id, DesiredCapabilities capabilities) {
        DockerBrowser browser = new DockerBrowser(id, capabilities);
        if (this.browsers.putIfAbsent(id, browser) != null) {
            throw new KurentoException("Browser with id " + id + " already exists");
        }
        browser.create();
        return browser.getRemoteWebDriver();
    }

    public void closeDriver(String id) {
        DockerBrowser browser = (DockerBrowser)this.browsers.remove(id);
        if (browser == null) {
            log.warn("Browser " + id + " does not exists");
            return;
        }
        browser.close();
    }

    private String calculateBrowserImageName(DesiredCapabilities capabilities) {
        String browserName = capabilities.getBrowserName();
        if (browserName.equals(DesiredCapabilities.chrome().getBrowserName())) {
            return PropertiesManager.getProperty((String)"docker.node.chrome.image", (String)"elastestbrowsers/chrome:latest");
        }
        if (browserName.equals(DesiredCapabilities.firefox().getBrowserName())) {
            return PropertiesManager.getProperty((String)"docker.node.firefox.image", (String)"elastestbrowsers/firefox:latest");
        }
        throw new RuntimeException("Browser " + browserName + " is not supported currently for Docker scope");
    }

    private void downloadLogsForContainer(String container, String logName) {
        if (this.downloadLogsPath != null) {
            try {
                String logFileName = new File(KurentoTest.getDefaultOutputFile("-" + logName + "-container.log")).getAbsolutePath();
                Path logFile = this.downloadLogsPath.resolve(logFileName);
                if (Files.exists(logFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
                }
                log.debug("Downloading log for container {} in file {}", (Object)container, (Object)logFile.toAbsolutePath());
                this.docker.downloadLog(container, logFile);
            }
            catch (IOException e) {
                log.warn("Exception writing logs for container {}", (Object)container, (Object)e);
            }
        }
    }

    private class DockerBrowser {
        private String id;
        private String browserContainerName;
        private String browserContainerIp;
        private DesiredCapabilities capabilities;
        private RemoteWebDriver driver;

        public DockerBrowser(String id, DesiredCapabilities capabilities) {
            this.id = id;
            this.capabilities = capabilities;
            this.calculateContainerNames();
        }

        private void calculateContainerNames() {
            this.browserContainerName = this.id;
            if (DockerBrowserManager.this.docker.isRunningInContainer()) {
                String containerName = DockerBrowserManager.this.docker.getContainerName();
                this.browserContainerName = containerName + "-" + this.browserContainerName + "-" + KurentoTest.getTestClassName() + "-" + new Random().nextInt(1000);
            }
        }

        public void create() {
            String nodeImageId = DockerBrowserManager.this.calculateBrowserImageName(this.capabilities);
            BrowserType type = BrowserType.valueOf(this.capabilities.getBrowserName().toUpperCase());
            int numRetries = 0;
            do {
                try {
                    Boolean kmsSelenium = false;
                    if (PropertiesManager.getProperty((String)"test.selenium.dnat") != null && PropertiesManager.getProperty((String)"test.selenium.dnat", (boolean)false)) {
                        kmsSelenium = true;
                    }
                    if (kmsSelenium.booleanValue()) {
                        this.browserContainerIp = DockerBrowserManager.this.docker.generateIpAddressForContainer();
                        DockerBrowserManager.this.docker.startAndWaitNode(this.browserContainerName, type, this.browserContainerName, nodeImageId, DockerBrowserManager.this.record, this.browserContainerIp);
                    } else {
                        DockerBrowserManager.this.docker.startAndWaitNode(this.browserContainerName, type, this.browserContainerName, nodeImageId, DockerBrowserManager.this.record);
                        this.browserContainerIp = ((ContainerNetwork)DockerBrowserManager.this.docker.inspectContainer(this.browserContainerName).getNetworkSettings().getNetworks().values().iterator().next()).getIpAddress();
                    }
                    String driverUrl = String.format("http://%s:4444/wd/hub", this.browserContainerIp);
                    this.waitForUrl(driverUrl);
                    this.createAndWaitRemoteDriver(driverUrl, this.capabilities);
                }
                catch (TimeoutException e) {
                    if (numRetries == 3) {
                        throw new KurentoException("Timeout of 900 seconds trying to create a RemoteWebDriver after3retries");
                    }
                    log.warn("Timeout of {} seconds creating RemoteWebDriver. Retrying {}...", (Object)300, (Object)numRetries);
                    DockerBrowserManager.this.docker.stopAndRemoveContainer(this.browserContainerName, DockerBrowserManager.this.record);
                    this.browserContainerName = this.browserContainerName + "r";
                    this.capabilities.setCapability("applicationName", this.browserContainerName);
                    ++numRetries;
                }
            } while (this.driver == null);
            log.debug("RemoteWebDriver for browser {} created (Version={}, Capabilities={})", new Object[]{this.id, this.driver.getCapabilities().getVersion(), this.driver.getCapabilities()});
        }

        public void waitForUrl(String url) {
            boolean urlAvailable = false;
            long timeoutMs = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
            do {
                try {
                    if (System.currentTimeMillis() > timeoutMs) {
                        throw new KurentoException("Timeout of 10 seconds waiting for URL " + url);
                    }
                    HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
                    connection.setRequestMethod("HEAD");
                    int responseCode = connection.getResponseCode();
                    boolean bl = urlAvailable = responseCode >= 200 && responseCode < 500;
                    if (urlAvailable) continue;
                    log.debug("URL {} is not still available (response {}) ... waiting {} ms", new Object[]{url, responseCode, 200});
                    Thread.sleep(200L);
                }
                catch (ConnectException e) {
                    log.trace("{} is not yet available", (Object)url);
                }
                catch (IOException | InterruptedException e) {
                    log.error("Exception waiting for url {}", (Object)url, (Object)e);
                }
            } while (!urlAvailable);
        }

        private void createAndWaitRemoteDriver(final String driverUrl, final DesiredCapabilities capabilities) throws TimeoutException {
            log.debug("Creating remote driver for browser {} in hub {}", (Object)this.id, (Object)driverUrl);
            int timeoutSeconds = PropertiesManager.getProperty((String)"selenium.max.driver.error", (int)15);
            long timeoutMs = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeoutSeconds);
            do {
                Future<RemoteWebDriver> driverFuture = null;
                try {
                    driverFuture = DockerBrowserManager.this.exec.submit(new Callable<RemoteWebDriver>(){

                        @Override
                        public RemoteWebDriver call() throws Exception {
                            return new RemoteWebDriver(new URL(driverUrl), (Capabilities)capabilities);
                        }
                    });
                    RemoteWebDriver remoteDriver = driverFuture.get(300L, TimeUnit.SECONDS);
                    SessionId sessionId = remoteDriver.getSessionId();
                    log.debug("Created selenium session {} for browser {}", (Object)sessionId, (Object)this.id);
                    this.driver = remoteDriver;
                }
                catch (TimeoutException e) {
                    driverFuture.cancel(true);
                    throw e;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted exception waiting for RemoteWebDriver", e);
                }
                catch (ExecutionException e) {
                    log.warn("Exception creating RemoveWebDriver", (Throwable)e);
                    if (System.currentTimeMillis() > timeoutMs) {
                        throw new KurentoException("Timeout of " + timeoutSeconds + " seconds waiting to create a RemoteWebDriver", e.getCause());
                    }
                    log.debug("Exception creating RemoteWebDriver for browser \"{}\". Retrying...", (Object)this.id, (Object)e.getCause());
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException t) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            } while (this.driver == null);
        }

        public RemoteWebDriver getRemoteWebDriver() {
            return this.driver;
        }

        public void close() {
            DockerBrowserManager.this.downloadLogsForContainer(this.browserContainerName, this.id);
            DockerBrowserManager.this.docker.stopAndRemoveContainer(this.browserContainerName, DockerBrowserManager.this.record);
        }
    }
}

