/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.kurento.test.monitor.KmsMonitor;
import org.kurento.test.monitor.NetInfo;

public class KmsLocalMonitor
extends KmsMonitor {
    public static final String MONITOR_PORT_PROP = "kms.monitor.port";
    public static final int MONITOR_PORT_DEFAULT = 12345;
    public static final int KMS_WAIT_TIMEOUT = 10;
    private static final String ERR = "error: ";
    private double prevTotal = 0.0;
    private double prevIdle = 0.0;
    private int kmsPid = this.getKmsPid();
    private NetInfo initNetInfo;

    public static void main(String[] args) throws InterruptedException, IOException {
        int monitorPort = args.length > 0 ? Integer.parseInt(args[0]) : 12345;
        KmsLocalMonitor monitor = new KmsLocalMonitor();
        ServerSocket server = new ServerSocket(monitorPort);
        System.out.println("Waiting for incoming messages...");
        boolean run = true;
        while (run) {
            Socket socket = server.accept();
            Object result = null;
            BufferedReader input = null;
            ObjectOutputStream output = null;
            try {
                output = new ObjectOutputStream(socket.getOutputStream());
                input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String message = input.readLine();
                if (message != null) {
                    System.out.println("Message received " + message);
                    String[] commands = message.split(" ");
                    switch (commands[0]) {
                        case "measureKms": {
                            result = monitor.measureKms();
                            break;
                        }
                        case "destroy": {
                            result = "Stopping KMS monitor";
                            run = false;
                            break;
                        }
                        default: {
                            result = "error: Invalid command: " + message;
                        }
                    }
                    System.out.println("Sending back message " + result);
                    output.writeObject(result);
                }
                output.close();
                input.close();
                socket.close();
            }
            catch (IOException e) {
                result = ERR + e.getMessage();
                e.printStackTrace();
            }
        }
        server.close();
    }

    @Override
    protected NetInfo getNetInfo() {
        String[] lines;
        NetInfo netInfo = new NetInfo();
        String out = this.runAndWait("/bin/sh", "-c", "cat /proc/net/dev | awk 'NR > 2'");
        for (String line : lines = out.split("\n")) {
            String[] split = line.trim().replaceAll(" +", " ").split(" ");
            String iface = split[0].replace(":", "");
            long rxBytes = Long.parseLong(split[1]);
            long txBytes = Long.parseLong(split[9]);
            netInfo.putNetInfo(iface, rxBytes, txBytes);
        }
        if (this.initNetInfo == null) {
            this.initNetInfo = netInfo;
        }
        netInfo.decrementInitInfo(this.initNetInfo);
        return netInfo;
    }

    @Override
    protected double getCpuUsage() {
        String[] cpu = this.runAndWait("/bin/sh", "-c", "cat /proc/stat | grep '^cpu ' | awk '{print substr($0, index($0, $2))}'").replaceAll("\n", "").split(" ");
        double idle = Double.parseDouble(cpu[3]);
        double total = 0.0;
        for (String s : cpu) {
            total += Double.parseDouble(s);
        }
        double diffIdle = idle - this.prevIdle;
        double diffTotal = total - this.prevTotal;
        double diffUsage = (1000.0 * (diffTotal - diffIdle) / diffTotal + 5.0) / 10.0;
        this.prevTotal = total;
        this.prevIdle = idle;
        return diffUsage;
    }

    @Override
    protected double[] getMem() {
        long totalMem;
        String[] mem = this.runAndWait("free").replaceAll("\n", ",").replaceAll(" +", " ").split(" ");
        long usedMem = Long.parseLong(mem[15]);
        double percetageMem = (double)usedMem / (double)(totalMem = Long.parseLong(mem[7])) * 100.0;
        if (Double.isNaN(percetageMem)) {
            percetageMem = 0.0;
        }
        double[] out = new double[]{usedMem, percetageMem};
        return out;
    }

    @Override
    protected int getKmsPid() {
        String kmsPid;
        System.out.println("Looking for KMS process...");
        boolean reachable = false;
        long endTimeMillis = System.currentTimeMillis() + 10000L;
        do {
            boolean bl = reachable = !(kmsPid = this.runAndWait("/bin/sh", "-c", "ps axf | grep /usr/bin/kurento-media-server | grep -v grep | awk '{print $1}'").replaceAll("\n", "")).equals("");
            if (kmsPid.contains(" ")) {
                throw new RuntimeException("More than one KMS process are started (PIDs:" + kmsPid + ")");
            }
            if (reachable) break;
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        } while (System.currentTimeMillis() <= endTimeMillis);
        if (!reachable) {
            throw new RuntimeException("KMS is not started in the local machine");
        }
        System.out.println("KMS process located in local machine with PID " + kmsPid);
        return Integer.parseInt(kmsPid);
    }

    @Override
    protected int getNumThreads() {
        return Integer.parseInt(this.runAndWait("/bin/sh", "-c", "cat /proc/" + this.kmsPid + "/stat | awk '{print $20}'").replaceAll("\n", ""));
    }

    private String runAndWait(String ... command) {
        try {
            Process p = new ProcessBuilder(command).redirectErrorStream(true).start();
            return this.inputStreamToString(p.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Exception executing command on the shell: " + Arrays.toString(command), e);
        }
    }

    private String inputStreamToString(InputStream in) throws IOException {
        InputStreamReader is = new InputStreamReader(in);
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(is);
        String read = br.readLine();
        while (read != null) {
            sb.append(read);
            read = br.readLine();
            sb.append('\n');
            sb.append(' ');
        }
        return sb.toString().trim();
    }
}

