/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.monitor;

import java.util.ArrayList;
import java.util.List;
import org.kurento.test.monitor.PeerConnectionStats;
import org.kurento.test.monitor.WebRtcEndpointStats;

public class WebRtcStats {
    private String id;
    private PeerConnectionStats pcStats;
    private WebRtcEndpointStats webRtcEpStats;

    public WebRtcStats(String id, PeerConnectionStats peerConnectionStats, WebRtcEndpointStats webRtcEndpointStats) {
        this.id = id;
        this.pcStats = peerConnectionStats;
        this.webRtcEpStats = webRtcEndpointStats;
    }

    public String getId() {
        return this.id;
    }

    public PeerConnectionStats getPeerConnectionStats() {
        return this.pcStats;
    }

    public WebRtcEndpointStats getWebRtcEndpointStats() {
        return this.webRtcEpStats;
    }

    public String toString() {
        return "WebRtcStats [id=" + this.id + ", pcStats=" + this.pcStats + ", webRtcEpStats=" + this.webRtcEpStats + "]";
    }

    public List<String> calculateHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        if (this.pcStats != null) {
            for (String header : this.pcStats.calculateHeaders()) {
                headers.add(header);
            }
        }
        if (this.webRtcEpStats != null) {
            for (String header : this.webRtcEpStats.calculateHeaders()) {
                headers.add(header);
            }
        }
        return headers;
    }

    public List<Object> calculateValues(List<String> headers) {
        List<Object> values = null;
        if (this.pcStats != null) {
            values = this.pcStats.calculateValues(headers);
        }
        if (this.webRtcEpStats != null) {
            List<Object> webRtcValues = this.webRtcEpStats.calculateValues(headers);
            if (values == null) {
                values = webRtcValues;
            } else {
                for (int i = 0; i < values.size(); ++i) {
                    if (values.get(i) != null) continue;
                    values.set(i, webRtcValues.get(i));
                }
            }
        }
        if (values == null) {
            values = new ArrayList<Object>();
            for (int i = 0; i < headers.size(); ++i) {
                values.add(null);
            }
        }
        return values;
    }
}

