/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.test.utils;

import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import org.kurento.test.browser.WebRtcTestPage;
import org.kurento.test.monitor.PeerConnectionStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckAudioTimerTask
extends TimerTask {
    public static Logger log = LoggerFactory.getLogger(CheckAudioTimerTask.class);
    private final CountDownLatch errorContinuityAudiolatch;
    private final WebRtcTestPage page;
    private long lastPacketsReceived = 0L;
    private long lastTimestamp = 0L;
    private long currentPacketsReceived = 0L;
    private long currentTimestamp = 0L;
    private long diffTimestamp = 0L;
    private int count = 0;
    private double packetsNoReceived = 0.0;

    public CheckAudioTimerTask(CountDownLatch errorContinuityAudiolatch, WebRtcTestPage page) {
        this.errorContinuityAudiolatch = errorContinuityAudiolatch;
        this.page = page;
    }

    @Override
    public void run() {
        PeerConnectionStats stats = this.page.getRtcStats();
        if (this.count != 0) {
            this.lastPacketsReceived = this.currentPacketsReceived;
            this.lastTimestamp = this.currentTimestamp;
        }
        this.currentPacketsReceived = this.page.getPeerConnAudioPacketsRecv(stats);
        this.currentTimestamp = this.page.getPeerConnAudioInboundTimestamp(stats);
        this.diffTimestamp = this.currentTimestamp - this.lastTimestamp;
        ++this.count;
        if (this.lastTimestamp != 0L) {
            log.debug("Total audio packets received:{} in {} ms", (Object)(this.currentPacketsReceived - this.lastPacketsReceived), (Object)this.diffTimestamp);
        }
        if (this.currentPacketsReceived - this.lastPacketsReceived == 0L && this.lastTimestamp != 0L) {
            double packetsMustReceive = (double)this.diffTimestamp * 50.0 / 1000.0;
            this.packetsNoReceived += packetsMustReceive;
            log.warn("PacketsNoReceived: {}", (Object)this.packetsNoReceived);
        } else {
            this.packetsNoReceived = 0.0;
        }
        if (this.packetsNoReceived >= 200.0) {
            log.warn("PacketsNoReceived >= 200");
            this.errorContinuityAudiolatch.countDown();
        }
    }
}

