/*
 * Decompiled with CFR 0.152.
 */
package org.kurtymckurt.TestPojo;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.kurtymckurt.TestPojo.PojoBuilderConfiguration;
import org.kurtymckurt.TestPojo.exceptions.NoSuchFieldException;
import org.kurtymckurt.TestPojo.generators.Generator;
import org.kurtymckurt.TestPojo.generators.collections.BlockingDequeGenerator;
import org.kurtymckurt.TestPojo.generators.collections.ListGenerator;
import org.kurtymckurt.TestPojo.generators.collections.MapGenerator;
import org.kurtymckurt.TestPojo.generators.collections.NavigableMapGenerator;
import org.kurtymckurt.TestPojo.generators.collections.NavigableSetGenerator;
import org.kurtymckurt.TestPojo.generators.collections.QueueGenerator;
import org.kurtymckurt.TestPojo.generators.collections.SetGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.BooleanGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.ByteGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.CharacterGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.DateGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.DoubleGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.FloatGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.IntegerGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.LongGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.ShortGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.StringGenerator;
import org.kurtymckurt.TestPojo.generators.time.InstantGenerator;
import org.kurtymckurt.TestPojo.generators.time.LocalDateGenerator;
import org.kurtymckurt.TestPojo.generators.time.LocalDateTimeGenerator;
import org.kurtymckurt.TestPojo.generators.time.OffsetDateTimeGenerator;
import org.kurtymckurt.TestPojo.generators.time.ZonedDateTimeGenerator;
import org.kurtymckurt.TestPojo.limiters.Limiter;
import org.kurtymckurt.TestPojo.providers.ProviderFunction;
import org.kurtymckurt.TestPojo.util.LimiterUtils;
import org.kurtymckurt.TestPojo.util.NullSafeLimits;
import org.kurtymckurt.TestPojo.util.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoBuilder {
    private static final Logger log = LoggerFactory.getLogger(PojoBuilder.class);
    private final List<Generator> generators;
    private final Map<Class, ProviderFunction> providerFunctions;
    private final Class<?> clazz;
    private final Map<Field, Limiter> limiters;
    private final Set<Field> excludedFields;

    public PojoBuilder(PojoBuilderConfiguration configuration) {
        this.clazz = configuration.getClazz();
        this.providerFunctions = new HashMap<Class, ProviderFunction>();
        this.providerFunctions.putAll(configuration.getProviderFunctions());
        this.limiters = new HashMap<Field, Limiter>();
        this.generators = new ArrayList<Generator>();
        this.excludedFields = new HashSet<Field>();
        this.verifyAndBuildExcludedFieldSet(configuration.getExcludedFields());
        this.verifyAndBuildLimitersMap(configuration.getLimiters());
        this.generators.addAll(configuration.getGenerators());
        this.addCoreGenerators();
    }

    private void verifyAndBuildExcludedFieldSet(Set<String> fieldsToExclude) {
        for (String field : fieldsToExclude) {
            String[] fieldNames = field.split("\\.");
            List<String> fieldNameList = Arrays.stream(fieldNames).collect(Collectors.toList());
            this.verifyAndBuildExcludesSetHelper(this.clazz, fieldNameList);
        }
    }

    private void verifyAndBuildExcludesSetHelper(Class<?> type, List<String> fieldNames) {
        try {
            Field declaredField = type.getDeclaredField(fieldNames.get(0));
            if (fieldNames.size() > 1) {
                fieldNames.remove(0);
                this.verifyAndBuildExcludesSetHelper(declaredField.getType(), fieldNames);
            } else {
                this.excludedFields.add(declaredField);
            }
        }
        catch (java.lang.NoSuchFieldException e) {
            throw new NoSuchFieldException(fieldNames.get(0), type, e);
        }
    }

    private void verifyAndBuildLimitersMap(Map<String, Limiter> limiters) {
        Set<Map.Entry<String, Limiter>> entries = limiters.entrySet();
        for (Map.Entry<String, Limiter> entry : entries) {
            String[] fieldNames = entry.getKey().split("\\.");
            List<String> fieldNameList = Arrays.stream(fieldNames).collect(Collectors.toList());
            this.verifyAndBuildLimitersMapHelper(this.clazz, fieldNameList, entry.getValue());
        }
    }

    private void verifyAndBuildLimitersMapHelper(Class<?> type, List<String> fieldNames, Limiter limiter) {
        try {
            Field declaredField = type.getDeclaredField(fieldNames.get(0));
            if (fieldNames.size() > 1) {
                fieldNames.remove(0);
                this.verifyAndBuildLimitersMapHelper(declaredField.getType(), fieldNames, limiter);
            } else {
                this.limiters.put(declaredField, limiter);
            }
        }
        catch (java.lang.NoSuchFieldException e) {
            throw new NoSuchFieldException(fieldNames.get(0), type, e);
        }
    }

    private void addCoreGenerators() {
        this.generators.add(new IntegerGenerator());
        this.generators.add(new LongGenerator());
        this.generators.add(new DoubleGenerator());
        this.generators.add(new FloatGenerator());
        this.generators.add(new ByteGenerator());
        this.generators.add(new BooleanGenerator());
        this.generators.add(new StringGenerator());
        this.generators.add(new ShortGenerator());
        this.generators.add(new CharacterGenerator());
        this.generators.add(new SetGenerator());
        this.generators.add(new ListGenerator());
        this.generators.add(new MapGenerator());
        this.generators.add(new NavigableSetGenerator());
        this.generators.add(new NavigableMapGenerator());
        this.generators.add(new QueueGenerator());
        this.generators.add(new BlockingDequeGenerator());
        this.generators.add(new DateGenerator());
        this.generators.add(new LocalDateTimeGenerator());
        this.generators.add(new LocalDateGenerator());
        this.generators.add(new ZonedDateTimeGenerator());
        this.generators.add(new InstantGenerator());
        this.generators.add(new OffsetDateTimeGenerator());
    }

    public Object buildObject() {
        return this.buildObject(this.clazz);
    }

    private Object buildObject(Class<?> clazz) {
        for (Generator generator : this.generators) {
            if (!generator.supportsType(clazz)) continue;
            return generator.generate(clazz, null, null);
        }
        log.debug("[*] creating object {}.", clazz);
        Object instance = null;
        try {
            ProviderFunction providerFunction = this.providerFunctions.get(clazz);
            if (providerFunction != null) {
                instance = providerFunction.provide();
            }
            if (instance == null) {
                instance = clazz.newInstance();
            }
            log.debug("[*] created object {}.", instance);
            log.debug("[*] attempting to fill the object {}.", instance);
            instance = this.fillInstanceVariables(instance);
        }
        catch (InstantiationException e) {
            log.info("Problems instantiating the object", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.info("Problems accessing properties on the object", (Throwable)e);
        }
        log.debug("[*] completed object: {}", instance);
        return instance;
    }

    private Object fillInstanceVariables(Object instance) {
        Field[] declaredFields = instance.getClass().getDeclaredFields();
        if (declaredFields.length == 0) {
            return instance;
        }
        for (Field f : declaredFields) {
            if (this.excludedFields.contains(f)) {
                log.debug("[*] Skipping due to exclusion. field name: {}, field: {}.", (Object)f.getName(), f.getType());
                continue;
            }
            f.setAccessible(true);
            this.setField(instance, f);
        }
        return instance;
    }

    void setField(Object instance, Field f) {
        Class<Serializable> type = f.getType();
        log.debug("[*] attempting to generate field name: {}, field: {}.", (Object)f.getName(), type);
        try {
            if (type.isAssignableFrom(Integer.TYPE)) {
                f.setInt(instance, (Integer)new IntegerGenerator().generate(type, f, this.limiters.get(f)));
            } else if (type.isAssignableFrom(Double.TYPE)) {
                f.setDouble(instance, (Double)new DoubleGenerator().generate(type, f, this.limiters.get(f)));
            } else if (type.isAssignableFrom(Long.TYPE)) {
                f.setLong(instance, (Long)new LongGenerator().generate(type, f, this.limiters.get(f)));
            } else if (type.isAssignableFrom(Float.TYPE)) {
                f.setFloat(instance, ((Float)new FloatGenerator().generate(type, f, this.limiters.get(f))).floatValue());
            } else if (type.isAssignableFrom(Byte.TYPE)) {
                f.setByte(instance, RandomUtils.getRandomByte());
            } else if (type.isAssignableFrom(Short.TYPE)) {
                f.setShort(instance, (Short)new ShortGenerator().generate(type, f, this.limiters.get(f)));
            } else if (type.isAssignableFrom(Boolean.TYPE)) {
                f.setBoolean(instance, RandomUtils.getRandomBoolean());
            } else if (type.isAssignableFrom(Character.TYPE)) {
                f.setChar(instance, RandomUtils.getRandomCharacter().charValue());
            } else if (type.isEnum()) {
                f.set(instance, type.getEnumConstants()[RandomUtils.getRandomIntWithinRange(type.getEnumConstants().length)]);
            } else if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                log.debug("[*] creating array of type: {}", componentType);
                Object arr = this.generateArray(componentType, this.limiters.get(f));
                f.set(instance, arr);
            } else {
                boolean generated = false;
                for (Generator generator : this.generators) {
                    if (!generator.supportsType(type)) continue;
                    generated = true;
                    f.set(instance, generator.generate(type, f, this.limiters.get(f)));
                    break;
                }
                if (!generated) {
                    f.set(instance, this.buildObject(type));
                }
            }
        }
        catch (IllegalAccessException e) {
            log.debug("[*] Exception trying to generate the field {}", (Object)type.getTypeName(), (Object)e);
        }
    }

    Object generateArray(Class<?> type, Limiter limiter) {
        NullSafeLimits nullSafeLimits = LimiterUtils.getNullSafeLimits(0, 10, limiter);
        int size = nullSafeLimits.length;
        Object arr = Array.newInstance(type, size);
        for (int i = 0; i < size; ++i) {
            if (type.isAssignableFrom(Integer.TYPE)) {
                Array.setInt(arr, i, (Integer)new IntegerGenerator().generate(type, null, limiter));
                continue;
            }
            if (type.isAssignableFrom(Double.TYPE)) {
                Array.setDouble(arr, i, (Double)new DoubleGenerator().generate(type, null, limiter));
                continue;
            }
            if (type.isAssignableFrom(Float.TYPE)) {
                Array.setFloat(arr, i, ((Float)new FloatGenerator().generate(type, null, limiter)).floatValue());
                continue;
            }
            if (type.isAssignableFrom(Long.TYPE)) {
                Array.setLong(arr, i, (Long)new LongGenerator().generate(type, null, limiter));
                continue;
            }
            if (type.isAssignableFrom(Short.TYPE)) {
                Array.setShort(arr, i, (Short)new ShortGenerator().generate(type, null, limiter));
                continue;
            }
            if (type.isAssignableFrom(Byte.TYPE)) {
                Array.setByte(arr, i, RandomUtils.getRandomByte());
                continue;
            }
            if (type.isAssignableFrom(Character.TYPE)) {
                Array.setChar(arr, i, RandomUtils.getRandomCharacter().charValue());
                continue;
            }
            if (type.isAssignableFrom(Boolean.TYPE)) {
                Array.setBoolean(arr, i, RandomUtils.getRandomBoolean());
                continue;
            }
            boolean generated = false;
            for (Generator generator : this.generators) {
                if (!generator.supportsType(type)) continue;
                generated = true;
                Array.set(arr, i, generator.generate(type, null, limiter));
            }
            if (generated) continue;
            Array.set(arr, i, this.buildObject(type));
        }
        return arr;
    }
}

